/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.config.ConfigInheritance;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.internal.ConfigKeySelfExtracting;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.core.task.ValueResolver;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.TypeTokens;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicConfigKey<T>
implements ConfigKeySelfExtracting<T>,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(BasicConfigKey.class);
    private static final long serialVersionUID = -1762014059150215376L;
    private static final Splitter dots = Splitter.on((char)'.');
    protected String name;
    protected Collection<String> deprecatedNames;
    protected TypeToken<T> typeToken;
    protected Class<? super T> type;
    protected String description;
    protected T defaultValue;
    protected boolean reconfigurable;
    protected ConfigInheritance typeInheritance;
    protected ConfigInheritance runtimeInheritance;
    protected Predicate<? super T> constraint;
    @Deprecated
    private ConfigInheritance inheritance;
    @Deprecated
    protected ConfigInheritance parentInheritance;

    public static <T> Builder<T, ?> builder(TypeToken<T> type) {
        return new ConcreteBuilder<T>().type(type);
    }

    public static <T> Builder<T, ?> builder(Class<T> type) {
        return new ConcreteBuilder<T>().type(type);
    }

    public static <T> Builder<T, ?> builder(TypeToken<T> type, String name) {
        return new ConcreteBuilder<T>(type, name);
    }

    public static <T> Builder<T, ?> builder(Class<T> type, String name) {
        return ((ConcreteBuilder)new ConcreteBuilder<T>().type(type)).name(name);
    }

    public static <T> Builder<T, ?> builder(String newName, ConfigKey<T> key) {
        return new ConcreteBuilder<T>(newName, key);
    }

    public static <T> Builder<T, ?> builder(ConfigKey<T> key) {
        return new ConcreteBuilder<T>(key);
    }

    public BasicConfigKey() {
    }

    public BasicConfigKey(Class<T> type, String name) {
        this(type, null, name, null, null);
    }

    public BasicConfigKey(Class<T> type, String name, String description) {
        this(type, null, name, description, null);
    }

    public BasicConfigKey(Class<T> type, String name, String description, T defaultValue) {
        this(type, null, name, description, defaultValue);
    }

    public BasicConfigKey(TypeToken<T> type, String name) {
        this(null, type, name, name, null);
    }

    public BasicConfigKey(TypeToken<T> type, String name, String description) {
        this(null, type, name, description, null);
    }

    public BasicConfigKey(TypeToken<T> type, String name, String description, T defaultValue) {
        this(null, type, name, description, defaultValue);
    }

    private BasicConfigKey(Class<T> typeC, TypeToken<T> typeT, String name, String description, T defaultValue) {
        this.description = description;
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.deprecatedNames = ImmutableList.of();
        this.type = typeC;
        this.typeToken = typeT;
        this.defaultValue = defaultValue;
        this.reconfigurable = false;
        this.constraint = Predicates.alwaysTrue();
    }

    public BasicConfigKey(Builder<T, ?> builder) {
        this.name = (String)Preconditions.checkNotNull((Object)builder.name, (Object)"name");
        this.deprecatedNames = (Collection)Preconditions.checkNotNull(builder.deprecatedNames, (Object)"deprecatedNames");
        TypeTokens.checkCompatibleOneNonNull(builder.type, builder.typeToken);
        this.type = builder.type;
        this.typeToken = builder.typeToken;
        this.description = builder.description;
        this.defaultValue = builder.defaultValue;
        this.reconfigurable = builder.reconfigurable;
        this.runtimeInheritance = builder.runtimeInheritance;
        this.typeInheritance = builder.typeInheritance;
        this.constraint = (Predicate)Preconditions.checkNotNull(builder.constraint, (Object)"constraint");
    }

    public String getName() {
        return this.name;
    }

    public Collection<String> getDeprecatedNames() {
        if (this.deprecatedNames == null) {
            this.deprecatedNames = ImmutableList.of();
        }
        return this.deprecatedNames;
    }

    @JsonIgnore
    public String getTypeName() {
        return this.getTypeToken().toString();
    }

    public Class<? super T> getType() {
        return TypeTokens.getRawType(this.typeToken, this.type);
    }

    public TypeToken<T> getTypeToken() {
        return TypeTokens.getTypeToken(this.typeToken, this.type);
    }

    public String getDescription() {
        return this.description;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public boolean isReconfigurable() {
        return this.reconfigurable;
    }

    @Nullable
    public ConfigInheritance getInheritanceByContext(ConfigInheritance.ConfigInheritanceContext context) {
        if (context == ConfigKeys.InheritanceContext.RUNTIME_MANAGEMENT) {
            if (this.parentInheritance != null) {
                this.runtimeInheritance = this.parentInheritance;
                this.parentInheritance = null;
            }
            if (this.inheritance != null) {
                this.runtimeInheritance = this.inheritance;
                this.inheritance = null;
            }
            return this.runtimeInheritance;
        }
        if (context == ConfigKeys.InheritanceContext.TYPE_DEFINITION) {
            return this.typeInheritance;
        }
        return null;
    }

    @JsonIgnore
    public Map<ConfigInheritance.ConfigInheritanceContext, ConfigInheritance> getInheritanceByContext() {
        MutableMap result = MutableMap.of();
        for (ConfigKeys.InheritanceContext context : ConfigKeys.InheritanceContext.values()) {
            result.addIfNotNull((Object)context, (Object)this.getInheritanceByContext(context));
        }
        return result;
    }

    @Deprecated
    @Nullable
    public ConfigInheritance getInheritance() {
        return this.getParentInheritance();
    }

    @Deprecated
    @Nullable
    public ConfigInheritance getTypeInheritance() {
        return this.typeInheritance;
    }

    @Deprecated
    @Nullable
    public ConfigInheritance getParentInheritance() {
        if (this.parentInheritance == null && this.inheritance != null) {
            this.parentInheritance = this.inheritance;
            this.inheritance = null;
        }
        return this.parentInheritance;
    }

    @Nonnull
    public Predicate<? super T> getConstraint() {
        if (this.constraint != null) {
            return this.constraint;
        }
        return Predicates.alwaysTrue();
    }

    public boolean isValueValid(T value) {
        try {
            return this.getConstraint().apply(value);
        }
        catch (Exception e) {
            log.debug("Suppressing exception when testing validity of " + this, (Throwable)e);
            return false;
        }
    }

    @JsonIgnore
    @Deprecated
    public Collection<String> getNameParts() {
        return Lists.newArrayList((Iterable)dots.split((CharSequence)this.name));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BasicConfigKey)) {
            return false;
        }
        BasicConfigKey o = (BasicConfigKey)obj;
        return Objects.equal((Object)this.name, (Object)o.name);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name});
    }

    public String toString() {
        return String.format("%s[ConfigKey:%s]", this.name, this.getTypeName());
    }

    @Override
    public T extractValue(Map<?, ?> vals, ExecutionContext exec) {
        Object v = vals.get(this);
        try {
            return (T)this.resolveValue(v, exec);
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    @Override
    public boolean isSet(Map<?, ?> vals) {
        return vals.containsKey(this);
    }

    protected Object resolveValue(Object v, ExecutionContext exec) throws ExecutionException, InterruptedException {
        Exception e1 = null;
        if (Tasks.ForTestingAndLegacyCompatibilityOnly.LEGACY_DEEP_RESOLUTION_MODE != Tasks.ForTestingAndLegacyCompatibilityOnly.LegacyDeepResolutionMode.ONLY_LEGACY) {
            try {
                return Tasks.resolveDeepValueCoerced(v, this.getTypeToken(), exec, "config " + this.name);
            }
            catch (Exception e) {
                if (Tasks.ForTestingAndLegacyCompatibilityOnly.LEGACY_DEEP_RESOLUTION_MODE == Tasks.ForTestingAndLegacyCompatibilityOnly.LegacyDeepResolutionMode.DISALLOW_LEGACY) {
                    throw Exceptions.propagateAnnotated((String)("Cannot resolve " + v + " for " + this), (Throwable)e);
                }
                e1 = e;
            }
        }
        try {
            Object result = ValueResolver.supportsDeepResolution(v, null) ? Tasks.resolveDeepValueWithoutCoercion(v, exec, "Resolving deep config " + this.name) : Tasks.resolveValue(v, this.getTypeToken(), exec, "Resolving config " + this.name);
            if (Tasks.ForTestingAndLegacyCompatibilityOnly.LEGACY_DEEP_RESOLUTION_MODE == Tasks.ForTestingAndLegacyCompatibilityOnly.LegacyDeepResolutionMode.WARN) {
                log.warn("Conversion of '" + this + "' (" + v + ") to " + this.type + " failed; leaving as map/list type for legacy compatibility, but this feature may be removed in future");
            }
            return result;
        }
        catch (Exception e2) {
            Exceptions.propagateIfFatal((Throwable)e2);
            throw Exceptions.propagateAnnotated((String)("Cannot resolve " + v + " for " + this), (Throwable)e1);
        }
    }

    public static class BasicConfigKeyOverwriting<T>
    extends BasicConfigKey<T> {
        private static final long serialVersionUID = -3458116971918128018L;
        private final ConfigKey<T> parentKey;

        @Beta
        public BasicConfigKeyOverwriting(Builder<T, ?> builder, ConfigKey<T> parent) {
            super(builder);
            this.parentKey = parent;
            Preconditions.checkArgument((boolean)Objects.equal((Object)builder.name, (Object)parent.getName()), (Object)"Builder must use key of the same name.");
        }

        public BasicConfigKeyOverwriting(ConfigKey<T> key, T defaultValue) {
            this((Builder<T, ?>)BasicConfigKeyOverwriting.builder(key).defaultValue(defaultValue), key);
        }

        public BasicConfigKeyOverwriting(ConfigKey<T> key, String newDescription, T defaultValue) {
            this((Builder<T, ?>)((Builder)BasicConfigKeyOverwriting.builder(key).description(newDescription)).defaultValue(defaultValue), key);
        }

        public ConfigKey<T> getParentKey() {
            return this.parentKey;
        }
    }

    public static abstract class Builder<T, B extends Builder<T, B>> {
        protected String name;
        protected Collection<String> deprecatedNames = ImmutableList.of();
        protected Class<T> type;
        protected TypeToken<T> typeToken;
        protected String description;
        protected T defaultValue;
        protected boolean reconfigurable;
        protected Predicate<? super T> constraint = Predicates.alwaysTrue();
        protected ConfigInheritance runtimeInheritance;
        protected ConfigInheritance typeInheritance;

        protected abstract B self();

        public Builder() {
        }

        public Builder(TypeToken<T> type, String name) {
            this.typeToken = type;
            this.name = name;
        }

        public Builder(Class<T> type, String name) {
            this.type = type;
            this.name = name;
        }

        public Builder(ConfigKey<T> key) {
            this(key.getName(), key);
        }

        public Builder(String newName, ConfigKey<T> key) {
            TypeToken tt = key.getTypeToken();
            this.type = TypeTokens.getRawTypeIfRaw((TypeToken)tt);
            this.typeToken = TypeTokens.getTypeTokenIfNotRaw((TypeToken)tt);
            this.name = (String)Preconditions.checkNotNull((Object)newName, (Object)"name");
            this.deprecatedNames = (Collection)Preconditions.checkNotNull((Object)key.getDeprecatedNames(), (Object)"deprecatedNames");
            this.description(key.getDescription());
            this.defaultValue(key.getDefaultValue());
            this.reconfigurable(key.isReconfigurable());
            this.runtimeInheritance(key.getInheritanceByContext((ConfigInheritance.ConfigInheritanceContext)ConfigKeys.InheritanceContext.RUNTIME_MANAGEMENT));
            this.typeInheritance(key.getInheritanceByContext((ConfigInheritance.ConfigInheritanceContext)ConfigKeys.InheritanceContext.TYPE_DEFINITION));
            this.constraint(key.getConstraint());
        }

        public B name(String val) {
            this.name = val;
            return this.self();
        }

        public B deprecatedNames(Collection<String> val) {
            this.deprecatedNames = val;
            return this.self();
        }

        public B deprecatedNames(String ... val) {
            return this.deprecatedNames((Collection<String>)(val == null ? ImmutableList.of() : ImmutableList.copyOf((Object[])val)));
        }

        public B type(Class<T> val) {
            this.type = val;
            return this.self();
        }

        public B type(TypeToken<T> val) {
            this.typeToken = val;
            return this.self();
        }

        public B description(String val) {
            this.description = val;
            return this.self();
        }

        public B defaultValue(T val) {
            this.defaultValue = val;
            return this.self();
        }

        public B reconfigurable(boolean val) {
            this.reconfigurable = val;
            return this.self();
        }

        @Deprecated
        public B parentInheritance(ConfigInheritance val) {
            this.runtimeInheritance = val;
            return this.self();
        }

        public B runtimeInheritance(ConfigInheritance val) {
            this.runtimeInheritance = val;
            return this.self();
        }

        public B typeInheritance(ConfigInheritance val) {
            this.typeInheritance = val;
            return this.self();
        }

        @Deprecated
        public B inheritance(ConfigInheritance val) {
            return this.runtimeInheritance(val);
        }

        @Beta
        public B constraint(Predicate<? super T> constraint) {
            this.constraint = (Predicate)Preconditions.checkNotNull(constraint, (Object)"constraint");
            return this.self();
        }

        public BasicConfigKey<T> build() {
            return new BasicConfigKey(this);
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }

    private static class ConcreteBuilder<T>
    extends Builder<T, ConcreteBuilder<T>> {
        public ConcreteBuilder() {
        }

        public ConcreteBuilder(TypeToken<T> type, String name) {
            super(type, name);
        }

        public ConcreteBuilder(String newName, ConfigKey<T> key) {
            super(newName, key);
        }

        public ConcreteBuilder(ConfigKey<T> key) {
            super(key);
        }

        @Override
        protected ConcreteBuilder<T> self() {
            return this;
        }
    }
}

