/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloudstorage.blobstore;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.io.BaseEncoding;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.net.URI;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Map;
import javax.annotation.Resource;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.date.TimeStamp;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.Uris;
import org.jclouds.http.options.GetOptions;
import org.jclouds.location.Provider;
import org.jclouds.logging.Logger;
import org.jclouds.oauth.v2.config.Authorization;

public final class GoogleCloudStorageBlobRequestSigner
implements BlobRequestSigner {
    private static final int DEFAULT_EXPIRY_SECONDS = 900;
    private static final URI STORAGE_URL = URI.create("http://storage.googleapis.com/");
    private final Supplier<Credentials> creds;
    private final Supplier<PrivateKey> privateKey;
    private final javax.inject.Provider<Long> timestamp;
    private final HttpUtils utils;
    private final BlobToHttpGetOptions toGetOptions = new BlobToHttpGetOptions();
    @Resource
    @Named(value="jclouds.signature")
    protected Logger signatureLog = Logger.NULL;

    @Inject
    protected GoogleCloudStorageBlobRequestSigner(@Provider Supplier<Credentials> creds, @Authorization Supplier<PrivateKey> privateKey, @TimeStamp javax.inject.Provider<Long> timestamp, HttpUtils utils) {
        this.creds = creds;
        this.privateKey = privateKey;
        this.timestamp = timestamp;
        this.utils = utils;
    }

    public HttpRequest signGetBlob(String container, String name) {
        return this.signGetBlob(container, name, 900L);
    }

    public HttpRequest signGetBlob(String container, String name, long timeInSeconds) {
        return this.sign("GET", container, name, GetOptions.NONE, (Long)this.timestamp.get() + timeInSeconds, null);
    }

    public HttpRequest signGetBlob(String container, String name, org.jclouds.blobstore.options.GetOptions options) {
        return this.sign("GET", container, name, this.toGetOptions.apply(options), (Long)this.timestamp.get() + 900L, null);
    }

    public HttpRequest signPutBlob(String container, Blob blob) {
        return this.signPutBlob(container, blob, 900L);
    }

    public HttpRequest signPutBlob(String container, Blob blob, long timeInSeconds) {
        return this.sign("PUT", container, blob.getMetadata().getName(), GetOptions.NONE, (Long)this.timestamp.get() + timeInSeconds, blob.getMetadata().getContentMetadata().getContentType());
    }

    private HttpRequest sign(String method, String container, String name, GetOptions options, long expires, String contentType) {
        byte[] rawSignature;
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        HttpRequest.Builder request = HttpRequest.builder().method(method).endpoint(Uris.uriBuilder((URI)STORAGE_URL).appendPath(container).appendPath(name).build());
        if (contentType != null) {
            request.replaceHeader("Content-Type", new String[]{contentType});
        }
        String stringToSign = this.createStringToSign(request.build(), expires);
        try {
            Signature signer = Signature.getInstance("SHA256withRSA");
            signer.initSign((PrivateKey)this.privateKey.get());
            signer.update(stringToSign.getBytes(Charsets.UTF_8));
            rawSignature = signer.sign();
        }
        catch (InvalidKeyException ike) {
            throw new RuntimeException(ike);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException(nsae);
        }
        catch (SignatureException se) {
            throw new RuntimeException(se);
        }
        String signature = BaseEncoding.base64().encode(rawSignature);
        for (Map.Entry entry : options.buildRequestHeaders().entries()) {
            request.addHeader((String)entry.getKey(), new String[]{(String)entry.getValue()});
        }
        return request.addQueryParam("Expires", new String[]{String.valueOf(expires)}).addQueryParam("GoogleAccessId", new String[]{((Credentials)this.creds.get()).identity}).addQueryParam("Signature", new String[]{signature}).build();
    }

    private String createStringToSign(HttpRequest request, long expires) {
        this.utils.logRequest(this.signatureLog, request, ">>");
        StringBuilder buffer = new StringBuilder();
        buffer.append(request.getMethod()).append("\n");
        buffer.append(Strings.nullToEmpty((String)request.getFirstHeaderOrNull("Content-MD5"))).append("\n");
        buffer.append(Strings.nullToEmpty((String)request.getFirstHeaderOrNull("Content-Type"))).append("\n");
        buffer.append(String.valueOf(expires)).append("\n");
        buffer.append(request.getEndpoint().getPath());
        return buffer.toString();
    }
}

