/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.config.v1.ConfigMapNameReference;
import io.fabric8.openshift.api.model.operator.v1.ClientTLS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ClientTLSFluent<A extends ClientTLSFluent<A>>
extends BaseFluent<A> {
    private List<String> allowedSubjectPatterns = new ArrayList<String>();
    private ConfigMapNameReference clientCA;
    private String clientCertificatePolicy;
    private Map<String, Object> additionalProperties;

    public ClientTLSFluent() {
    }

    public ClientTLSFluent(ClientTLS instance) {
        ClientTLS clientTLS = instance = instance != null ? instance : new ClientTLS();
        if (instance != null) {
            this.withAllowedSubjectPatterns(instance.getAllowedSubjectPatterns());
            this.withClientCA(instance.getClientCA());
            this.withClientCertificatePolicy(instance.getClientCertificatePolicy());
            this.withAllowedSubjectPatterns(instance.getAllowedSubjectPatterns());
            this.withClientCA(instance.getClientCA());
            this.withClientCertificatePolicy(instance.getClientCertificatePolicy());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAllowedSubjectPatterns(int index, String item) {
        if (this.allowedSubjectPatterns == null) {
            this.allowedSubjectPatterns = new ArrayList<String>();
        }
        this.allowedSubjectPatterns.add(index, item);
        return (A)((Object)this);
    }

    public A setToAllowedSubjectPatterns(int index, String item) {
        if (this.allowedSubjectPatterns == null) {
            this.allowedSubjectPatterns = new ArrayList<String>();
        }
        this.allowedSubjectPatterns.set(index, item);
        return (A)((Object)this);
    }

    public A addToAllowedSubjectPatterns(String ... items) {
        if (this.allowedSubjectPatterns == null) {
            this.allowedSubjectPatterns = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedSubjectPatterns.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToAllowedSubjectPatterns(Collection<String> items) {
        if (this.allowedSubjectPatterns == null) {
            this.allowedSubjectPatterns = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedSubjectPatterns.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAllowedSubjectPatterns(String ... items) {
        if (this.allowedSubjectPatterns == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.allowedSubjectPatterns.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAllowedSubjectPatterns(Collection<String> items) {
        if (this.allowedSubjectPatterns == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.allowedSubjectPatterns.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getAllowedSubjectPatterns() {
        return this.allowedSubjectPatterns;
    }

    public String getAllowedSubjectPattern(int index) {
        return this.allowedSubjectPatterns.get(index);
    }

    public String getFirstAllowedSubjectPattern() {
        return this.allowedSubjectPatterns.get(0);
    }

    public String getLastAllowedSubjectPattern() {
        return this.allowedSubjectPatterns.get(this.allowedSubjectPatterns.size() - 1);
    }

    public String getMatchingAllowedSubjectPattern(Predicate<String> predicate) {
        for (String item : this.allowedSubjectPatterns) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAllowedSubjectPattern(Predicate<String> predicate) {
        for (String item : this.allowedSubjectPatterns) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAllowedSubjectPatterns(List<String> allowedSubjectPatterns) {
        if (allowedSubjectPatterns != null) {
            this.allowedSubjectPatterns = new ArrayList<String>();
            for (String item : allowedSubjectPatterns) {
                this.addToAllowedSubjectPatterns(item);
            }
        } else {
            this.allowedSubjectPatterns = null;
        }
        return (A)((Object)this);
    }

    public A withAllowedSubjectPatterns(String ... allowedSubjectPatterns) {
        if (this.allowedSubjectPatterns != null) {
            this.allowedSubjectPatterns.clear();
            this._visitables.remove((Object)"allowedSubjectPatterns");
        }
        if (allowedSubjectPatterns != null) {
            for (String item : allowedSubjectPatterns) {
                this.addToAllowedSubjectPatterns(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAllowedSubjectPatterns() {
        return this.allowedSubjectPatterns != null && !this.allowedSubjectPatterns.isEmpty();
    }

    public ConfigMapNameReference getClientCA() {
        return this.clientCA;
    }

    public A withClientCA(ConfigMapNameReference clientCA) {
        this.clientCA = clientCA;
        return (A)((Object)this);
    }

    public boolean hasClientCA() {
        return this.clientCA != null;
    }

    public A withNewClientCA(String name) {
        return this.withClientCA(new ConfigMapNameReference(name));
    }

    public String getClientCertificatePolicy() {
        return this.clientCertificatePolicy;
    }

    public A withClientCertificatePolicy(String clientCertificatePolicy) {
        this.clientCertificatePolicy = clientCertificatePolicy;
        return (A)((Object)this);
    }

    public boolean hasClientCertificatePolicy() {
        return this.clientCertificatePolicy != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClientTLSFluent that = (ClientTLSFluent)((Object)o);
        if (!Objects.equals(this.allowedSubjectPatterns, that.allowedSubjectPatterns)) {
            return false;
        }
        if (!Objects.equals(this.clientCA, that.clientCA)) {
            return false;
        }
        if (!Objects.equals(this.clientCertificatePolicy, that.clientCertificatePolicy)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.allowedSubjectPatterns, this.clientCA, this.clientCertificatePolicy, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allowedSubjectPatterns != null && !this.allowedSubjectPatterns.isEmpty()) {
            sb.append("allowedSubjectPatterns:");
            sb.append(this.allowedSubjectPatterns + ",");
        }
        if (this.clientCA != null) {
            sb.append("clientCA:");
            sb.append(this.clientCA + ",");
        }
        if (this.clientCertificatePolicy != null) {
            sb.append("clientCertificatePolicy:");
            sb.append(this.clientCertificatePolicy + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

