/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.logbook;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.brooklyn.api.mgmt.HasTaskChildren;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.logbook.BrooklynLogEntry;
import org.apache.brooklyn.util.core.logbook.LogBookQueryParams;

public interface LogStore {
    public List<BrooklynLogEntry> query(LogBookQueryParams var1) throws IOException;

    public Set<String> enumerateTaskIds(Set<?> var1, int var2);

    public static Set<String> enumerateTaskIdsDefault(ManagementContext mgmt, Set<?> parentTaskOrIds, int maxTasks) {
        MutableSet children;
        MutableSet tasks = MutableSet.of();
        MutableSet current = MutableSet.of();
        if (parentTaskOrIds != null) {
            for (Object t : parentTaskOrIds) {
                if (t instanceof String) {
                    t = mgmt.getExecutionManager().getTask((String)t);
                }
                if (t instanceof Task) {
                    current.add((Task)t);
                    continue;
                }
                if (t == null) continue;
                throw new IllegalArgumentException("Can only enumerate given task ID or string");
            }
        }
        block1: do {
            children = MutableSet.of();
            for (Task task : current) {
                if (!(task instanceof HasTaskChildren)) continue;
                Iterables.addAll((Collection)children, (Iterable)((HasTaskChildren)task).getChildren());
                for (Task child : children) {
                    if (!tasks.add(child.getId()) || tasks.size() < maxTasks) continue;
                    break block1;
                }
            }
            current = children;
        } while (children.size() > 0);
        return tasks;
    }
}

