/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.aws.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.hive.aws.v1.EC2RootVolume;
import io.fabric8.openshift.api.model.hive.aws.v1.EC2RootVolumeBuilder;
import io.fabric8.openshift.api.model.hive.aws.v1.EC2RootVolumeFluent;
import io.fabric8.openshift.api.model.hive.aws.v1.MachinePoolPlatform;
import io.fabric8.openshift.api.model.hive.aws.v1.SpotMarketOptions;
import io.fabric8.openshift.api.model.hive.aws.v1.SpotMarketOptionsBuilder;
import io.fabric8.openshift.api.model.hive.aws.v1.SpotMarketOptionsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class MachinePoolPlatformFluent<A extends MachinePoolPlatformFluent<A>>
extends BaseFluent<A> {
    private EC2RootVolumeBuilder rootVolume;
    private SpotMarketOptionsBuilder spotMarketOptions;
    private List<String> subnets = new ArrayList<String>();
    private String type;
    private List<String> zones = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public MachinePoolPlatformFluent() {
    }

    public MachinePoolPlatformFluent(MachinePoolPlatform instance) {
        MachinePoolPlatform machinePoolPlatform = instance = instance != null ? instance : new MachinePoolPlatform();
        if (instance != null) {
            this.withRootVolume(instance.getRootVolume());
            this.withSpotMarketOptions(instance.getSpotMarketOptions());
            this.withSubnets(instance.getSubnets());
            this.withType(instance.getType());
            this.withZones(instance.getZones());
            this.withRootVolume(instance.getRootVolume());
            this.withSpotMarketOptions(instance.getSpotMarketOptions());
            this.withSubnets(instance.getSubnets());
            this.withType(instance.getType());
            this.withZones(instance.getZones());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public EC2RootVolume buildRootVolume() {
        return this.rootVolume != null ? this.rootVolume.build() : null;
    }

    public A withRootVolume(EC2RootVolume rootVolume) {
        this._visitables.get((Object)"rootVolume").remove((Object)this.rootVolume);
        if (rootVolume != null) {
            this.rootVolume = new EC2RootVolumeBuilder(rootVolume);
            this._visitables.get((Object)"rootVolume").add(this.rootVolume);
        } else {
            this.rootVolume = null;
            this._visitables.get((Object)"rootVolume").remove((Object)this.rootVolume);
        }
        return (A)((Object)this);
    }

    public boolean hasRootVolume() {
        return this.rootVolume != null;
    }

    public A withNewRootVolume(Integer iops, String kmsKeyARN, Integer size, String type) {
        return this.withRootVolume(new EC2RootVolume(iops, kmsKeyARN, size, type));
    }

    public RootVolumeNested<A> withNewRootVolume() {
        return new RootVolumeNested(null);
    }

    public RootVolumeNested<A> withNewRootVolumeLike(EC2RootVolume item) {
        return new RootVolumeNested(item);
    }

    public RootVolumeNested<A> editRootVolume() {
        return this.withNewRootVolumeLike(Optional.ofNullable(this.buildRootVolume()).orElse(null));
    }

    public RootVolumeNested<A> editOrNewRootVolume() {
        return this.withNewRootVolumeLike(Optional.ofNullable(this.buildRootVolume()).orElse(new EC2RootVolumeBuilder().build()));
    }

    public RootVolumeNested<A> editOrNewRootVolumeLike(EC2RootVolume item) {
        return this.withNewRootVolumeLike(Optional.ofNullable(this.buildRootVolume()).orElse(item));
    }

    public SpotMarketOptions buildSpotMarketOptions() {
        return this.spotMarketOptions != null ? this.spotMarketOptions.build() : null;
    }

    public A withSpotMarketOptions(SpotMarketOptions spotMarketOptions) {
        this._visitables.get((Object)"spotMarketOptions").remove((Object)this.spotMarketOptions);
        if (spotMarketOptions != null) {
            this.spotMarketOptions = new SpotMarketOptionsBuilder(spotMarketOptions);
            this._visitables.get((Object)"spotMarketOptions").add(this.spotMarketOptions);
        } else {
            this.spotMarketOptions = null;
            this._visitables.get((Object)"spotMarketOptions").remove((Object)this.spotMarketOptions);
        }
        return (A)((Object)this);
    }

    public boolean hasSpotMarketOptions() {
        return this.spotMarketOptions != null;
    }

    public A withNewSpotMarketOptions(String maxPrice) {
        return this.withSpotMarketOptions(new SpotMarketOptions(maxPrice));
    }

    public SpotMarketOptionsNested<A> withNewSpotMarketOptions() {
        return new SpotMarketOptionsNested(null);
    }

    public SpotMarketOptionsNested<A> withNewSpotMarketOptionsLike(SpotMarketOptions item) {
        return new SpotMarketOptionsNested(item);
    }

    public SpotMarketOptionsNested<A> editSpotMarketOptions() {
        return this.withNewSpotMarketOptionsLike(Optional.ofNullable(this.buildSpotMarketOptions()).orElse(null));
    }

    public SpotMarketOptionsNested<A> editOrNewSpotMarketOptions() {
        return this.withNewSpotMarketOptionsLike(Optional.ofNullable(this.buildSpotMarketOptions()).orElse(new SpotMarketOptionsBuilder().build()));
    }

    public SpotMarketOptionsNested<A> editOrNewSpotMarketOptionsLike(SpotMarketOptions item) {
        return this.withNewSpotMarketOptionsLike(Optional.ofNullable(this.buildSpotMarketOptions()).orElse(item));
    }

    public A addToSubnets(int index, String item) {
        if (this.subnets == null) {
            this.subnets = new ArrayList<String>();
        }
        this.subnets.add(index, item);
        return (A)((Object)this);
    }

    public A setToSubnets(int index, String item) {
        if (this.subnets == null) {
            this.subnets = new ArrayList<String>();
        }
        this.subnets.set(index, item);
        return (A)((Object)this);
    }

    public A addToSubnets(String ... items) {
        if (this.subnets == null) {
            this.subnets = new ArrayList<String>();
        }
        for (String item : items) {
            this.subnets.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToSubnets(Collection<String> items) {
        if (this.subnets == null) {
            this.subnets = new ArrayList<String>();
        }
        for (String item : items) {
            this.subnets.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromSubnets(String ... items) {
        if (this.subnets == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.subnets.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSubnets(Collection<String> items) {
        if (this.subnets == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.subnets.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getSubnets() {
        return this.subnets;
    }

    public String getSubnet(int index) {
        return this.subnets.get(index);
    }

    public String getFirstSubnet() {
        return this.subnets.get(0);
    }

    public String getLastSubnet() {
        return this.subnets.get(this.subnets.size() - 1);
    }

    public String getMatchingSubnet(Predicate<String> predicate) {
        for (String item : this.subnets) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingSubnet(Predicate<String> predicate) {
        for (String item : this.subnets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSubnets(List<String> subnets) {
        if (subnets != null) {
            this.subnets = new ArrayList<String>();
            for (String item : subnets) {
                this.addToSubnets(item);
            }
        } else {
            this.subnets = null;
        }
        return (A)((Object)this);
    }

    public A withSubnets(String ... subnets) {
        if (this.subnets != null) {
            this.subnets.clear();
            this._visitables.remove((Object)"subnets");
        }
        if (subnets != null) {
            for (String item : subnets) {
                this.addToSubnets(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSubnets() {
        return this.subnets != null && !this.subnets.isEmpty();
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type = type;
        return (A)((Object)this);
    }

    public boolean hasType() {
        return this.type != null;
    }

    public A addToZones(int index, String item) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        this.zones.add(index, item);
        return (A)((Object)this);
    }

    public A setToZones(int index, String item) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        this.zones.set(index, item);
        return (A)((Object)this);
    }

    public A addToZones(String ... items) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        for (String item : items) {
            this.zones.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToZones(Collection<String> items) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        for (String item : items) {
            this.zones.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromZones(String ... items) {
        if (this.zones == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.zones.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromZones(Collection<String> items) {
        if (this.zones == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.zones.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getZones() {
        return this.zones;
    }

    public String getZone(int index) {
        return this.zones.get(index);
    }

    public String getFirstZone() {
        return this.zones.get(0);
    }

    public String getLastZone() {
        return this.zones.get(this.zones.size() - 1);
    }

    public String getMatchingZone(Predicate<String> predicate) {
        for (String item : this.zones) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingZone(Predicate<String> predicate) {
        for (String item : this.zones) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withZones(List<String> zones) {
        if (zones != null) {
            this.zones = new ArrayList<String>();
            for (String item : zones) {
                this.addToZones(item);
            }
        } else {
            this.zones = null;
        }
        return (A)((Object)this);
    }

    public A withZones(String ... zones) {
        if (this.zones != null) {
            this.zones.clear();
            this._visitables.remove((Object)"zones");
        }
        if (zones != null) {
            for (String item : zones) {
                this.addToZones(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasZones() {
        return this.zones != null && !this.zones.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachinePoolPlatformFluent that = (MachinePoolPlatformFluent)((Object)o);
        if (!Objects.equals((Object)this.rootVolume, (Object)that.rootVolume)) {
            return false;
        }
        if (!Objects.equals((Object)this.spotMarketOptions, (Object)that.spotMarketOptions)) {
            return false;
        }
        if (!Objects.equals(this.subnets, that.subnets)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        if (!Objects.equals(this.zones, that.zones)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.rootVolume, this.spotMarketOptions, this.subnets, this.type, this.zones, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.rootVolume != null) {
            sb.append("rootVolume:");
            sb.append((Object)((Object)this.rootVolume) + ",");
        }
        if (this.spotMarketOptions != null) {
            sb.append("spotMarketOptions:");
            sb.append((Object)((Object)this.spotMarketOptions) + ",");
        }
        if (this.subnets != null && !this.subnets.isEmpty()) {
            sb.append("subnets:");
            sb.append(this.subnets + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.zones != null && !this.zones.isEmpty()) {
            sb.append("zones:");
            sb.append(this.zones + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SpotMarketOptionsNested<N>
    extends SpotMarketOptionsFluent<SpotMarketOptionsNested<N>>
    implements Nested<N> {
        SpotMarketOptionsBuilder builder;

        SpotMarketOptionsNested(SpotMarketOptions item) {
            this.builder = new SpotMarketOptionsBuilder(this, item);
        }

        public N and() {
            return (N)MachinePoolPlatformFluent.this.withSpotMarketOptions(this.builder.build());
        }

        public N endSpotMarketOptions() {
            return this.and();
        }
    }

    public class RootVolumeNested<N>
    extends EC2RootVolumeFluent<RootVolumeNested<N>>
    implements Nested<N> {
        EC2RootVolumeBuilder builder;

        RootVolumeNested(EC2RootVolume item) {
            this.builder = new EC2RootVolumeBuilder(this, item);
        }

        public N and() {
            return (N)MachinePoolPlatformFluent.this.withRootVolume(this.builder.build());
        }

        public N endRootVolume() {
            return this.and();
        }
    }
}

