/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.jclouds.cloudstack.domain.NIC;
import org.jclouds.cloudstack.domain.SecurityGroup;
import org.jclouds.cloudstack.domain.Tag;
import org.jclouds.javax.annotation.Nullable;

public class VirtualMachine {
    private final String id;
    private final String account;
    private final long cpuCount;
    private final long cpuSpeed;
    private final String cpuUsed;
    private final String displayName;
    private final Date created;
    private final String domain;
    private final String domainId;
    private final boolean usesVirtualNetwork;
    private final String group;
    private final String groupId;
    private final String guestOSId;
    private final boolean HAEnabled;
    private final String hostId;
    private final String hostname;
    private final String IPAddress;
    private final String ISODisplayText;
    private final String ISOId;
    private final String ISOName;
    private final String jobId;
    private final Integer jobStatus;
    private final long memory;
    private final String name;
    private final Long networkKbsRead;
    private final Long networkKbsWrite;
    private final String password;
    private final boolean passwordEnabled;
    private final String publicIP;
    private final String publicIPId;
    private final String rootDeviceId;
    private final String rootDeviceType;
    private final String serviceOfferingId;
    private final String serviceOfferingName;
    private final State state;
    private final String templateDisplayText;
    private final String templateId;
    private final String templateName;
    private final String zoneId;
    private final String zoneName;
    private final Set<NIC> nics;
    private final String hypervisor;
    private final Set<SecurityGroup> securityGroups;
    private final Set<Tag> tags;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromVirtualMachine(this);
    }

    @ConstructorProperties(value={"id", "account", "cpunumber", "cpuspeed", "cpuused", "displayname", "created", "domain", "domainid", "forvirtualnetwork", "group", "groupid", "guestosid", "haenable", "hostid", "hostname", "ipaddress", "isodisplaytext", "isoid", "isoname", "jobid", "jobstatus", "memory", "name", "networkkbsread", "networkkbswrite", "password", "passwordenabled", "publicip", "publicipid", "rootdeviceid", "rootdevicetype", "serviceofferingid", "serviceofferingname", "state", "templatedisplaytext", "templateid", "templatename", "zoneid", "zonename", "nic", "hypervisor", "securitygroup", "tags"})
    protected VirtualMachine(String id, @Nullable String account, long cpuCount, long cpuSpeed, @Nullable String cpuUsed, @Nullable String displayName, @Nullable Date created, @Nullable String domain, @Nullable String domainId, boolean usesVirtualNetwork, @Nullable String group, @Nullable String groupId, @Nullable String guestOSId, boolean HAEnabled, @Nullable String hostId, @Nullable String hostname, String IPAddress, String ISODisplayText, @Nullable String ISOId, @Nullable String ISOName, @Nullable String jobId, @Nullable Integer jobStatus, long memory, @Nullable String name, @Nullable Long networkKbsRead, @Nullable Long networkKbsWrite, @Nullable String password, boolean passwordEnabled, @Nullable String publicIP, @Nullable String publicIPId, @Nullable String rootDeviceId, @Nullable String rootDeviceType, @Nullable String serviceOfferingId, @Nullable String serviceOfferingName, @Nullable State state, @Nullable String templateDisplayText, @Nullable String templateId, @Nullable String templateName, @Nullable String zoneId, @Nullable String zoneName, @Nullable Set<NIC> nics, @Nullable String hypervisor, @Nullable Set<SecurityGroup> securityGroups, @Nullable Set<Tag> tags) {
        Preconditions.checkArgument((Strings.isNullOrEmpty((String)cpuUsed) || cpuUsed.matches("^[0-9\\.|,\\-]+%$") ? 1 : 0) != 0, (Object)"cpuUsed value should be a decimal number followed by %");
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.account = account;
        this.cpuCount = cpuCount;
        this.cpuSpeed = cpuSpeed;
        this.cpuUsed = cpuUsed;
        this.displayName = displayName;
        this.created = created;
        this.domain = domain;
        this.domainId = domainId;
        this.usesVirtualNetwork = usesVirtualNetwork;
        this.group = group;
        this.groupId = groupId;
        this.guestOSId = guestOSId;
        this.HAEnabled = HAEnabled;
        this.hostId = hostId;
        this.hostname = hostname;
        this.IPAddress = IPAddress;
        this.ISODisplayText = ISODisplayText;
        this.ISOId = ISOId;
        this.ISOName = ISOName;
        this.jobId = jobId;
        this.jobStatus = jobStatus;
        this.memory = memory;
        this.name = name;
        this.networkKbsRead = networkKbsRead;
        this.networkKbsWrite = networkKbsWrite;
        this.password = password;
        this.passwordEnabled = passwordEnabled;
        this.publicIP = publicIP;
        this.publicIPId = publicIPId;
        this.rootDeviceId = rootDeviceId;
        this.rootDeviceType = rootDeviceType;
        this.serviceOfferingId = serviceOfferingId;
        this.serviceOfferingName = serviceOfferingName;
        this.state = state;
        this.templateDisplayText = templateDisplayText;
        this.templateId = templateId;
        this.templateName = templateName;
        this.zoneId = zoneId;
        this.zoneName = zoneName;
        this.nics = nics == null ? ImmutableSet.of() : ImmutableSet.copyOf(nics);
        this.hypervisor = hypervisor;
        this.securityGroups = securityGroups == null ? ImmutableSet.of() : ImmutableSet.copyOf(securityGroups);
        this.tags = tags != null ? ImmutableSet.copyOf(tags) : ImmutableSet.of();
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getAccount() {
        return this.account;
    }

    public long getCpuCount() {
        return this.cpuCount;
    }

    public long getCpuSpeed() {
        return this.cpuSpeed;
    }

    public float getCpuUsed() {
        return this.cpuUsed != null ? Float.parseFloat(this.cpuUsed.substring(0, this.cpuUsed.length() - 1).replace(',', '.')) : 0.0f;
    }

    private String getCpuUsedAsString() {
        return this.cpuUsed;
    }

    @Nullable
    public String getDisplayName() {
        return this.displayName;
    }

    @Nullable
    public Date getCreated() {
        return this.created;
    }

    @Nullable
    public String getDomain() {
        return this.domain;
    }

    @Nullable
    public String getDomainId() {
        return this.domainId;
    }

    public boolean usesVirtualNetwork() {
        return this.usesVirtualNetwork;
    }

    @Nullable
    public String getGroup() {
        return this.group;
    }

    @Nullable
    public String getGroupId() {
        return this.groupId;
    }

    @Nullable
    public String getGuestOSId() {
        return this.guestOSId;
    }

    public boolean isHAEnabled() {
        return this.HAEnabled;
    }

    @Nullable
    public String getHostId() {
        return this.hostId;
    }

    @Nullable
    public String getHostname() {
        return this.hostname;
    }

    @Nullable
    public String getIPAddress() {
        return this.IPAddress;
    }

    @Nullable
    public String getISODisplayText() {
        return this.ISODisplayText;
    }

    @Nullable
    public String getISOId() {
        return this.ISOId;
    }

    @Nullable
    public String getISOName() {
        return this.ISOName;
    }

    @Nullable
    public String getJobId() {
        return this.jobId;
    }

    @Nullable
    public Integer getJobStatus() {
        return this.jobStatus;
    }

    public long getMemory() {
        return this.memory;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public Long getNetworkKbsRead() {
        return this.networkKbsRead;
    }

    @Nullable
    public Long getNetworkKbsWrite() {
        return this.networkKbsWrite;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    public boolean isPasswordEnabled() {
        return this.passwordEnabled;
    }

    @Nullable
    public String getPublicIP() {
        return this.publicIP;
    }

    @Nullable
    public String getPublicIPId() {
        return this.publicIPId;
    }

    @Nullable
    public String getRootDeviceId() {
        return this.rootDeviceId;
    }

    @Nullable
    public String getRootDeviceType() {
        return this.rootDeviceType;
    }

    @Nullable
    public String getServiceOfferingId() {
        return this.serviceOfferingId;
    }

    @Nullable
    public String getServiceOfferingName() {
        return this.serviceOfferingName;
    }

    @Nullable
    public State getState() {
        return this.state;
    }

    @Nullable
    public String getTemplateDisplayText() {
        return this.templateDisplayText;
    }

    @Nullable
    public String getTemplateId() {
        return this.templateId;
    }

    @Nullable
    public String getTemplateName() {
        return this.templateName;
    }

    @Nullable
    public String getZoneId() {
        return this.zoneId;
    }

    @Nullable
    public String getZoneName() {
        return this.zoneName;
    }

    public Set<NIC> getNICs() {
        return this.nics;
    }

    @Nullable
    public String getHypervisor() {
        return this.hypervisor;
    }

    public Set<SecurityGroup> getSecurityGroups() {
        return this.securityGroups;
    }

    public Set<Tag> getTags() {
        return this.tags;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.account, this.cpuCount, this.cpuSpeed, this.cpuUsed, this.displayName, this.created, this.domain, this.domainId, this.usesVirtualNetwork, this.group, this.groupId, this.guestOSId, this.HAEnabled, this.hostId, this.hostname, this.IPAddress, this.ISODisplayText, this.ISOId, this.ISOName, this.jobId, this.jobStatus, this.memory, this.name, this.networkKbsRead, this.networkKbsWrite, this.password, this.passwordEnabled, this.publicIP, this.publicIPId, this.rootDeviceId, this.rootDeviceType, this.serviceOfferingId, this.serviceOfferingName, this.state, this.templateDisplayText, this.templateId, this.templateName, this.zoneId, this.zoneName, this.nics, this.hypervisor, this.securityGroups, this.tags});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        VirtualMachine that = (VirtualMachine)VirtualMachine.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.account, (Object)that.account) && Objects.equal((Object)this.cpuCount, (Object)that.cpuCount) && Objects.equal((Object)this.cpuSpeed, (Object)that.cpuSpeed) && Objects.equal((Object)this.cpuUsed, (Object)that.cpuUsed) && Objects.equal((Object)this.displayName, (Object)that.displayName) && Objects.equal((Object)this.created, (Object)that.created) && Objects.equal((Object)this.domain, (Object)that.domain) && Objects.equal((Object)this.domainId, (Object)that.domainId) && Objects.equal((Object)this.usesVirtualNetwork, (Object)that.usesVirtualNetwork) && Objects.equal((Object)this.group, (Object)that.group) && Objects.equal((Object)this.groupId, (Object)that.groupId) && Objects.equal((Object)this.guestOSId, (Object)that.guestOSId) && Objects.equal((Object)this.HAEnabled, (Object)that.HAEnabled) && Objects.equal((Object)this.hostId, (Object)that.hostId) && Objects.equal((Object)this.hostname, (Object)that.hostname) && Objects.equal((Object)this.IPAddress, (Object)that.IPAddress) && Objects.equal((Object)this.ISODisplayText, (Object)that.ISODisplayText) && Objects.equal((Object)this.ISOId, (Object)that.ISOId) && Objects.equal((Object)this.ISOName, (Object)that.ISOName) && Objects.equal((Object)this.jobId, (Object)that.jobId) && Objects.equal((Object)this.jobStatus, (Object)that.jobStatus) && Objects.equal((Object)this.memory, (Object)that.memory) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.networkKbsRead, (Object)that.networkKbsRead) && Objects.equal((Object)this.networkKbsWrite, (Object)that.networkKbsWrite) && Objects.equal((Object)this.password, (Object)that.password) && Objects.equal((Object)this.passwordEnabled, (Object)that.passwordEnabled) && Objects.equal((Object)this.publicIP, (Object)that.publicIP) && Objects.equal((Object)this.publicIPId, (Object)that.publicIPId) && Objects.equal((Object)this.rootDeviceId, (Object)that.rootDeviceId) && Objects.equal((Object)this.rootDeviceType, (Object)that.rootDeviceType) && Objects.equal((Object)this.serviceOfferingId, (Object)that.serviceOfferingId) && Objects.equal((Object)this.serviceOfferingName, (Object)that.serviceOfferingName) && Objects.equal((Object)((Object)this.state), (Object)((Object)that.state)) && Objects.equal((Object)this.templateDisplayText, (Object)that.templateDisplayText) && Objects.equal((Object)this.templateId, (Object)that.templateId) && Objects.equal((Object)this.templateName, (Object)that.templateName) && Objects.equal((Object)this.zoneId, (Object)that.zoneId) && Objects.equal((Object)this.zoneName, (Object)that.zoneName) && Objects.equal(this.nics, that.nics) && Objects.equal((Object)this.hypervisor, (Object)that.hypervisor) && Objects.equal(this.securityGroups, that.securityGroups) && Objects.equal(this.tags, that.tags);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("account", (Object)this.account).add("cpuCount", this.cpuCount).add("cpuSpeed", this.cpuSpeed).add("cpuUsed", (Object)this.cpuUsed).add("displayName", (Object)this.displayName).add("created", (Object)this.created).add("domain", (Object)this.domain).add("domainId", (Object)this.domainId).add("usesVirtualNetwork", this.usesVirtualNetwork).add("group", (Object)this.group).add("groupId", (Object)this.groupId).add("guestOSId", (Object)this.guestOSId).add("HAEnabled", this.HAEnabled).add("hostId", (Object)this.hostId).add("hostname", (Object)this.hostname).add("IPAddress", (Object)this.IPAddress).add("ISODisplayText", (Object)this.ISODisplayText).add("ISOId", (Object)this.ISOId).add("ISOName", (Object)this.ISOName).add("jobId", (Object)this.jobId).add("jobStatus", (Object)this.jobStatus).add("memory", this.memory).add("name", (Object)this.name).add("networkKbsRead", (Object)this.networkKbsRead).add("networkKbsWrite", (Object)this.networkKbsWrite).add("password", (Object)this.password).add("passwordEnabled", this.passwordEnabled).add("publicIP", (Object)this.publicIP).add("publicIPId", (Object)this.publicIPId).add("rootDeviceId", (Object)this.rootDeviceId).add("rootDeviceType", (Object)this.rootDeviceType).add("serviceOfferingId", (Object)this.serviceOfferingId).add("serviceOfferingName", (Object)this.serviceOfferingName).add("state", (Object)this.state).add("templateDisplayText", (Object)this.templateDisplayText).add("templateId", (Object)this.templateId).add("templateName", (Object)this.templateName).add("zoneId", (Object)this.zoneId).add("zoneName", (Object)this.zoneName).add("nics", this.nics).add("hypervisor", (Object)this.hypervisor).add("securityGroups", this.securityGroups).add("tags", this.tags);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String account;
        protected long cpuCount;
        protected long cpuSpeed;
        protected String cpuUsed;
        protected String displayName;
        protected Date created;
        protected String domain;
        protected String domainId;
        protected boolean usesVirtualNetwork;
        protected String group;
        protected String groupId;
        protected String guestOSId;
        protected boolean HAEnabled;
        protected String hostId;
        protected String hostname;
        protected String IPAddress;
        protected String ISODisplayText;
        protected String ISOId;
        protected String ISOName;
        protected String jobId;
        protected Integer jobStatus;
        protected long memory;
        protected String name;
        protected Long networkKbsRead;
        protected Long networkKbsWrite;
        protected String password;
        protected boolean passwordEnabled;
        protected String publicIP;
        protected String publicIPId;
        protected String rootDeviceId;
        protected String rootDeviceType;
        protected String serviceOfferingId;
        protected String serviceOfferingName;
        protected State state;
        protected String templateDisplayText;
        protected String templateId;
        protected String templateName;
        protected String zoneId;
        protected String zoneName;
        protected Set<NIC> nics = ImmutableSet.of();
        protected String hypervisor;
        protected Set<SecurityGroup> securityGroups = ImmutableSet.of();
        protected Set<Tag> tags = ImmutableSet.of();

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T account(String account) {
            this.account = account;
            return this.self();
        }

        public T cpuCount(long cpuCount) {
            this.cpuCount = cpuCount;
            return this.self();
        }

        public T cpuSpeed(long cpuSpeed) {
            this.cpuSpeed = cpuSpeed;
            return this.self();
        }

        public T cpuUsed(String cpuUsed) {
            this.cpuUsed = cpuUsed;
            return this.self();
        }

        public T displayName(String displayName) {
            this.displayName = displayName;
            return this.self();
        }

        public T created(Date created) {
            this.created = created;
            return this.self();
        }

        public T domain(String domain) {
            this.domain = domain;
            return this.self();
        }

        public T domainId(String domainId) {
            this.domainId = domainId;
            return this.self();
        }

        public T usesVirtualNetwork(boolean usesVirtualNetwork) {
            this.usesVirtualNetwork = usesVirtualNetwork;
            return this.self();
        }

        public T group(String group) {
            this.group = group;
            return this.self();
        }

        public T groupId(String groupId) {
            this.groupId = groupId;
            return this.self();
        }

        public T guestOSId(String guestOSId) {
            this.guestOSId = guestOSId;
            return this.self();
        }

        public T isHAEnabled(boolean HAEnabled) {
            this.HAEnabled = HAEnabled;
            return this.self();
        }

        public T hostId(String hostId) {
            this.hostId = hostId;
            return this.self();
        }

        public T hostname(String hostname) {
            this.hostname = hostname;
            return this.self();
        }

        public T IPAddress(String IPAddress) {
            this.IPAddress = IPAddress;
            return this.self();
        }

        public T ISODisplayText(String ISODisplayText) {
            this.ISODisplayText = ISODisplayText;
            return this.self();
        }

        public T ISOId(String ISOId) {
            this.ISOId = ISOId;
            return this.self();
        }

        public T ISOName(String ISOName) {
            this.ISOName = ISOName;
            return this.self();
        }

        public T jobId(String jobId) {
            this.jobId = jobId;
            return this.self();
        }

        public T jobStatus(Integer jobStatus) {
            this.jobStatus = jobStatus;
            return this.self();
        }

        public T memory(long memory) {
            this.memory = memory;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T networkKbsRead(Long networkKbsRead) {
            this.networkKbsRead = networkKbsRead;
            return this.self();
        }

        public T networkKbsWrite(Long networkKbsWrite) {
            this.networkKbsWrite = networkKbsWrite;
            return this.self();
        }

        public T password(String password) {
            this.password = password;
            return this.self();
        }

        public T passwordEnabled(boolean passwordEnabled) {
            this.passwordEnabled = passwordEnabled;
            return this.self();
        }

        public T publicIP(String publicIP) {
            this.publicIP = publicIP;
            return this.self();
        }

        public T publicIPId(String publicIPId) {
            this.publicIPId = publicIPId;
            return this.self();
        }

        public T rootDeviceId(String rootDeviceId) {
            this.rootDeviceId = rootDeviceId;
            return this.self();
        }

        public T rootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
            return this.self();
        }

        public T serviceOfferingId(String serviceOfferingId) {
            this.serviceOfferingId = serviceOfferingId;
            return this.self();
        }

        public T serviceOfferingName(String serviceOfferingName) {
            this.serviceOfferingName = serviceOfferingName;
            return this.self();
        }

        public T state(State state) {
            this.state = state;
            return this.self();
        }

        public T templateDisplayText(String templateDisplayText) {
            this.templateDisplayText = templateDisplayText;
            return this.self();
        }

        public T templateId(String templateId) {
            this.templateId = templateId;
            return this.self();
        }

        public T templateName(String templateName) {
            this.templateName = templateName;
            return this.self();
        }

        public T zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this.self();
        }

        public T zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this.self();
        }

        public T nics(Set<NIC> nics) {
            this.nics = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(nics, (Object)"nics")));
            return this.self();
        }

        public T nics(NIC ... in) {
            return this.nics((Set<NIC>)ImmutableSet.copyOf((Object[])in));
        }

        public T hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this.self();
        }

        public T securityGroups(Set<SecurityGroup> securityGroups) {
            this.securityGroups = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(securityGroups, (Object)"securityGroups")));
            return this.self();
        }

        public T securityGroups(SecurityGroup ... in) {
            return this.securityGroups((Set<SecurityGroup>)ImmutableSet.copyOf((Object[])in));
        }

        public T tags(Set<Tag> tags) {
            this.tags = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(tags, (Object)"tags")));
            return this.self();
        }

        public T tags(Tag ... in) {
            return this.tags((Set<Tag>)ImmutableSet.copyOf((Object[])in));
        }

        public VirtualMachine build() {
            return new VirtualMachine(this.id, this.account, this.cpuCount, this.cpuSpeed, this.cpuUsed, this.displayName, this.created, this.domain, this.domainId, this.usesVirtualNetwork, this.group, this.groupId, this.guestOSId, this.HAEnabled, this.hostId, this.hostname, this.IPAddress, this.ISODisplayText, this.ISOId, this.ISOName, this.jobId, this.jobStatus, this.memory, this.name, this.networkKbsRead, this.networkKbsWrite, this.password, this.passwordEnabled, this.publicIP, this.publicIPId, this.rootDeviceId, this.rootDeviceType, this.serviceOfferingId, this.serviceOfferingName, this.state, this.templateDisplayText, this.templateId, this.templateName, this.zoneId, this.zoneName, this.nics, this.hypervisor, this.securityGroups, this.tags);
        }

        public T fromVirtualMachine(VirtualMachine in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).account(in.getAccount())).cpuCount(in.getCpuCount())).cpuSpeed(in.getCpuSpeed())).cpuUsed(in.getCpuUsedAsString())).displayName(in.getDisplayName())).created(in.getCreated())).domain(in.getDomain())).domainId(in.getDomainId())).usesVirtualNetwork(in.usesVirtualNetwork())).group(in.getGroup())).groupId(in.getGroupId())).guestOSId(in.getGuestOSId())).isHAEnabled(in.isHAEnabled())).hostId(in.getHostId())).hostname(in.getHostname())).IPAddress(in.getIPAddress())).ISODisplayText(in.getISODisplayText())).ISOId(in.getISOId())).ISOName(in.getISOName())).jobId(in.getJobId())).jobStatus(in.getJobStatus())).memory(in.getMemory())).name(in.getName())).networkKbsRead(in.getNetworkKbsRead())).networkKbsWrite(in.getNetworkKbsWrite())).password(in.getPassword())).passwordEnabled(in.isPasswordEnabled())).publicIP(in.getPublicIP())).publicIPId(in.getPublicIPId())).rootDeviceId(in.getRootDeviceId())).rootDeviceType(in.getRootDeviceType())).serviceOfferingId(in.getServiceOfferingId())).serviceOfferingName(in.getServiceOfferingName())).state(in.getState())).templateDisplayText(in.getTemplateDisplayText())).templateId(in.getTemplateId())).templateName(in.getTemplateName())).zoneId(in.getZoneId())).zoneName(in.getZoneName())).nics(in.getNICs())).hypervisor(in.getHypervisor())).securityGroups(in.getSecurityGroups())).tags(in.getTags());
        }
    }

    public static enum State {
        STARTING,
        RUNNING,
        STOPPING,
        STOPPED,
        DESTROYED,
        EXPUNGING,
        MIGRATING,
        ERROR,
        UNKNOWN,
        SHUTDOWNED,
        UNRECOGNIZED;


        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }

        public static State fromValue(String state) {
            try {
                return State.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)state, (Object)"state")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

