/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.test.http;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.brooklyn.test.Asserts;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;

public class RecordingHttpRequestHandler
implements HttpRequestHandler {
    private final HttpRequestHandler delegate;
    private final List<HttpRequest> requests = Lists.newCopyOnWriteArrayList();

    public RecordingHttpRequestHandler(HttpRequestHandler delegate) {
        this.delegate = (HttpRequestHandler)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
    }

    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        this.requests.add(request);
        this.delegate.handle(request, response, context);
    }

    public void assertHasRequest(Predicate<? super HttpRequest> filter) {
        for (HttpRequest req : this.requests) {
            if (!filter.apply((Object)req)) continue;
            return;
        }
        Asserts.fail("No request matching filter " + filter);
    }

    public void assertHasRequestEventually(final Predicate<? super HttpRequest> filter) {
        Asserts.succeedsEventually(new Runnable(){

            @Override
            public void run() {
                RecordingHttpRequestHandler.this.assertHasRequest((Predicate<? super HttpRequest>)filter);
            }
        });
    }

    public List<HttpRequest> getRequests(Predicate<? super HttpRequest> filter) {
        return ImmutableList.copyOf((Iterable)Iterables.filter(this.requests, filter));
    }

    public List<HttpRequest> getRequests() {
        return ImmutableList.copyOf(this.requests);
    }
}

