/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.config;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import javax.inject.Inject;
import javax.inject.Provider;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.internal.BlobImpl;

public class BlobStoreObjectModule
extends AbstractModule {
    protected void configure() {
        this.bind(Blob.Factory.class).to(BlobFactory.class).in(Scopes.SINGLETON);
    }

    @Provides
    final Blob provideBlob(Blob.Factory factory) {
        return factory.create(null);
    }

    private static class BlobFactory
    implements Blob.Factory {
        @Inject
        Provider<MutableBlobMetadata> metadataProvider;

        private BlobFactory() {
        }

        @Override
        public Blob create(MutableBlobMetadata metadata) {
            return new BlobImpl(metadata != null ? metadata : (MutableBlobMetadata)this.metadataProvider.get());
        }
    }
}

