/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.domain;

import java.net.URI;
import java.util.Date;
import java.util.List;
import org.jclouds.googlecloud.internal.NullSafeCopies;
import org.jclouds.googlecomputeengine.domain.AutoValue_MachineType;
import org.jclouds.googlecomputeengine.domain.AutoValue_MachineType_ScratchDisk;
import org.jclouds.googlecomputeengine.domain.Deprecated;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class MachineType {
    public abstract String id();

    public abstract Date creationTimestamp();

    public abstract URI selfLink();

    public abstract String name();

    @Nullable
    public abstract String description();

    public abstract int guestCpus();

    public abstract int memoryMb();

    @Nullable
    public abstract Integer imageSpaceGb();

    public abstract List<ScratchDisk> scratchDisks();

    public abstract int maximumPersistentDisks();

    public abstract long maximumPersistentDisksSizeGb();

    public abstract String zone();

    @Nullable
    public abstract Deprecated deprecated();

    @SerializedNames(value={"id", "creationTimestamp", "selfLink", "name", "description", "guestCpus", "memoryMb", "imageSpaceGb", "scratchDisks", "maximumPersistentDisks", "maximumPersistentDisksSizeGb", "zone", "deprecated"})
    public static MachineType create(String id, Date creationTimestamp, URI selfLink, String name, String description, int guestCpus, int memoryMb, Integer imageSpaceGb, List<ScratchDisk> scratchDisks, int maximumPersistentDisks, long maximumPersistentDisksSizeGb, String zone, Deprecated deprecated) {
        return new AutoValue_MachineType(id, creationTimestamp, selfLink, name, description, guestCpus, memoryMb, imageSpaceGb, NullSafeCopies.copyOf(scratchDisks), maximumPersistentDisks, maximumPersistentDisksSizeGb, zone, deprecated);
    }

    MachineType() {
    }

    public static abstract class ScratchDisk {
        public abstract int diskGb();

        @SerializedNames(value={"diskGb"})
        public static ScratchDisk create(int diskGb) {
            return new AutoValue_MachineType_ScratchDisk(diskGb);
        }

        ScratchDisk() {
        }
    }
}

