/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.config.internal;

import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.config.StructuredConfigKey;
import org.apache.brooklyn.core.config.SubElementConfigKey;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.TypeTokens;

public abstract class AbstractStructuredConfigKey<T, RawT, V>
extends BasicConfigKey<T>
implements StructuredConfigKey {
    private static final long serialVersionUID = 7806267541029428561L;
    private final TypeToken<V> subTypeToken;
    private final Class<V> subType;

    protected AbstractStructuredConfigKey(BasicConfigKey.Builder<T, ?> builder, TypeToken<V> subType) {
        super(builder);
        if (TypeToken.of((Class)TypeTokens.getRawRawType(subType)).equals(subType)) {
            this.subType = TypeTokens.getRawRawType(subType);
            this.subTypeToken = null;
        } else {
            this.subTypeToken = subType;
            this.subType = null;
        }
    }

    public AbstractStructuredConfigKey(TypeToken<T> type, TypeToken<V> subType, String name, String description, T defaultValue) {
        super(type, name, description, defaultValue);
        this.subTypeToken = subType;
        this.subType = null;
    }

    protected ConfigKey<V> subKey(String subName) {
        return this.subKey(subName, "sub-element of " + this.getName() + ", named " + subName);
    }

    protected ConfigKey<V> subKey(String subName, String description) {
        return new SubElementConfigKey<Object>(this, this.getSubTypeToken(), this.getName() + "." + subName, description, null);
    }

    protected TypeToken<V> getSubTypeToken() {
        if (this.subTypeToken != null) {
            return this.subTypeToken;
        }
        if (this.subType != null) {
            return TypeToken.of(this.subType);
        }
        return null;
    }

    protected static String getKeyName(Object contender) {
        if (contender == null) {
            return null;
        }
        if (contender instanceof ConfigKey) {
            return ((ConfigKey)contender).getName();
        }
        return contender.toString();
    }

    @Override
    public boolean acceptsKeyMatch(Object contender) {
        return this.getName().equalsIgnoreCase(AbstractStructuredConfigKey.getKeyName(contender));
    }

    @Override
    public boolean acceptsSubkey(Object contender) {
        return contender != null && AbstractStructuredConfigKey.getKeyName(contender).startsWith(this.getName() + ".");
    }

    public String extractSubKeyName(Object o) {
        String name = AbstractStructuredConfigKey.getKeyName(o);
        assert (name.startsWith(this.getName() + "."));
        return name.substring(this.getName().length() + 1);
    }

    @Override
    public boolean acceptsSubkeyStronglyTyped(Object contender) {
        return contender instanceof SubElementConfigKey && this.acceptsKeyMatch(((SubElementConfigKey)contender).parent);
    }

    @Override
    public boolean isSet(Map<?, ?> vals) {
        if (vals.containsKey(this)) {
            return true;
        }
        for (Object contender : vals.keySet()) {
            if (!this.acceptsKeyMatch(contender) && !this.acceptsSubkey(contender)) continue;
            return true;
        }
        return false;
    }

    protected RawT extractValue(Map<?, ?> vals, ExecutionContext exec, boolean coerce, boolean unmodifiable) {
        RawT base = null;
        LinkedHashMap subkeys = Maps.newLinkedHashMap();
        for (Map.Entry<?, ?> entry : vals.entrySet()) {
            Object value;
            Object k = entry.getKey();
            if (this.acceptsKeyMatch(k)) {
                try {
                    base = this.extractValueMatchingThisKey(entry.getValue(), exec, coerce);
                }
                catch (Exception e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
            if (!this.acceptsSubkey(k)) continue;
            String subKeyName = this.extractSubKeyName(k);
            if (coerce) {
                SubElementConfigKey kk = k instanceof SubElementConfigKey ? (SubElementConfigKey)k : (SubElementConfigKey)this.subKey(subKeyName);
                value = kk.extractValue((Map)vals, exec);
            } else {
                value = vals.get(k);
            }
            subkeys.put(subKeyName, value);
        }
        return this.merge(base, subkeys, unmodifiable);
    }

    @Override
    public T extractValue(Map<?, ?> vals, ExecutionContext exec) {
        return (T)this.extractValue(vals, exec, true, true);
    }

    public RawT rawValue(Map<?, ?> vals) {
        return this.extractValue(vals, null, false, false);
    }

    protected abstract RawT extractValueMatchingThisKey(Object var1, ExecutionContext var2, boolean var3) throws InterruptedException, ExecutionException;

    protected abstract RawT merge(RawT var1, Map<String, Object> var2, boolean var3);
}

