/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.CatalogSourceSpec;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.Icon;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.IconBuilder;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.IconFluent;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.UpdateStrategy;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.UpdateStrategyBuilder;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.UpdateStrategyFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class CatalogSourceSpecFluent<A extends CatalogSourceSpecFluent<A>>
extends BaseFluent<A> {
    private String address;
    private String configMap;
    private String description;
    private String displayName;
    private IconBuilder icon;
    private String image;
    private Integer priority;
    private String publisher;
    private List<String> secrets = new ArrayList<String>();
    private String sourceType;
    private UpdateStrategyBuilder updateStrategy;
    private Map<String, Object> additionalProperties;

    public CatalogSourceSpecFluent() {
    }

    public CatalogSourceSpecFluent(CatalogSourceSpec instance) {
        CatalogSourceSpec catalogSourceSpec = instance = instance != null ? instance : new CatalogSourceSpec();
        if (instance != null) {
            this.withAddress(instance.getAddress());
            this.withConfigMap(instance.getConfigMap());
            this.withDescription(instance.getDescription());
            this.withDisplayName(instance.getDisplayName());
            this.withIcon(instance.getIcon());
            this.withImage(instance.getImage());
            this.withPriority(instance.getPriority());
            this.withPublisher(instance.getPublisher());
            this.withSecrets(instance.getSecrets());
            this.withSourceType(instance.getSourceType());
            this.withUpdateStrategy(instance.getUpdateStrategy());
            this.withAddress(instance.getAddress());
            this.withConfigMap(instance.getConfigMap());
            this.withDescription(instance.getDescription());
            this.withDisplayName(instance.getDisplayName());
            this.withIcon(instance.getIcon());
            this.withImage(instance.getImage());
            this.withPriority(instance.getPriority());
            this.withPublisher(instance.getPublisher());
            this.withSecrets(instance.getSecrets());
            this.withSourceType(instance.getSourceType());
            this.withUpdateStrategy(instance.getUpdateStrategy());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getAddress() {
        return this.address;
    }

    public A withAddress(String address) {
        this.address = address;
        return (A)((Object)this);
    }

    public boolean hasAddress() {
        return this.address != null;
    }

    public String getConfigMap() {
        return this.configMap;
    }

    public A withConfigMap(String configMap) {
        this.configMap = configMap;
        return (A)((Object)this);
    }

    public boolean hasConfigMap() {
        return this.configMap != null;
    }

    public String getDescription() {
        return this.description;
    }

    public A withDescription(String description) {
        this.description = description;
        return (A)((Object)this);
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public A withDisplayName(String displayName) {
        this.displayName = displayName;
        return (A)((Object)this);
    }

    public boolean hasDisplayName() {
        return this.displayName != null;
    }

    public Icon buildIcon() {
        return this.icon != null ? this.icon.build() : null;
    }

    public A withIcon(Icon icon) {
        this._visitables.get((Object)"icon").remove((Object)this.icon);
        if (icon != null) {
            this.icon = new IconBuilder(icon);
            this._visitables.get((Object)"icon").add(this.icon);
        } else {
            this.icon = null;
            this._visitables.get((Object)"icon").remove((Object)this.icon);
        }
        return (A)((Object)this);
    }

    public boolean hasIcon() {
        return this.icon != null;
    }

    public A withNewIcon(String base64data, String mediatype) {
        return this.withIcon(new Icon(base64data, mediatype));
    }

    public IconNested<A> withNewIcon() {
        return new IconNested(null);
    }

    public IconNested<A> withNewIconLike(Icon item) {
        return new IconNested(item);
    }

    public IconNested<A> editIcon() {
        return this.withNewIconLike(Optional.ofNullable(this.buildIcon()).orElse(null));
    }

    public IconNested<A> editOrNewIcon() {
        return this.withNewIconLike(Optional.ofNullable(this.buildIcon()).orElse(new IconBuilder().build()));
    }

    public IconNested<A> editOrNewIconLike(Icon item) {
        return this.withNewIconLike(Optional.ofNullable(this.buildIcon()).orElse(item));
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image = image;
        return (A)((Object)this);
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public A withPriority(Integer priority) {
        this.priority = priority;
        return (A)((Object)this);
    }

    public boolean hasPriority() {
        return this.priority != null;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public A withPublisher(String publisher) {
        this.publisher = publisher;
        return (A)((Object)this);
    }

    public boolean hasPublisher() {
        return this.publisher != null;
    }

    public A addToSecrets(int index, String item) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<String>();
        }
        this.secrets.add(index, item);
        return (A)((Object)this);
    }

    public A setToSecrets(int index, String item) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<String>();
        }
        this.secrets.set(index, item);
        return (A)((Object)this);
    }

    public A addToSecrets(String ... items) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<String>();
        }
        for (String item : items) {
            this.secrets.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToSecrets(Collection<String> items) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<String>();
        }
        for (String item : items) {
            this.secrets.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromSecrets(String ... items) {
        if (this.secrets == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.secrets.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSecrets(Collection<String> items) {
        if (this.secrets == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.secrets.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getSecrets() {
        return this.secrets;
    }

    public String getSecret(int index) {
        return this.secrets.get(index);
    }

    public String getFirstSecret() {
        return this.secrets.get(0);
    }

    public String getLastSecret() {
        return this.secrets.get(this.secrets.size() - 1);
    }

    public String getMatchingSecret(Predicate<String> predicate) {
        for (String item : this.secrets) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingSecret(Predicate<String> predicate) {
        for (String item : this.secrets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSecrets(List<String> secrets) {
        if (secrets != null) {
            this.secrets = new ArrayList<String>();
            for (String item : secrets) {
                this.addToSecrets(item);
            }
        } else {
            this.secrets = null;
        }
        return (A)((Object)this);
    }

    public A withSecrets(String ... secrets) {
        if (this.secrets != null) {
            this.secrets.clear();
            this._visitables.remove((Object)"secrets");
        }
        if (secrets != null) {
            for (String item : secrets) {
                this.addToSecrets(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSecrets() {
        return this.secrets != null && !this.secrets.isEmpty();
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public A withSourceType(String sourceType) {
        this.sourceType = sourceType;
        return (A)((Object)this);
    }

    public boolean hasSourceType() {
        return this.sourceType != null;
    }

    public UpdateStrategy buildUpdateStrategy() {
        return this.updateStrategy != null ? this.updateStrategy.build() : null;
    }

    public A withUpdateStrategy(UpdateStrategy updateStrategy) {
        this._visitables.get((Object)"updateStrategy").remove((Object)this.updateStrategy);
        if (updateStrategy != null) {
            this.updateStrategy = new UpdateStrategyBuilder(updateStrategy);
            this._visitables.get((Object)"updateStrategy").add(this.updateStrategy);
        } else {
            this.updateStrategy = null;
            this._visitables.get((Object)"updateStrategy").remove((Object)this.updateStrategy);
        }
        return (A)((Object)this);
    }

    public boolean hasUpdateStrategy() {
        return this.updateStrategy != null;
    }

    public UpdateStrategyNested<A> withNewUpdateStrategy() {
        return new UpdateStrategyNested(null);
    }

    public UpdateStrategyNested<A> withNewUpdateStrategyLike(UpdateStrategy item) {
        return new UpdateStrategyNested(item);
    }

    public UpdateStrategyNested<A> editUpdateStrategy() {
        return this.withNewUpdateStrategyLike(Optional.ofNullable(this.buildUpdateStrategy()).orElse(null));
    }

    public UpdateStrategyNested<A> editOrNewUpdateStrategy() {
        return this.withNewUpdateStrategyLike(Optional.ofNullable(this.buildUpdateStrategy()).orElse(new UpdateStrategyBuilder().build()));
    }

    public UpdateStrategyNested<A> editOrNewUpdateStrategyLike(UpdateStrategy item) {
        return this.withNewUpdateStrategyLike(Optional.ofNullable(this.buildUpdateStrategy()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CatalogSourceSpecFluent that = (CatalogSourceSpecFluent)((Object)o);
        if (!Objects.equals(this.address, that.address)) {
            return false;
        }
        if (!Objects.equals(this.configMap, that.configMap)) {
            return false;
        }
        if (!Objects.equals(this.description, that.description)) {
            return false;
        }
        if (!Objects.equals(this.displayName, that.displayName)) {
            return false;
        }
        if (!Objects.equals((Object)this.icon, (Object)that.icon)) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.priority, that.priority)) {
            return false;
        }
        if (!Objects.equals(this.publisher, that.publisher)) {
            return false;
        }
        if (!Objects.equals(this.secrets, that.secrets)) {
            return false;
        }
        if (!Objects.equals(this.sourceType, that.sourceType)) {
            return false;
        }
        if (!Objects.equals((Object)this.updateStrategy, (Object)that.updateStrategy)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.address, this.configMap, this.description, this.displayName, this.icon, this.image, this.priority, this.publisher, this.secrets, this.sourceType, this.updateStrategy, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.address != null) {
            sb.append("address:");
            sb.append(this.address + ",");
        }
        if (this.configMap != null) {
            sb.append("configMap:");
            sb.append(this.configMap + ",");
        }
        if (this.description != null) {
            sb.append("description:");
            sb.append(this.description + ",");
        }
        if (this.displayName != null) {
            sb.append("displayName:");
            sb.append(this.displayName + ",");
        }
        if (this.icon != null) {
            sb.append("icon:");
            sb.append((Object)((Object)this.icon) + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.priority != null) {
            sb.append("priority:");
            sb.append(this.priority + ",");
        }
        if (this.publisher != null) {
            sb.append("publisher:");
            sb.append(this.publisher + ",");
        }
        if (this.secrets != null && !this.secrets.isEmpty()) {
            sb.append("secrets:");
            sb.append(this.secrets + ",");
        }
        if (this.sourceType != null) {
            sb.append("sourceType:");
            sb.append(this.sourceType + ",");
        }
        if (this.updateStrategy != null) {
            sb.append("updateStrategy:");
            sb.append((Object)((Object)this.updateStrategy) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class UpdateStrategyNested<N>
    extends UpdateStrategyFluent<UpdateStrategyNested<N>>
    implements Nested<N> {
        UpdateStrategyBuilder builder;

        UpdateStrategyNested(UpdateStrategy item) {
            this.builder = new UpdateStrategyBuilder(this, item);
        }

        public N and() {
            return (N)CatalogSourceSpecFluent.this.withUpdateStrategy(this.builder.build());
        }

        public N endUpdateStrategy() {
            return this.and();
        }
    }

    public class IconNested<N>
    extends IconFluent<IconNested<N>>
    implements Nested<N> {
        IconBuilder builder;

        IconNested(Icon item) {
            this.builder = new IconBuilder(this, item);
        }

        public N and() {
            return (N)CatalogSourceSpecFluent.this.withIcon(this.builder.build());
        }

        public N endIcon() {
            return this.and();
        }
    }
}

