/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.functions;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.nova.v2_0.domain.Image;

public class ImageToOperatingSystem
implements Function<Image, OperatingSystem> {
    public static final Pattern DEFAULT_PATTERN = Pattern.compile("(([^ ]*) ([0-9.]+) ?.*)");
    public static final Pattern WINDOWS_PATTERN = Pattern.compile("Windows (.*) (x[86][64])");
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final Map<OsFamily, Map<String, String>> osVersionMap;

    @Inject
    public ImageToOperatingSystem(Map<OsFamily, Map<String, String>> osVersionMap) {
        this.osVersionMap = osVersionMap;
    }

    public OperatingSystem apply(Image from) {
        OsFamily osFamily = null;
        String osVersion = null;
        String imageName = (String)MoreObjects.firstNonNull((Object)from.getName(), (Object)"unspecified");
        boolean is64Bit = true;
        if (imageName.indexOf("Windows") != -1) {
            osFamily = OsFamily.WINDOWS;
            Matcher matcher = WINDOWS_PATTERN.matcher(from.getName());
            if (matcher.find()) {
                osVersion = ComputeServiceUtils.parseVersionOrReturnEmptyString((OsFamily)osFamily, (String)matcher.group(1), this.osVersionMap);
                is64Bit = matcher.group(2).equals("x64");
            }
        } else {
            if (imageName.contains("Red Hat")) {
                osFamily = OsFamily.RHEL;
            } else if (imageName.contains("Oracle")) {
                osFamily = OsFamily.OEL;
            } else {
                final Iterable imageNameParts = Splitter.on((CharMatcher)CharMatcher.whitespace()).trimResults().split((CharSequence)imageName.toLowerCase());
                try {
                    osFamily = (OsFamily)Iterables.find(Arrays.asList(OsFamily.values()), (Predicate)new Predicate<OsFamily>(){

                        public boolean apply(OsFamily osFamily) {
                            return Iterables.any((Iterable)imageNameParts, (Predicate)Predicates.equalTo((Object)osFamily.name().toLowerCase()));
                        }
                    });
                }
                catch (NoSuchElementException e) {
                    String ubuntuVersion = this.startsWithUbuntuVersion(imageNameParts);
                    if (ubuntuVersion != null) {
                        osFamily = OsFamily.UBUNTU;
                        osVersion = ubuntuVersion;
                    }
                    this.logger.trace("could not parse operating system family for image(%s): %s", new Object[]{from.getId(), imageNameParts});
                    osFamily = OsFamily.UNRECOGNIZED;
                }
            }
            Matcher matcher = DEFAULT_PATTERN.matcher(imageName);
            if (matcher.find() && matcher.groupCount() >= 3) {
                osVersion = ComputeServiceUtils.parseVersionOrReturnEmptyString((OsFamily)osFamily, (String)matcher.group(3), this.osVersionMap);
            }
        }
        return new OperatingSystem(osFamily, imageName, osVersion, null, imageName, is64Bit);
    }

    String startsWithUbuntuVersion(Iterable<String> imageNameParts) {
        Map<String, String> ubuntuVersions = this.osVersionMap.get(OsFamily.UBUNTU);
        for (String ubuntuKey : Iterables.filter(ubuntuVersions.keySet(), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)"")))) {
            if (!Iterables.any(imageNameParts, (Predicate)Predicates.containsPattern((String)("^" + ubuntuKey + ".*")))) continue;
            return ubuntuVersions.get(ubuntuKey);
        }
        return null;
    }
}

