/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import org.jclouds.cim.OSType;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.ovf.Envelope;
import org.jclouds.ovf.OperatingSystemSection;
import org.jclouds.ovf.VirtualSystem;

@Beta
public class CIMOperatingSystem
extends OperatingSystem {
    private OSType osType;

    public static Builder builder() {
        return new Builder();
    }

    public static CIMOperatingSystem toComputeOs(OperatingSystemSection os) {
        return new CIMOperatingSystem(OSType.fromValue(os.getId()), "", null, os.getDescription());
    }

    public static CIMOperatingSystem toComputeOs(Envelope ovf) {
        return CIMOperatingSystem.toComputeOs(((VirtualSystem)ovf.getVirtualSystem()).getOperatingSystemSection());
    }

    protected CIMOperatingSystem() {
    }

    public CIMOperatingSystem(OSType osType, String version, String arch, String description) {
        this(osType.getFamily(), osType.getValue(), version, arch, description, osType.is64Bit(), osType);
    }

    public CIMOperatingSystem(@Nullable OsFamily family, @Nullable String name, @Nullable String version, @Nullable String arch, String description, boolean is64Bit, OSType osType) {
        super(family, name, version, arch, description, is64Bit);
        this.osType = osType;
    }

    public OSType getOsType() {
        return this.osType;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.osType == null ? 0 : this.osType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CIMOperatingSystem other = (CIMOperatingSystem)obj;
        return !(this.osType == null ? other.osType != null : !this.osType.equals((Object)other.osType));
    }

    @Override
    protected MoreObjects.ToStringHelper string() {
        return super.string().add("osType", (Object)this.osType);
    }

    public static class Builder
    extends OperatingSystem.Builder {
        private OSType osType;

        public Builder osType(@Nullable OSType osType) {
            this.osType = osType;
            return this;
        }

        @Override
        public CIMOperatingSystem build() {
            return new CIMOperatingSystem(this.family, this.name, this.version, this.arch, this.description, this.is64Bit, this.osType);
        }

        public Builder fromCIMOperatingSystem(CIMOperatingSystem in) {
            return this.fromOperatingSystem(in).osType(in.getOsType());
        }

        @Override
        public Builder arch(String arch) {
            return (Builder)Builder.class.cast(super.arch(arch));
        }

        @Override
        public Builder description(String description) {
            return (Builder)Builder.class.cast(super.description(description));
        }

        @Override
        public Builder family(OsFamily family) {
            return (Builder)Builder.class.cast(super.family(family));
        }

        @Override
        public Builder fromOperatingSystem(OperatingSystem in) {
            return (Builder)Builder.class.cast(super.fromOperatingSystem(in));
        }

        @Override
        public Builder is64Bit(boolean is64Bit) {
            return (Builder)Builder.class.cast(super.is64Bit(is64Bit));
        }

        @Override
        public Builder name(String name) {
            return (Builder)Builder.class.cast(super.name(name));
        }

        @Override
        public Builder version(String version) {
            return (Builder)Builder.class.cast(super.version(version));
        }
    }
}

