/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.brooklyn.spi.creation;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.api.typereg.RegisteredTypeLoadingContext;
import org.apache.brooklyn.camp.CampPlatform;
import org.apache.brooklyn.camp.brooklyn.api.AssemblyTemplateSpecInstantiator;
import org.apache.brooklyn.camp.brooklyn.spi.creation.BrooklynYamlTypeInstantiator;
import org.apache.brooklyn.camp.brooklyn.spi.creation.CampInternalUtils;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.BrooklynDslDeferredSupplier;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.DslUtils;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.methods.DslComponent;
import org.apache.brooklyn.camp.spi.AssemblyTemplate;
import org.apache.brooklyn.camp.spi.instantiate.AssemblyTemplateInstantiator;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.catalog.internal.BasicBrooklynCatalog;
import org.apache.brooklyn.core.catalog.internal.CatalogUtils;
import org.apache.brooklyn.core.entity.AbstractEntity;
import org.apache.brooklyn.core.mgmt.EntityManagementUtils;
import org.apache.brooklyn.core.typereg.RegisteredTypes;
import org.apache.brooklyn.core.typereg.UnsupportedTypePlanException;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.flags.BrooklynTypeNameResolution;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.yaml.Yamls;

class CampResolver {
    private ManagementContext mgmt;
    private RegisteredType type;
    private RegisteredTypeLoadingContext context;
    @Beta
    public static final ThreadLocal<Stack<RegisteredType>> currentlyCreatingSpec = new ThreadLocal();

    public CampResolver(ManagementContext mgmt, RegisteredType type, RegisteredTypeLoadingContext context) {
        this.mgmt = mgmt;
        this.type = type;
        this.context = context;
    }

    public AbstractBrooklynObjectSpec<?, ?> createSpec() {
        return CampResolver.createSpecFromFull(this.mgmt, this.type, this.context.getExpectedJavaSuperType(), this.context.getAlreadyEncounteredTypes(), this.context.getLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AbstractBrooklynObjectSpec<?, ?> createSpecFromFull(ManagementContext mgmt, RegisteredType item, Class<?> expectedType, Set<String> parentEncounteredTypes, BrooklynClassLoadingContext loaderO) {
        BrooklynClassLoadingContext loader = CatalogUtils.newClassLoadingContext((ManagementContext)mgmt, (RegisteredType)item, (BrooklynClassLoadingContext)loaderO);
        ImmutableSet encounteredTypes = item.getSymbolicName() != null ? ImmutableSet.builder().addAll(parentEncounteredTypes).add((Object)item.getSymbolicName()).build() : parentEncounteredTypes;
        if (currentlyCreatingSpec.get() == null) {
            currentlyCreatingSpec.set(new Stack());
        }
        currentlyCreatingSpec.get().push(item);
        try {
            String planYaml = RegisteredTypes.getImplementationDataStringForSpec((RegisteredType)item);
            MutableSet supers = MutableSet.copyOf((Iterable)item.getSuperTypes());
            supers.addIfNotNull(expectedType);
            AbstractBrooklynObjectSpec<?, ?> spec = CampResolver.createSpecPossiblyInferringSupers(mgmt, item, expectedType, loader, (Set<String>)encounteredTypes, planYaml, (MutableSet<Object>)supers, true);
            if (expectedType != null && !expectedType.isAssignableFrom(spec.getType())) {
                throw new IllegalStateException("Creating spec from " + item + ", got " + spec.getType() + " which is incompatible with expected " + expectedType);
            }
            spec.stackCatalogItemId(item.getId());
            if (spec instanceof EntitySpec) {
                String name = spec.getDisplayName();
                Object defaultNameConf = spec.getConfig().get(AbstractEntity.DEFAULT_DISPLAY_NAME);
                Object defaultNameFlag = spec.getFlags().get(AbstractEntity.DEFAULT_DISPLAY_NAME.getName());
                if (Strings.isBlank((CharSequence)name) && defaultNameConf == null && defaultNameFlag == null) {
                    spec.configure(AbstractEntity.DEFAULT_DISPLAY_NAME, (Object)item.getDisplayName());
                }
            } else if (Strings.isNonBlank((CharSequence)item.getDisplayName())) {
                spec.displayName(item.getDisplayName());
            }
            AbstractBrooklynObjectSpec<?, ?> abstractBrooklynObjectSpec = spec;
            return abstractBrooklynObjectSpec;
        }
        finally {
            currentlyCreatingSpec.get().pop();
            if (currentlyCreatingSpec.get().isEmpty()) {
                currentlyCreatingSpec.remove();
            }
        }
    }

    private static AbstractBrooklynObjectSpec<?, ?> createSpecPossiblyInferringSupers(ManagementContext mgmt, RegisteredType item, Class<?> expectedType, BrooklynClassLoadingContext loader, Set<String> encounteredTypes, String planYaml, MutableSet<Object> supers, boolean canInferSupers) {
        if (RegisteredTypes.isAnyTypeSubtypeOf(supers, Policy.class)) {
            return CampInternalUtils.createPolicySpec(planYaml, loader, encounteredTypes);
        }
        if (RegisteredTypes.isAnyTypeSubtypeOf(supers, Enricher.class)) {
            return CampInternalUtils.createEnricherSpec(planYaml, loader, encounteredTypes);
        }
        if (RegisteredTypes.isAnyTypeSubtypeOf(supers, Location.class)) {
            return CampInternalUtils.createLocationSpec(planYaml, loader, encounteredTypes);
        }
        if (RegisteredTypes.isAnyTypeSubtypeOf(supers, Application.class)) {
            return CampResolver.createEntitySpecFromServicesBlock(mgmt, planYaml, loader, encounteredTypes, true);
        }
        if (RegisteredTypes.isAnyTypeSubtypeOf(supers, Entity.class)) {
            return CampResolver.createEntitySpecFromServicesBlock(mgmt, planYaml, loader, encounteredTypes, false);
        }
        String msg = item.getSuperTypes() == null || item.getSuperTypes().isEmpty() ? "no supertypes declared" : "incompatible supertypes " + item.getSuperTypes();
        Exception error = null;
        if (canInferSupers) {
            try {
                Object pm;
                if (item.getPlan().getPlanData() instanceof String && (pm = Iterables.getOnlyElement((Iterable)Yamls.parseAll((String)((String)item.getPlan().getPlanData())))) instanceof Map) {
                    String t = (String)new BrooklynYamlTypeInstantiator.Factory(loader, "camp-spec type inferencing").from((Map)pm).getTypeName().orNull();
                    if (t != null) {
                        Maybe tt = new BrooklynTypeNameResolution.BrooklynTypeNameResolver("camp-spec type inferencing", loader, true, true).findTypeToken(t);
                        if (tt.isPresent()) {
                            MutableSet newSupers = MutableSet.copyOf(supers);
                            if (newSupers.add((Object)((TypeToken)tt.get()).getRawType())) {
                                try {
                                    return CampResolver.createSpecPossiblyInferringSupers(mgmt, item, expectedType, loader, encounteredTypes, planYaml, (MutableSet<Object>)newSupers, false);
                                }
                                catch (Exception e) {
                                    error = e;
                                    msg = "type " + t + " (" + tt.get() + ") threw an error";
                                }
                            } else {
                                msg = msg + " (tried " + tt.get() + " from " + t + ")";
                            }
                        } else {
                            msg = msg + " (and could not load " + t + ")";
                        }
                    } else {
                        msg = msg + " (and no type specified)";
                    }
                }
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                msg = msg + " (" + e + ")";
            }
        }
        String itemName = (String)Strings.firstNonBlank((CharSequence[])new String[]{item.getSymbolicName(), (String)BasicBrooklynCatalog.currentlyResolvingType.get(), "<unidentified>"});
        throw new IllegalStateException("Cannot create " + itemName + " as spec because " + msg + " (" + currentlyCreatingSpec.get() + ")", error);
    }

    private static EntitySpec<?> createEntitySpecFromServicesBlock(ManagementContext mgmt, String plan, BrooklynClassLoadingContext loader, Set<String> encounteredTypes, boolean isApplication) {
        CampPlatform camp = CampInternalUtils.getCampPlatform(loader.getManagementContext());
        AssemblyTemplate at = CampInternalUtils.resolveDeploymentPlan(plan, loader, camp);
        AssemblyTemplateInstantiator instantiator = CampInternalUtils.getInstantiator(at);
        if (instantiator instanceof AssemblyTemplateSpecInstantiator) {
            EntitySpec appSpec = ((AssemblyTemplateSpecInstantiator)instantiator).createApplicationSpec(at, camp, loader, encounteredTypes);
            EntitySpec result = !isApplication ? EntityManagementUtils.unwrapEntity(appSpec) : appSpec;
            CampResolver.fixScopeRootAtRoot(mgmt, result);
            return result;
        }
        if (at.getPlatformComponentTemplates() == null || at.getPlatformComponentTemplates().isEmpty()) {
            throw new UnsupportedTypePlanException("No 'services' declared");
        }
        throw new IllegalStateException("Unable to instantiate YAML; invalid type or parameters in plan:\n" + plan);
    }

    static void fixScopeRootAtRoot(ManagementContext mgmt, EntitySpec<?> node) {
        node.getConfig().entrySet().forEach(entry -> CampResolver.fixScopeRoot(mgmt, entry.getValue(), newValue -> {
            EntitySpec cfr_ignored_0 = (EntitySpec)node.configure((ConfigKey)entry.getKey(), newValue);
        }));
        node.getFlags().entrySet().forEach(entry -> CampResolver.fixScopeRoot(mgmt, entry.getValue(), newValue -> {
            EntitySpec cfr_ignored_0 = (EntitySpec)node.configure((CharSequence)entry.getKey(), newValue);
        }));
    }

    private static void fixScopeRoot(ManagementContext mgmt, Object value, Consumer<Object> updater) {
        Function<String, String> fixString = v -> "$brooklyn:self()" + Strings.removeFromStart((String)v, (String)"$brooklyn:scopeRoot()");
        if (value instanceof BrooklynDslDeferredSupplier && value.toString().startsWith("$brooklyn:scopeRoot()")) {
            updater.accept(DslUtils.parseBrooklynDsl(mgmt, fixString.apply(value.toString())));
            return;
        }
        if (value instanceof String) {
            if (((String)value).startsWith("$brooklyn:scopeRoot()")) {
                updater.accept(fixString.apply((String)value));
            }
            return;
        }
        if (value instanceof DslComponent) {
            if (((DslComponent)value).getScope() == DslComponent.Scope.SCOPE_ROOT) {
                updater.accept(DslComponent.newInstanceChangingScope(DslComponent.Scope.THIS, (DslComponent)value, fixString));
            }
            return;
        }
    }
}

