/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.filter;

import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import javax.annotation.Priority;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementContext;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.core.mgmt.entitlement.WebEntitlementContext;
import org.apache.brooklyn.rest.filter.RequestTaggingRsFilter;
import org.apache.brooklyn.rest.util.MultiSessionAttributeAdapter;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.text.Strings;

@Provider
@Priority(value=400)
public class EntitlementContextFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    @Context
    private HttpServletRequest request;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String userName = null;
        SecurityContext securityContext = requestContext.getSecurityContext();
        Principal user = securityContext.getUserPrincipal();
        userName = user != null ? user.getName() : Strings.toString((Object)this.getAttributeFromSession("brooklyn.user"));
        if (userName != null) {
            EntitlementContext oldEntitlement = Entitlements.getEntitlementContext();
            if (oldEntitlement != null && !userName.equals(oldEntitlement.user())) {
                throw new IllegalStateException("Illegal entitlement context switch, from user " + oldEntitlement.user() + " to " + userName);
            }
            String uri = this.request.getRequestURI();
            String remoteAddr = this.request.getRemoteAddr();
            String uid = RequestTaggingRsFilter.getTag();
            WebEntitlementContext entitlementContext = new WebEntitlementContext(userName, remoteAddr, uri, uid, (Map)MutableMap.of().addIfNotNull((Object)"brooklyn.entitlements.user.groups", this.getAttributeFromSession("brooklyn.entitlements.user.groups")).addIfNotNull((Object)"brooklyn.entitlements.user.groups.origin", this.getAttributeFromSession("brooklyn.entitlements.user.groups.origin")));
            Entitlements.setEntitlementContext((EntitlementContext)entitlementContext);
        }
    }

    private Object getAttributeFromSession(String attributeName) {
        MultiSessionAttributeAdapter s;
        if (this.request != null && (s = MultiSessionAttributeAdapter.of(this.request, false)) != null) {
            return s.getAttribute(attributeName);
        }
        return null;
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        Entitlements.clearEntitlementContext();
    }
}

