/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds.templates.customize;

import org.apache.brooklyn.location.jclouds.JcloudsLocationConfig;
import org.apache.brooklyn.location.jclouds.templates.customize.TemplateBuilderCustomizer;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.Enums;
import org.apache.brooklyn.util.text.ByteSizeStrings;
import org.apache.brooklyn.util.text.Strings;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.domain.TemplateBuilderSpec;

public class TemplateBuilderCustomizers {
    private TemplateBuilderCustomizers() {
    }

    public static TemplateBuilderCustomizer hardwareId() {
        return new HardwareIdTemplateBuilder();
    }

    public static TemplateBuilderCustomizer imageDescription() {
        return new ImageDescriptionRegexTemplateBuilder();
    }

    public static TemplateBuilderCustomizer imageId() {
        return new ImageIdTemplateBuilder();
    }

    public static TemplateBuilderCustomizer imageNameRegex() {
        return new ImageNameRegexTemplateBuilder();
    }

    public static TemplateBuilderCustomizer minCores() {
        return new MinCoresTemplateBuilder();
    }

    public static TemplateBuilderCustomizer minDisk() {
        return new MinDiskTemplateBuilder();
    }

    public static TemplateBuilderCustomizer minRam() {
        return new MinRamTemplateBuilder();
    }

    public static TemplateBuilderCustomizer noOp() {
        return new NoOpTemplateBuilder();
    }

    public static TemplateBuilderCustomizer os64Bit() {
        return new Os64BitTemplateBuidler();
    }

    public static TemplateBuilderCustomizer osFamily() {
        return new OsFamilyTemplateBuilder();
    }

    public static TemplateBuilderCustomizer osVersionRegex() {
        return new OsVersionRegexTemplateBuilder();
    }

    public static TemplateBuilderCustomizer templateSpec() {
        return new TemplateSpecTemplateBuilder();
    }

    private static class NoOpTemplateBuilder
    implements TemplateBuilderCustomizer {
        private NoOpTemplateBuilder() {
        }

        @Override
        public void apply(TemplateBuilder tb, ConfigBag props, Object v) {
        }
    }

    private static class Os64BitTemplateBuidler
    implements TemplateBuilderCustomizer {
        private Os64BitTemplateBuidler() {
        }

        @Override
        public void apply(TemplateBuilder tb, ConfigBag props, Object v) {
            Boolean os64Bit = (Boolean)TypeCoercions.coerce((Object)v, Boolean.class);
            if (os64Bit != null) {
                tb.os64Bit(os64Bit.booleanValue());
            }
        }
    }

    private static class TemplateSpecTemplateBuilder
    implements TemplateBuilderCustomizer {
        private TemplateSpecTemplateBuilder() {
        }

        @Override
        public void apply(TemplateBuilder tb, ConfigBag props, Object v) {
            tb.from(TemplateBuilderSpec.parse((String)v.toString()));
        }
    }

    private static class OsVersionRegexTemplateBuilder
    implements TemplateBuilderCustomizer {
        private OsVersionRegexTemplateBuilder() {
        }

        @Override
        public void apply(TemplateBuilder tb, ConfigBag props, Object v) {
            tb.osVersionMatches(v.toString());
        }
    }

    private static class OsFamilyTemplateBuilder
    implements TemplateBuilderCustomizer {
        private OsFamilyTemplateBuilder() {
        }

        @Override
        public void apply(TemplateBuilder tb, ConfigBag props, Object v) {
            Maybe osFamily = Enums.valueOfIgnoreCase(OsFamily.class, (String)v.toString());
            if (osFamily.isAbsent()) {
                throw new IllegalArgumentException("Invalid " + JcloudsLocationConfig.OS_FAMILY + " value " + v);
            }
            tb.osFamily((OsFamily)osFamily.get());
        }
    }

    private static class ImageNameRegexTemplateBuilder
    implements TemplateBuilderCustomizer {
        private ImageNameRegexTemplateBuilder() {
        }

        @Override
        public void apply(TemplateBuilder tb, ConfigBag props, Object v) {
            tb.imageNameMatches(v.toString());
        }
    }

    private static class ImageDescriptionRegexTemplateBuilder
    implements TemplateBuilderCustomizer {
        private ImageDescriptionRegexTemplateBuilder() {
        }

        @Override
        public void apply(TemplateBuilder tb, ConfigBag props, Object v) {
            tb.imageDescriptionMatches(v.toString());
        }
    }

    private static class ImageIdTemplateBuilder
    implements TemplateBuilderCustomizer {
        private ImageIdTemplateBuilder() {
        }

        @Override
        public void apply(TemplateBuilder tb, ConfigBag props, Object v) {
            tb.imageId(v.toString());
        }
    }

    private static class HardwareIdTemplateBuilder
    implements TemplateBuilderCustomizer {
        private HardwareIdTemplateBuilder() {
        }

        @Override
        public void apply(TemplateBuilder tb, ConfigBag props, Object v) {
            tb.hardwareId(v.toString());
        }
    }

    private static class MinDiskTemplateBuilder
    implements TemplateBuilderCustomizer {
        private MinDiskTemplateBuilder() {
        }

        @Override
        public void apply(TemplateBuilder tb, ConfigBag props, Object v) {
            tb.minDisk((double)((int)(ByteSizeStrings.parse((String)Strings.toString((Object)v), (String)"gb") / 1000L / 1000L / 1000L)));
        }
    }

    private static class MinCoresTemplateBuilder
    implements TemplateBuilderCustomizer {
        private MinCoresTemplateBuilder() {
        }

        @Override
        public void apply(TemplateBuilder tb, ConfigBag props, Object v) {
            tb.minCores(((Double)TypeCoercions.coerce((Object)v, Double.class)).doubleValue());
        }
    }

    private static class MinRamTemplateBuilder
    implements TemplateBuilderCustomizer {
        private MinRamTemplateBuilder() {
        }

        @Override
        public void apply(TemplateBuilder tb, ConfigBag props, Object v) {
            tb.minRam((int)(ByteSizeStrings.parse((String)Strings.toString((Object)v), (String)"mb") / 1000L / 1000L));
        }
    }
}

