/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.feed.function;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.feed.AbstractFeed;
import org.apache.brooklyn.feed.function.FunctionPollConfig;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionFeed
extends AbstractFeed {
    private static final Logger log = LoggerFactory.getLogger(FunctionFeed.class);
    public static final ConfigKey<SetMultimap<FunctionPollIdentifier, FunctionPollConfig<?, ?>>> POLLS = ConfigKeys.newConfigKey(new TypeToken<SetMultimap<FunctionPollIdentifier, FunctionPollConfig<?, ?>>>(){}, "polls");

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String uniqueTag) {
        return new Builder().uniqueTag(uniqueTag);
    }

    public FunctionFeed() {
    }

    protected FunctionFeed(Builder builder) {
        this.config().set(ONLY_IF_SERVICE_UP, builder.onlyIfServiceUp);
        HashMultimap polls = HashMultimap.create();
        for (FunctionPollConfig config : builder.polls) {
            if (!config.isEnabled()) continue;
            FunctionPollConfig configCopy = new FunctionPollConfig(config);
            if (configCopy.getPeriod() < 0L) {
                configCopy.period(builder.period, builder.periodUnits);
            }
            Callable<Object> job = config.getCallable();
            polls.put((Object)new FunctionPollIdentifier(job), configCopy);
        }
        if (builder.name != null) {
            this.setDisplayName(builder.name);
        } else if (builder.uniqueTag != null) {
            this.setDisplayName(builder.uniqueTag);
        }
        this.config().set(POLLS, polls);
        this.initUniqueTag(builder.uniqueTag, polls.values());
    }

    @Override
    protected void preStart() {
        this.getPoller().scheduleFeed(this, this.getConfig(POLLS), pollInfo -> pollInfo.job);
    }

    private static class FunctionPollIdentifier {
        final Callable<?> job;

        private FunctionPollIdentifier(Callable<?> job) {
            this.job = (Callable)Preconditions.checkNotNull(job, (Object)"job");
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.job});
        }

        public boolean equals(Object other) {
            return other instanceof FunctionPollIdentifier && Objects.equal(this.job, ((FunctionPollIdentifier)other).job);
        }
    }

    public static class Builder {
        private Entity entity;
        private boolean onlyIfServiceUp = false;
        private long period = 500L;
        private TimeUnit periodUnits = TimeUnit.MILLISECONDS;
        private List<FunctionPollConfig<?, ?>> polls = Lists.newArrayList();
        private String name;
        private String uniqueTag;
        private volatile boolean built;

        public Builder entity(Entity val) {
            this.entity = val;
            return this;
        }

        public Builder onlyIfServiceUp() {
            return this.onlyIfServiceUp(true);
        }

        public Builder onlyIfServiceUp(boolean onlyIfServiceUp) {
            this.onlyIfServiceUp = onlyIfServiceUp;
            return this;
        }

        public Builder period(Duration d) {
            return this.period(d.toMilliseconds(), TimeUnit.MILLISECONDS);
        }

        public Builder period(long millis) {
            return this.period(millis, TimeUnit.MILLISECONDS);
        }

        public Builder period(long val, TimeUnit units) {
            this.period = val;
            this.periodUnits = units;
            return this;
        }

        public Builder poll(FunctionPollConfig<?, ?> config) {
            this.polls.add(config);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder uniqueTag(String uniqueTag) {
            this.uniqueTag = uniqueTag;
            return this;
        }

        public FunctionFeed build() {
            return this.build(false);
        }

        public FunctionFeed build(boolean registerOnEntity) {
            this.built = true;
            return AbstractFeed.initAndMaybeStart(new FunctionFeed(this), this.entity, registerOnEntity);
        }

        protected void finalize() {
            if (!this.built) {
                log.warn("FunctionFeed.Builder created, but build() never called");
            }
        }
    }
}

