/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.brooklyn.entity.webapp.jboss;

import org.testng.annotations.Test;

import static org.testng.Assert.assertEquals;

import org.apache.brooklyn.entity.webapp.jboss.JBoss7SshDriver;

/**
 * Expected values in tests were generated by AS7's add-user.sh script and copied here.
 */
public class JBoss7PasswordHashingTest {

    @Test
    public void testPasswordForManagementRealm() {
        assertEquals(
                JBoss7SshDriver.hashPassword("username", "password", "ManagementRealm"),
                "8959126dd54df47f694cd762a51a1a6f");
        assertEquals(
                JBoss7SshDriver.hashPassword("test", "123", "ManagementRealm"),
                "090d846d31185e54a5e8811a2ccb43ee");
    }

    @Test
    public void testPasswordForApplicationRealm() {
        assertEquals(
                JBoss7SshDriver.hashPassword("username", "password", "ApplicationRealm"),
                "888a0504c559a34b1c3e919dcec6d941");
        assertEquals(
                JBoss7SshDriver.hashPassword("test", "321", "ApplicationRealm"),
                "a0fdaa45e2d509ac2d390ff6820e2a10");
    }

    @Test
    public void testPasswordForCustomRealm() {
        assertEquals(
                JBoss7SshDriver.hashPassword("abcdef", "ghijkl", "BrooklynRealm"),
                "a65be1ba2eb88b9b9edc6a2a7105af72");
        assertEquals(
                JBoss7SshDriver.hashPassword("username", "password", "BrooklynRealm"),
                "161124b73591a1483330f496311b0692");
    }

}
