/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.javalang.coerce;

import com.google.common.primitives.Primitives;
import java.lang.reflect.Method;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.apache.brooklyn.util.javalang.coerce.ClassCoercionException;
import org.apache.brooklyn.util.text.StringEscapes;

public class PrimitiveStringTypeCoercions {
    public static <T> Maybe<T> tryCoerce(Object value, Class<? super T> targetType) {
        Maybe<T> result = null;
        if (PrimitiveStringTypeCoercions.isPrimitiveOrBoxer(targetType) && PrimitiveStringTypeCoercions.isPrimitiveOrBoxer(value.getClass()) && (result = PrimitiveStringTypeCoercions.castPrimitiveMaybe(value, targetType)).isPresent()) {
            return result;
        }
        if (value instanceof String && PrimitiveStringTypeCoercions.isPrimitiveOrBoxer(targetType) && (result = PrimitiveStringTypeCoercions.stringToPrimitiveMaybe((String)value, targetType)).isPresent()) {
            return result;
        }
        if (PrimitiveStringTypeCoercions.isPrimitiveOrBoxer(value.getClass()) && targetType.equals(String.class)) {
            return Maybe.of(value.toString());
        }
        String targetTypeSimpleName = JavaClassNames.verySimpleClassName(targetType);
        if (targetTypeSimpleName != null && targetTypeSimpleName.length() > 0) {
            for (Method m : value.getClass().getMethods()) {
                if (!m.getName().startsWith("as") || m.getParameterTypes().length != 0 || !targetType.isAssignableFrom(m.getReturnType()) || !m.getName().equals("as" + JavaClassNames.verySimpleClassName(m.getReturnType()))) continue;
                try {
                    return Maybe.of(m.invoke(value, new Object[0]));
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal(e);
                    return Maybe.absent(new ClassCoercionException("Cannot coerce type " + value.getClass() + " to " + targetType.getCanonicalName() + " (" + value + "): " + m.getName() + " adapting failed, " + e));
                }
            }
        }
        return result;
    }

    @Deprecated
    public static <T> T castPrimitive(Object value, Class<T> targetType) {
        return PrimitiveStringTypeCoercions.castPrimitiveMaybe(value, targetType).get();
    }

    public static <T> Maybe<T> castPrimitiveMaybe(Object value, Class<T> targetType) {
        Class targetWrapType;
        if (value == null) {
            return null;
        }
        assert (PrimitiveStringTypeCoercions.isPrimitiveOrBoxer(targetType)) : "targetType=" + targetType;
        assert (PrimitiveStringTypeCoercions.isPrimitiveOrBoxer(value.getClass())) : "value=" + targetType + "; valueType=" + value.getClass();
        Class sourceWrapType = Primitives.wrap(value.getClass());
        if (sourceWrapType == (targetWrapType = Primitives.wrap(targetType))) {
            return Maybe.of(value);
        }
        if (targetWrapType == Boolean.class) {
            if (sourceWrapType == Character.class) {
                return PrimitiveStringTypeCoercions.stringToPrimitiveMaybe(value.toString(), targetType);
            }
            return Maybe.absent(new ClassCoercionException("Cannot cast " + sourceWrapType + " (" + value + ") to " + targetType));
        }
        if (sourceWrapType == Boolean.class) {
            return Maybe.absent(new ClassCoercionException("Cannot cast " + sourceWrapType + " (" + value + ") to " + targetType));
        }
        long v = 0L;
        boolean islong = true;
        if (sourceWrapType == Character.class) {
            v = ((Character)value).charValue();
        } else if (sourceWrapType == Byte.class) {
            v = ((Byte)value).byteValue();
        } else if (sourceWrapType == Short.class) {
            v = ((Short)value).shortValue();
        } else if (sourceWrapType == Integer.class) {
            v = ((Integer)value).intValue();
        } else if (sourceWrapType == Long.class) {
            v = (Long)value;
        } else {
            islong = false;
        }
        if (islong) {
            if (targetWrapType == Character.class) {
                return Maybe.of(Character.valueOf((char)v));
            }
            if (targetWrapType == Byte.class) {
                return Maybe.of((byte)v);
            }
            if (targetWrapType == Short.class) {
                return Maybe.of((short)v);
            }
            if (targetWrapType == Integer.class) {
                return Maybe.of((int)v);
            }
            if (targetWrapType == Long.class) {
                return Maybe.of(v);
            }
            if (targetWrapType == Float.class) {
                return Maybe.of(Float.valueOf(v));
            }
            if (targetWrapType == Double.class) {
                return Maybe.of(Double.valueOf(v));
            }
            return Maybe.absent(new IllegalStateException("Unexpected: sourceType=" + sourceWrapType + "; targetType=" + targetWrapType));
        }
        double d = 0.0;
        boolean isdouble = true;
        if (sourceWrapType == Float.class) {
            d = ((Float)value).floatValue();
        } else if (sourceWrapType == Double.class) {
            d = (Double)value;
        } else {
            isdouble = false;
        }
        if (isdouble) {
            if (targetWrapType == Character.class) {
                return Maybe.of(Character.valueOf((char)d));
            }
            if (targetWrapType == Byte.class) {
                return Maybe.of((byte)d);
            }
            if (targetWrapType == Short.class) {
                return Maybe.of((short)d);
            }
            if (targetWrapType == Integer.class) {
                return Maybe.of((int)d);
            }
            if (targetWrapType == Long.class) {
                return Maybe.of((long)d);
            }
            if (targetWrapType == Float.class) {
                return Maybe.of(Float.valueOf((float)d));
            }
            if (targetWrapType == Double.class) {
                return Maybe.of(d);
            }
            return Maybe.absent(new IllegalStateException("Unexpected: sourceType=" + sourceWrapType + "; targetType=" + targetWrapType));
        }
        return Maybe.absent(new IllegalStateException("Unexpected: sourceType=" + sourceWrapType + "; targetType=" + targetWrapType));
    }

    public static boolean isPrimitiveOrBoxer(Class<?> type) {
        return Primitives.allPrimitiveTypes().contains(type) || Primitives.allWrapperTypes().contains(type);
    }

    @Deprecated
    public static <T> T stringToPrimitive(String value, Class<T> targetType) {
        return PrimitiveStringTypeCoercions.stringToPrimitiveMaybe(value, targetType).get();
    }

    public static <T> Maybe<T> stringToPrimitiveMaybe(String value, Class<T> targetType) {
        assert (Primitives.allPrimitiveTypes().contains(targetType) || Primitives.allWrapperTypes().contains(targetType)) : "targetType=" + targetType;
        if (targetType == Character.class || targetType == Character.TYPE) {
            if (value.length() == 1) {
                return Maybe.of(Character.valueOf(value.charAt(0)));
            }
            if (value.length() != 1) {
                throw new ClassCoercionException("Cannot coerce type String to " + targetType.getCanonicalName() + " (" + value + "): adapting failed");
            }
        }
        value = value.trim();
        if (targetType == Boolean.class || targetType == Boolean.TYPE) {
            if ("true".equalsIgnoreCase(value)) {
                return Maybe.of(Boolean.TRUE);
            }
            if ("false".equalsIgnoreCase(value)) {
                return Maybe.of(Boolean.FALSE);
            }
            if ("yes".equalsIgnoreCase(value)) {
                return Maybe.of(Boolean.TRUE);
            }
            if ("no".equalsIgnoreCase(value)) {
                return Maybe.of(Boolean.FALSE);
            }
            if ("t".equalsIgnoreCase(value)) {
                return Maybe.of(Boolean.TRUE);
            }
            if ("f".equalsIgnoreCase(value)) {
                return Maybe.of(Boolean.FALSE);
            }
            if ("y".equalsIgnoreCase(value)) {
                return Maybe.of(Boolean.TRUE);
            }
            if ("n".equalsIgnoreCase(value)) {
                return Maybe.of(Boolean.FALSE);
            }
            return Maybe.absent(new ClassCoercionException("Cannot coerce type String to " + targetType.getCanonicalName() + " (" + value + "): adapting failed"));
        }
        Class wrappedType = Primitives.allPrimitiveTypes().contains(targetType) ? Primitives.wrap(targetType) : targetType;
        try {
            return Maybe.of(wrappedType.getMethod("valueOf", String.class).invoke(null, value));
        }
        catch (Exception e) {
            ClassCoercionException tothrow = new ClassCoercionException("Cannot coerce " + StringEscapes.JavaStringEscapes.wrapJavaString(value) + " to " + targetType.getCanonicalName() + " (" + value + "): adapting failed");
            tothrow.initCause(e);
            return Maybe.absent(tothrow);
        }
    }
}

