/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v3.binders;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Set;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.Json;
import org.jclouds.openstack.keystone.auth.domain.TenantOrDomainAndCredentials;
import org.jclouds.openstack.keystone.v3.domain.Auth;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;
import org.jclouds.rest.internal.GeneratedHttpRequest;

public abstract class BindAuthToJsonPayload<T>
extends BindToJsonPayload
implements MapBinder {
    private static final Set<String> SCOPE_PREFIXES = ImmutableSet.of((Object)"project", (Object)"projectId", (Object)"domain", (Object)"domainId");

    protected BindAuthToJsonPayload(Json jsonBinder) {
        super(jsonBinder);
    }

    protected abstract Auth buildAuth(TenantOrDomainAndCredentials<T> var1, Object var2);

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull(request, (Object)"request") instanceof GeneratedHttpRequest), (Object)"this binder is only valid for GeneratedHttpRequests!");
        GeneratedHttpRequest gRequest = (GeneratedHttpRequest)request;
        Optional authentication = Iterables.tryFind((Iterable)gRequest.getInvocation().getArgs(), (Predicate)Predicates.instanceOf(TenantOrDomainAndCredentials.class));
        Preconditions.checkArgument((boolean)authentication.isPresent(), (Object)"no credentials found in the api call arguments");
        TenantOrDomainAndCredentials credentials = (TenantOrDomainAndCredentials)authentication.get();
        Object scope = this.parseScope(credentials);
        Auth auth = this.buildAuth(credentials, scope);
        HttpRequest authRequest = super.bindToRequest(request, (Object)ImmutableMap.of((Object)"auth", (Object)auth));
        authRequest.getPayload().setSensitive(true);
        return (R)authRequest;
    }

    private Object parseScope(TenantOrDomainAndCredentials<T> credentials) {
        String scope = credentials.scope();
        if (!scope.contains(":")) {
            Preconditions.checkArgument((boolean)scope.equals("unscoped"), (String)"Invalid scope: %s", (Object[])new Object[]{scope});
            return "unscoped";
        }
        String[] parts = scope.split(":");
        Preconditions.checkArgument((parts.length == 2 ? 1 : 0) != 0, (String)"Invalid scope: %s", (Object[])new Object[]{scope});
        Preconditions.checkArgument((boolean)SCOPE_PREFIXES.contains(parts[0]), (String)"Scope prefix should be: %s", (Object[])new Object[]{SCOPE_PREFIXES});
        if ("project".equals(parts[0])) {
            return Auth.ProjectScope.create(Auth.ProjectScope.ProjectName.create(parts[1], this.parseProjectDomain(credentials, true)));
        }
        if ("projectId".equals(parts[0])) {
            return Auth.ProjectIdScope.create(Auth.ProjectIdScope.ProjectId.create(parts[1], this.parseProjectDomain(credentials, false)));
        }
        if ("domain".equals(parts[0])) {
            return Auth.DomainScope.create(Auth.Name.create(parts[1]));
        }
        return Auth.DomainIdScope.create(Auth.Id.create(parts[1]));
    }

    private Object parseProjectDomain(TenantOrDomainAndCredentials<T> credentials, boolean useTenantAsDefaultDomain) {
        Object domainScope = null;
        if (useTenantAsDefaultDomain && credentials.tenantOrDomainId() != null) {
            domainScope = Auth.Id.create(credentials.tenantOrDomainId());
        } else if (credentials.projectDomainName() != null) {
            domainScope = Auth.Name.create(credentials.projectDomainName());
        } else if (credentials.projectDomainId() != null) {
            domainScope = Auth.Id.create(credentials.projectDomainId());
        } else if (useTenantAsDefaultDomain) {
            domainScope = Auth.Name.create(credentials.tenantOrDomainName());
        }
        return domainScope;
    }
}

