/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.internal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.brooklyn.api.catalog.BrooklynCatalog;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.drivers.EntityDriverManager;
import org.apache.brooklyn.api.entity.drivers.downloads.DownloadResolverManager;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationRegistry;
import org.apache.brooklyn.api.mgmt.AccessController;
import org.apache.brooklyn.api.mgmt.EntityManager;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.api.mgmt.ExecutionManager;
import org.apache.brooklyn.api.mgmt.LocationManager;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.Scratchpad;
import org.apache.brooklyn.api.mgmt.SubscriptionContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementManager;
import org.apache.brooklyn.api.mgmt.ha.HighAvailabilityManager;
import org.apache.brooklyn.api.mgmt.ha.HighAvailabilityMode;
import org.apache.brooklyn.api.mgmt.ha.ManagementNodeState;
import org.apache.brooklyn.api.mgmt.ha.ManagementPlaneSyncRecord;
import org.apache.brooklyn.api.mgmt.ha.ManagementPlaneSyncRecordPersister;
import org.apache.brooklyn.api.mgmt.rebind.ChangeListener;
import org.apache.brooklyn.api.mgmt.rebind.PersistenceExceptionHandler;
import org.apache.brooklyn.api.mgmt.rebind.RebindExceptionHandler;
import org.apache.brooklyn.api.mgmt.rebind.RebindManager;
import org.apache.brooklyn.api.mgmt.rebind.mementos.BrooklynMementoPersister;
import org.apache.brooklyn.api.mgmt.rebind.mementos.BrooklynMementoRawData;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.EntityAdjunct;
import org.apache.brooklyn.api.typereg.BrooklynTypeRegistry;
import org.apache.brooklyn.config.StringConfigMap;
import org.apache.brooklyn.core.catalog.internal.CatalogInitialization;
import org.apache.brooklyn.core.entity.AbstractEntity;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.internal.storage.BrooklynStorage;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.mgmt.ha.OsgiManager;
import org.apache.brooklyn.core.mgmt.internal.AccessManager;
import org.apache.brooklyn.core.mgmt.internal.BasicSubscriptionContext;
import org.apache.brooklyn.core.mgmt.internal.CollectionChangeListener;
import org.apache.brooklyn.core.mgmt.internal.ExternalConfigSupplierRegistry;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.mgmt.internal.NonDeploymentAccessManager;
import org.apache.brooklyn.core.mgmt.internal.NonDeploymentEntityManager;
import org.apache.brooklyn.core.mgmt.internal.NonDeploymentLocationManager;
import org.apache.brooklyn.core.mgmt.internal.NonDeploymentUsageManager;
import org.apache.brooklyn.core.mgmt.internal.QueueingSubscriptionManager;
import org.apache.brooklyn.core.mgmt.usage.UsageManager;
import org.apache.brooklyn.core.objs.proxy.InternalEntityFactory;
import org.apache.brooklyn.core.objs.proxy.InternalLocationFactory;
import org.apache.brooklyn.core.objs.proxy.InternalPolicyFactory;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonDeploymentManagementContext
implements ManagementContextInternal {
    private static final Logger log = LoggerFactory.getLogger(NonDeploymentManagementContext.class);
    private final AbstractEntity entity;
    private NonDeploymentManagementContextMode mode;
    private ManagementContextInternal initialManagementContext;
    private final QueueingSubscriptionManager qsm;
    private NonDeploymentEntityManager entityManager;
    private NonDeploymentLocationManager locationManager;
    private NonDeploymentAccessManager accessManager;
    private NonDeploymentUsageManager usageManager;

    public NonDeploymentManagementContext(AbstractEntity entity, NonDeploymentManagementContextMode mode) {
        this.entity = (AbstractEntity)Preconditions.checkNotNull((Object)entity, (Object)"entity");
        this.mode = (NonDeploymentManagementContextMode)((Object)Preconditions.checkNotNull((Object)((Object)mode), (Object)"mode"));
        this.qsm = new QueueingSubscriptionManager();
        this.entityManager = new NonDeploymentEntityManager(null);
        this.locationManager = new NonDeploymentLocationManager(null);
        this.accessManager = new NonDeploymentAccessManager(null);
        this.usageManager = new NonDeploymentUsageManager(null);
    }

    @Deprecated
    public String getManagementPlaneId() {
        return this.initialManagementContext == null ? null : this.initialManagementContext.getManagementPlaneId();
    }

    public Maybe<String> getManagementPlaneIdMaybe() {
        return this.initialManagementContext == null ? Maybe.absent((String)"Uninitialized non-deployment management context") : this.initialManagementContext.getManagementPlaneIdMaybe();
    }

    public String getManagementNodeId() {
        return this.initialManagementContext == null ? null : this.initialManagementContext.getManagementNodeId();
    }

    public Maybe<URI> getManagementNodeUri() {
        return this.initialManagementContext == null ? Maybe.absent() : this.initialManagementContext.getManagementNodeUri();
    }

    public void setManagementContext(ManagementContextInternal val) {
        this.initialManagementContext = (ManagementContextInternal)Preconditions.checkNotNull((Object)val, (Object)"initialManagementContext");
        this.entityManager = new NonDeploymentEntityManager(val);
        this.locationManager = new NonDeploymentLocationManager(val);
        this.accessManager = new NonDeploymentAccessManager(val);
        this.usageManager = new NonDeploymentUsageManager(val);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("entity", (Object)this.entity.getId()).add("mode", (Object)this.mode).toString();
    }

    public void setMode(NonDeploymentManagementContextMode mode) {
        this.mode = (NonDeploymentManagementContextMode)((Object)Preconditions.checkNotNull((Object)((Object)mode), (Object)"mode"));
    }

    public NonDeploymentManagementContextMode getMode() {
        return this.mode;
    }

    public Collection<Application> getApplications() {
        return Collections.emptyList();
    }

    public boolean isRunning() {
        return true;
    }

    public boolean isStartupComplete() {
        return false;
    }

    public ManagementNodeState getNodeState() {
        return ManagementNodeState.INITIALIZING;
    }

    @Override
    public InternalEntityFactory getEntityFactory() {
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.getEntityFactory();
    }

    @Override
    public InternalLocationFactory getLocationFactory() {
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.getLocationFactory();
    }

    @Override
    public InternalPolicyFactory getPolicyFactory() {
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.getPolicyFactory();
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public LocationManager getLocationManager() {
        return this.locationManager;
    }

    @Override
    public AccessManager getAccessManager() {
        return this.accessManager;
    }

    @Override
    public UsageManager getUsageManager() {
        return this.usageManager;
    }

    @Override
    public Maybe<OsgiManager> getOsgiManager() {
        switch (this.mode) {
            case PRE_MANAGEMENT: 
            case MANAGEMENT_STARTING: 
            case MANAGEMENT_STARTED: {
                this.checkInitialManagementContextReal();
                return this.initialManagementContext.getOsgiManager();
            }
        }
        return Maybe.absent((String)("Entity " + this.entity + " is no longer managed; OSGi context no longer available"));
    }

    public AccessController getAccessController() {
        return this.getAccessManager().getAccessController();
    }

    public ExecutionManager getExecutionManager() {
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.getExecutionManager();
    }

    public QueueingSubscriptionManager getSubscriptionManager() {
        return this.qsm;
    }

    public synchronized SubscriptionContext getSubscriptionContext(Entity entity) {
        if (!this.entity.equals(entity)) {
            throw new IllegalStateException("Non-deployment context " + this + " can only use a single Entity: has " + this.entity + ", but passed " + entity);
        }
        if (this.mode == NonDeploymentManagementContextMode.MANAGEMENT_STOPPED) {
            throw new IllegalStateException("Entity " + entity + " is no longer managed; subscription context not available");
        }
        ImmutableMap subscriptionFlags = ImmutableMap.of((Object)"tags", (Object)ImmutableList.of((Object)BrooklynTaskTags.tagForContextEntity(entity)));
        return new BasicSubscriptionContext((Map<String, ?>)subscriptionFlags, this.qsm, entity);
    }

    public SubscriptionContext getSubscriptionContext(Entity entity, EntityAdjunct adjunct) {
        if (!this.entity.equals(entity)) {
            throw new IllegalStateException("Non-deployment context " + this + " can only use a single Entity: has " + this.entity + ", but passed " + entity);
        }
        if (this.mode == NonDeploymentManagementContextMode.MANAGEMENT_STOPPED) {
            throw new IllegalStateException("Entity " + entity + " is no longer managed; subscription context not available");
        }
        ImmutableMap subscriptionFlags = ImmutableMap.of((Object)"tags", (Object)ImmutableList.of((Object)BrooklynTaskTags.tagForContextEntity(entity), BrooklynTaskTags.tagForContextAdjunct(adjunct)));
        return new BasicSubscriptionContext((Map<String, ?>)subscriptionFlags, this.qsm, entity);
    }

    public synchronized SubscriptionContext getSubscriptionContext(Location loc) {
        throw new UnsupportedOperationException();
    }

    public ExecutionContext getExecutionContext(Entity entity) {
        if (!this.entity.equals(entity)) {
            throw new IllegalStateException("Non-deployment context " + this + " can only use a single Entity: has " + this.entity + ", but passed " + entity);
        }
        if (this.mode == NonDeploymentManagementContextMode.MANAGEMENT_STOPPED) {
            throw new IllegalStateException("Entity " + entity + " is no longer managed; execution context not available");
        }
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.getExecutionContext(entity);
    }

    public ExecutionContext getExecutionContext(Entity entity, EntityAdjunct adjunct) {
        if (!this.entity.equals(entity)) {
            throw new IllegalStateException("Non-deployment context " + this + " can only use a single Entity: has " + this.entity + ", but passed " + entity);
        }
        if (this.mode == NonDeploymentManagementContextMode.MANAGEMENT_STOPPED) {
            throw new IllegalStateException("Entity " + entity + " is no longer managed; execution context not available");
        }
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.getExecutionContext(entity, adjunct);
    }

    public ExecutionContext getServerExecutionContext() {
        return this.initialManagementContext.getServerExecutionContext();
    }

    public EntityDriverManager getEntityDriverManager() {
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.getEntityDriverManager();
    }

    public DownloadResolverManager getEntityDownloadsManager() {
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.getEntityDownloadsManager();
    }

    public StringConfigMap getConfig() {
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.getConfig();
    }

    @Override
    public BrooklynProperties getBrooklynProperties() {
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.getBrooklynProperties();
    }

    public Scratchpad getScratchpad() {
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.getScratchpad();
    }

    @Override
    public BrooklynStorage getStorage() {
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.getStorage();
    }

    public RebindManager getRebindManager() {
        if (this.isInitialManagementContextReal()) {
            return this.initialManagementContext.getRebindManager();
        }
        return new NonDeploymentRebindManager();
    }

    public HighAvailabilityManager getHighAvailabilityManager() {
        if (this.isInitialManagementContextReal()) {
            return this.initialManagementContext.getHighAvailabilityManager();
        }
        return new NonDeploymentHighAvailabilityManager();
    }

    public LocationRegistry getLocationRegistry() {
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.getLocationRegistry();
    }

    public BrooklynCatalog getCatalog() {
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.getCatalog();
    }

    public BrooklynTypeRegistry getTypeRegistry() {
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.getTypeRegistry();
    }

    public ClassLoader getCatalogClassLoader() {
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.getCatalogClassLoader();
    }

    public EntitlementManager getEntitlementManager() {
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.getEntitlementManager();
    }

    @Override
    public <T> T invokeEffectorMethodSync(Entity entity, Effector<T> eff, Map<String, ?> args) throws ExecutionException {
        throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation: cannot invoke effector " + eff + " on entity " + entity);
    }

    @Override
    public <T> Task<T> invokeEffector(Entity entity, Effector<T> eff, Map parameters) {
        throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation: cannot invoke effector " + eff + " on entity " + entity);
    }

    @Override
    public ClassLoader getBaseClassLoader() {
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.getBaseClassLoader();
    }

    @Override
    public Iterable<URL> getBaseClassPathForScanning() {
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.getBaseClassPathForScanning();
    }

    @Override
    public void addEntitySetListener(CollectionChangeListener<Entity> listener) {
        this.checkInitialManagementContextReal();
        this.initialManagementContext.addEntitySetListener(listener);
    }

    @Override
    public void removeEntitySetListener(CollectionChangeListener<Entity> listener) {
        this.checkInitialManagementContextReal();
        this.initialManagementContext.removeEntitySetListener(listener);
    }

    @Override
    public void terminate() {
        if (this.isInitialManagementContextReal()) {
            this.initialManagementContext.terminate();
        }
    }

    @Override
    public long getTotalEffectorInvocations() {
        if (this.isInitialManagementContextReal()) {
            return this.initialManagementContext.getTotalEffectorInvocations();
        }
        return 0L;
    }

    @Override
    public void setBaseClassPathForScanning(Iterable<URL> urls) {
        this.checkInitialManagementContextReal();
        this.initialManagementContext.setBaseClassPathForScanning(urls);
    }

    @Override
    public void setManagementNodeUri(URI uri) {
        this.checkInitialManagementContextReal();
        this.initialManagementContext.setManagementNodeUri(uri);
    }

    @Override
    public void prePreManage(Entity entity) {
        log.warn("Ignoring call to prePreManage(" + entity + ") on " + this);
    }

    @Override
    public void prePreManage(Location location) {
        log.warn("Ignoring call to prePreManage(" + location + ") on " + this);
    }

    private boolean isInitialManagementContextReal() {
        return this.initialManagementContext != null && !(this.initialManagementContext instanceof NonDeploymentManagementContext);
    }

    private void checkInitialManagementContextReal() {
        if (!this.isInitialManagementContextReal()) {
            throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation.");
        }
    }

    public void reloadBrooklynProperties() {
        this.checkInitialManagementContextReal();
        this.initialManagementContext.reloadBrooklynProperties();
    }

    public void addPropertiesReloadListener(ManagementContext.PropertiesReloadListener listener) {
        this.checkInitialManagementContextReal();
        this.initialManagementContext.addPropertiesReloadListener(listener);
    }

    public void removePropertiesReloadListener(ManagementContext.PropertiesReloadListener listener) {
        this.checkInitialManagementContextReal();
        this.initialManagementContext.removePropertiesReloadListener(listener);
    }

    public BrooklynObject lookup(String id) {
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.lookup(id);
    }

    public <T extends BrooklynObject> T lookup(String id, Class<T> type) {
        this.checkInitialManagementContextReal();
        return (T)this.initialManagementContext.lookup(id, type);
    }

    public <T extends BrooklynObject> T lookup(Predicate<? super T> filter) {
        this.checkInitialManagementContextReal();
        return (T)this.initialManagementContext.lookup(filter);
    }

    public <T extends BrooklynObject> Collection<T> lookupAll(Predicate<? super T> filter) {
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.lookupAll(filter);
    }

    @Override
    public List<Throwable> errors() {
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.errors();
    }

    @Override
    public CatalogInitialization getCatalogInitialization() {
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.getCatalogInitialization();
    }

    @Override
    public void setCatalogInitialization(CatalogInitialization catalogInitialization) {
        this.checkInitialManagementContextReal();
        this.initialManagementContext.setCatalogInitialization(catalogInitialization);
    }

    @Override
    public ExternalConfigSupplierRegistry getExternalConfigProviderRegistry() {
        this.checkInitialManagementContextReal();
        return this.initialManagementContext.getExternalConfigProviderRegistry();
    }

    private class NonDeploymentHighAvailabilityManager
    implements HighAvailabilityManager {
        private NonDeploymentHighAvailabilityManager() {
        }

        public ManagementNodeState getNodeState() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public boolean isRunning() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public HighAvailabilityManager setPersister(ManagementPlaneSyncRecordPersister persister) {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public void disabled(boolean persistenceEnabled) {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public void start(HighAvailabilityMode startMode) {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public void stop() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public ManagementPlaneSyncRecordPersister getPersister() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public ManagementPlaneSyncRecord getLastManagementPlaneSyncRecord() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public ManagementPlaneSyncRecord loadManagementPlaneSyncRecord(boolean x) {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public void changeMode(HighAvailabilityMode startMode) {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public void setPriority(long priority) {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public long getPriority() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public Map<String, Object> getMetrics() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public void publishClearNonMaster() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public long getLastStateChange() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }
    }

    private class NonDeploymentRebindManager
    implements RebindManager {
        private NonDeploymentRebindManager() {
        }

        public ChangeListener getChangeListener() {
            return ChangeListener.NOOP;
        }

        public void setPersister(BrooklynMementoPersister persister) {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public void setPersister(BrooklynMementoPersister persister, PersistenceExceptionHandler exceptionHandler) {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public BrooklynMementoPersister getPersister() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public List<Application> rebind(ClassLoader classLoader, RebindExceptionHandler exceptionHandler, ManagementNodeState mode) {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public void startPersistence() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public void stopPersistence() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public void startReadOnly(ManagementNodeState state) {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public void stopReadOnly() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public void reset() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public void start() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public void stop() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public void waitForPendingComplete(Duration timeout, boolean canTrigger) throws InterruptedException, TimeoutException {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public boolean hasPending() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public void forcePersistNow(boolean full, PersistenceExceptionHandler exceptionHandler) {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public BrooklynMementoRawData retrieveMementoRawData() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public boolean isAwaitingInitialRebind() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public Map<String, Object> getMetrics() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }

        public boolean isRebindActive() {
            throw new IllegalStateException("Non-deployment context " + NonDeploymentManagementContext.this + " is not valid for this operation.");
        }
    }

    public static enum NonDeploymentManagementContextMode {
        PRE_MANAGEMENT,
        MANAGEMENT_REBINDING,
        MANAGEMENT_STARTING,
        MANAGEMENT_STARTED,
        MANAGEMENT_STOPPING,
        MANAGEMENT_STOPPED;


        public boolean isPreManaged() {
            return this == PRE_MANAGEMENT || this == MANAGEMENT_REBINDING;
        }
    }
}

