/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.domain;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jclouds.aws.ec2.domain.AutoValue_VPC;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class VPC {
    @Nullable
    public abstract String id();

    @Nullable
    public abstract State state();

    @Nullable
    public abstract String cidrBlock();

    @Nullable
    public abstract String dhcpOptionsId();

    @Nullable
    public abstract InstanceTenancy instanceTenancy();

    @Nullable
    public abstract Boolean isDefault();

    @Nullable
    public abstract Map<String, String> tags();

    @SerializedNames(value={"vpcId", "state", "cidrBlock", "dhcpOptionsId", "instanceTenancy", "isDefault", "tagSet"})
    public static VPC create(String id, State state, String cidrBlock, String dhcpOptionsId, InstanceTenancy instanceTenancy, Boolean isDefault, Map<String, String> tags) {
        return VPC.builder().id(id).state(state).isDefault(isDefault).cidrBlock(cidrBlock).dhcpOptionsId(dhcpOptionsId).instanceTenancy(instanceTenancy).tags(tags).build();
    }

    VPC() {
    }

    public static Builder builder() {
        return new AutoValue_VPC.Builder();
    }

    public static abstract class Builder {
        public abstract Builder id(String var1);

        public abstract Builder state(State var1);

        public abstract Builder cidrBlock(String var1);

        public abstract Builder dhcpOptionsId(String var1);

        public abstract Builder instanceTenancy(InstanceTenancy var1);

        public abstract Builder isDefault(Boolean var1);

        public abstract Builder tags(Map<String, String> var1);

        @Nullable
        public abstract String id();

        @Nullable
        public abstract State state();

        @Nullable
        public abstract String cidrBlock();

        @Nullable
        public abstract InstanceTenancy instanceTenancy();

        @Nullable
        public abstract Boolean isDefault();

        @Nullable
        public abstract Map<String, String> tags();

        abstract VPC autoBuild();

        public VPC build() {
            this.tags((Map<String, String>)(this.tags() != null ? ImmutableMap.copyOf(this.tags()) : ImmutableMap.of()));
            return this.autoBuild();
        }
    }

    public static enum InstanceTenancy {
        DEFAULT,
        DEDICATED,
        HOST,
        UNRECOGNIZED;


        public String value() {
            return this.name().toLowerCase();
        }

        public static InstanceTenancy fromValue(String v) {
            try {
                return InstanceTenancy.valueOf(v.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static enum State {
        AVAILABLE,
        PENDING,
        UNRECOGNIZED;


        public String value() {
            return this.name().toLowerCase();
        }

        public static State fromValue(String v) {
            try {
                return State.valueOf(v.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

