/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.messaging.rabbit;

import com.google.common.base.Objects;
import java.util.Map;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.entity.messaging.rabbit.RabbitBroker;
import org.apache.brooklyn.entity.messaging.rabbit.RabbitDriver;
import org.apache.brooklyn.entity.messaging.rabbit.RabbitQueue;
import org.apache.brooklyn.entity.software.base.SoftwareProcessImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitBrokerImpl
extends SoftwareProcessImpl
implements RabbitBroker {
    private static final Logger log = LoggerFactory.getLogger(RabbitBrokerImpl.class);

    @Override
    public String getVirtualHost() {
        return (String)this.getAttribute((AttributeSensor)VIRTUAL_HOST_NAME);
    }

    @Override
    public String getAmqpVersion() {
        return (String)this.getAttribute((AttributeSensor)AMQP_VERSION);
    }

    @Override
    public Integer getAmqpPort() {
        return (Integer)this.getAttribute((AttributeSensor)AMQP_PORT);
    }

    public RabbitDriver getDriver() {
        return (RabbitDriver)super.getDriver();
    }

    @Override
    public Map<String, String> getShellEnvironment() {
        return this.getDriver().getShellEnvironment();
    }

    @Override
    public String getRunDir() {
        return this.getDriver().getRunDir();
    }

    protected void postStart() {
        super.postStart();
        this.getDriver().configure();
    }

    @Override
    public void setBrokerUrl() {
        String urlFormat = "amqp://guest:guest@%s:%d/%s";
        this.sensors().set(BROKER_URL, (Object)String.format(urlFormat, this.getAttribute(HOSTNAME), this.getAttribute((AttributeSensor)AMQP_PORT), this.getAttribute((AttributeSensor)VIRTUAL_HOST_NAME)));
    }

    @Override
    public RabbitQueue createQueue(Map properties) {
        RabbitQueue result = (RabbitQueue)this.addChild((EntitySpec)EntitySpec.create(RabbitQueue.class).configure(properties));
        result.create();
        return result;
    }

    public Class<? extends RabbitDriver> getDriverInterface() {
        return RabbitDriver.class;
    }

    protected void connectSensors() {
        super.connectSensors();
        this.connectServiceUpIsRunning();
        this.setBrokerUrl();
        if (this.getEnableManagementPlugin()) {
            this.sensors().set(MANAGEMENT_URL, (Object)String.format("http://%s:%s/", this.getAttribute(HOSTNAME), this.getAttribute((AttributeSensor)MANAGEMENT_PORT)));
        }
    }

    public void disconnectSensors() {
        super.disconnectSensors();
        this.disconnectServiceUpIsRunning();
    }

    public boolean getEnableManagementPlugin() {
        return Boolean.TRUE.equals(this.getConfig(ENABLE_MANAGEMENT_PLUGIN));
    }

    public Integer getManagementPort() {
        return (Integer)this.getAttribute((AttributeSensor)MANAGEMENT_PORT);
    }

    protected Objects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("amqpPort", (Object)this.getAmqpPort());
    }
}

