/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.rebind.dto;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.mgmt.rebind.mementos.Memento;
import org.apache.brooklyn.api.mgmt.rebind.mementos.TreeNode;
import org.apache.brooklyn.core.mgmt.rebind.dto.AbstractMemento;

public class AbstractTreeNodeMemento
extends AbstractMemento
implements Memento,
TreeNode,
Serializable {
    private static final long serialVersionUID = -8973379097665013550L;
    private String parent;
    private List<String> children;
    private Map<String, Object> fields;

    protected AbstractTreeNodeMemento() {
    }

    protected AbstractTreeNodeMemento(Builder<?> builder) {
        super(builder);
        this.parent = builder.parent;
        this.children = this.toPersistedList(builder.children);
    }

    @Override
    @Deprecated
    protected void setCustomFields(Map<String, Object> fields) {
        this.fields = this.toPersistedMap(fields);
    }

    @Deprecated
    public Map<String, Object> getCustomFields() {
        return this.fromPersistedMap(this.fields);
    }

    public String getParent() {
        return this.parent;
    }

    public List<String> getChildren() {
        return this.fromPersistedList(this.children);
    }

    @Override
    protected MoreObjects.ToStringHelper newVerboseStringHelper() {
        return super.newVerboseStringHelper().add("parent", (Object)this.getParent()).add("children", this.getChildren());
    }

    protected static abstract class Builder<B extends Builder<?>>
    extends AbstractMemento.Builder<B> {
        boolean isValid = true;
        protected String parent;
        protected List<String> children = Lists.newArrayList();

        protected Builder() {
        }

        public B from(TreeNode other) {
            super.from((Memento)other);
            this.parent = other.getParent();
            this.children.addAll(other.getChildren());
            return (B)((Builder)this.self());
        }

        public B parent(String val) {
            this.assertValid();
            this.parent = val;
            return (B)((Builder)this.self());
        }

        public B children(List<String> val) {
            this.assertValid();
            this.children = val;
            return (B)((Builder)this.self());
        }

        public B addChild(String id) {
            this.assertValid();
            this.children.add(id);
            return (B)((Builder)this.self());
        }

        public B removeChild(String id) {
            this.assertValid();
            this.children.remove(id);
            return (B)((Builder)this.self());
        }

        protected void invalidate() {
            this.assertValid();
            this.isValid = false;
        }

        protected void assertValid() {
            if (!this.isValid) {
                throw new IllegalStateException("Builder has already been used to build");
            }
        }
    }
}

