/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.test.framework;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.test.Asserts;
import org.apache.brooklyn.test.framework.AbortError;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.exceptions.CompoundRuntimeException;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.FatalConfigurationRuntimeException;
import org.apache.brooklyn.util.exceptions.RuntimeInterruptedException;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.repeat.Repeater;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;

public class TestFrameworkAssertions {
    public static final String IS_NULL = "isNull";
    public static final String NOT_NULL = "notNull";
    public static final String IS_EQUAL_TO = "isEqualTo";
    public static final String EQUAL_TO = "equalTo";
    public static final String EQUALS = "equals";
    public static final String NOT_EQUAL = "notEqual";
    public static final String MATCHES = "matches";
    public static final String CONTAINS_MATCH = "containsMatch";
    public static final String CONTAINS = "contains";
    public static final String IS_EMPTY = "isEmpty";
    public static final String NOT_EMPTY = "notEmpty";
    public static final String HAS_TRUTH_VALUE = "hasTruthValue";
    public static final String GREATER_THAN = "greaterThan";
    public static final String LESS_THAN = "lessThan";
    public static final String UNKNOWN_CONDITION = "unknown condition";

    private TestFrameworkAssertions() {
    }

    public static List<Map<String, Object>> getAssertions(Entity entity, ConfigKey<Object> key) {
        return TestFrameworkAssertions.getAsListOfMaps(entity, key);
    }

    public static List<Map<String, Object>> getAbortConditions(Entity entity, ConfigKey<Object> key) {
        return TestFrameworkAssertions.getAsListOfMaps(entity, key);
    }

    protected static List<Map<String, Object>> getAsListOfMaps(Entity entity, ConfigKey<Object> key) {
        Object config = entity.getConfig(key);
        Maybe maybeMap = TypeCoercions.tryCoerce((Object)config, (TypeToken)new TypeToken<Map<String, Object>>(){});
        if (maybeMap.isPresent()) {
            return Collections.singletonList(maybeMap.get());
        }
        Maybe maybeList = TypeCoercions.tryCoerce((Object)config, (TypeToken)new TypeToken<List<Map<String, Object>>>(){});
        if (maybeList.isPresent()) {
            return (List)maybeList.get();
        }
        throw new FatalConfigurationRuntimeException(key.getDescription() + " is not a map or list of maps");
    }

    @Deprecated
    public static <T> void checkAssertions(Map<String, ?> flags, List<? extends Map<String, ?>> assertions, String target, Supplier<T> supplier) {
        TestFrameworkAssertions.checkAssertionsEventually(new AssertionOptions(target, supplier).flags(flags).assertions(assertions));
    }

    @Deprecated
    public static <T> void checkAssertions(AssertionSupport support, Map<String, ?> flags, List<? extends Map<String, ?>> assertions, String target, Supplier<T> supplier) {
        TestFrameworkAssertions.checkAssertionsEventually(support, new AssertionOptions(target, supplier).flags(flags).assertions(assertions));
    }

    @Deprecated
    public static <T> void checkAssertions(AssertionSupport support, Map<String, ?> flags, Map<String, ?> assertions, String target, Supplier<T> supplier) {
        TestFrameworkAssertions.checkAssertionsEventually(support, new AssertionOptions(target, supplier).flags(flags).assertions(assertions));
    }

    @Deprecated
    public static <T> void checkAssertions(Map<String, ?> flags, Map<String, ?> assertions, String target, Supplier<T> supplier) {
        TestFrameworkAssertions.checkAssertionsEventually(new AssertionOptions(target, supplier).flags(flags).assertions(assertions));
    }

    public static <T> void checkAssertionsEventually(AssertionOptions options) {
        AssertionSupport support = new AssertionSupport();
        TestFrameworkAssertions.checkAssertionsEventually(support, options);
        support.validate();
    }

    private static Duration toDuration(Object duration, Duration defaultVal) {
        if (duration == null) {
            return defaultVal;
        }
        return Duration.of((Object)duration);
    }

    protected static <T> void checkAssertionsEventually(AssertionSupport support, final AssertionOptions options) {
        if (options.assertions == null || options.assertions.isEmpty()) {
            return;
        }
        Map<String, Object> flags = options.flags;
        Integer maxAttempts = (Integer)flags.get("maxAttempts");
        Duration timeout = TestFrameworkAssertions.toDuration(flags.get("timeout"), maxAttempts == null ? Asserts.DEFAULT_LONG_TIMEOUT : Duration.PRACTICALLY_FOREVER);
        Duration backoffToPeriod = TestFrameworkAssertions.toDuration(flags.get("backoffToPeriod"), Duration.millis((Number)500));
        Predicate rethrowImmediatelyPredicate = Predicates.or((Iterable)ImmutableList.of((Object)Predicates.instanceOf(AbortError.class), (Object)Predicates.instanceOf(InterruptedException.class), (Object)Predicates.instanceOf(RuntimeInterruptedException.class)));
        try {
            Repeater.create().until((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    try {
                        Object actual = options.supplier.get();
                        for (Map<String, ?> abortMap : options.abortConditions) {
                            TestFrameworkAssertions.checkActualAgainstAbortConditions(abortMap, options.target, actual);
                        }
                        for (Map<String, ?> assertionMap : options.assertions) {
                            TestFrameworkAssertions.checkActualAgainstAssertions(assertionMap, options.target, actual);
                        }
                        return true;
                    }
                    catch (AssertionError e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        throw t;
                    }
                }
            }).limitIterationsTo(maxAttempts != null ? maxAttempts : Integer.MAX_VALUE).limitTimeTo(timeout).backoffTo(backoffToPeriod).rethrowExceptionImmediately(rethrowImmediatelyPredicate).runRequiringTrue();
        }
        catch (AssertionError t) {
            support.fail((Throwable)((Object)t));
        }
        catch (Throwable t) {
            Exceptions.propagateIfFatal((Throwable)t);
            support.fail(t);
        }
    }

    protected static <T> void checkActualAgainstAssertions(AssertionSupport support, Map<String, ?> assertions, String target, T actual) {
        try {
            TestFrameworkAssertions.checkActualAgainstAssertions(assertions, target, actual);
        }
        catch (Throwable t) {
            support.fail(t);
        }
    }

    protected static <T> void checkActualAgainstAssertions(Map<String, ?> assertions, String target, T actual) {
        for (Map.Entry<String, ?> assertion : assertions.entrySet()) {
            String condition = assertion.getKey();
            Object expected = assertion.getValue();
            if (!TestFrameworkAssertions.knownCondition(condition)) {
                TestFrameworkAssertions.failAssertion(target, UNKNOWN_CONDITION, expected, actual);
                continue;
            }
            if (TestFrameworkAssertions.conditionHolds(condition, actual, expected)) continue;
            TestFrameworkAssertions.failAssertion(target, condition, expected, actual);
        }
    }

    protected static <T> void checkActualAgainstAbortConditions(Map<String, ?> assertions, String target, T actual) {
        for (Map.Entry<String, ?> assertion : assertions.entrySet()) {
            String condition = assertion.getKey();
            Object expected = assertion.getValue();
            if (!TestFrameworkAssertions.knownCondition(condition)) {
                TestFrameworkAssertions.abort(target, UNKNOWN_CONDITION, expected, actual);
                continue;
            }
            if (!TestFrameworkAssertions.conditionHolds(condition, actual, expected)) continue;
            TestFrameworkAssertions.abort(target, condition, expected, actual);
        }
    }

    private static boolean conditionHolds(String condition, Object actual, Object expected) {
        switch (condition) {
            case "isEqualTo": 
            case "equalTo": 
            case "equals": {
                return null != actual && actual.equals(expected);
            }
            case "notEqual": {
                return !Objects.equals(actual, expected);
            }
            case "isNull": {
                return TestFrameworkAssertions.isTrue(expected) == (null == actual);
            }
            case "notNull": {
                return TestFrameworkAssertions.isTrue(expected) == (null != actual);
            }
            case "contains": {
                return null != actual && actual.toString().contains(expected.toString());
            }
            case "isEmpty": {
                return TestFrameworkAssertions.isTrue(expected) == (null == actual || Strings.isEmpty((CharSequence)actual.toString()));
            }
            case "notEmpty": {
                return TestFrameworkAssertions.isTrue(expected) == (null != actual && Strings.isNonEmpty((CharSequence)actual.toString()));
            }
            case "matches": {
                Pattern matchesPattern = Pattern.compile(expected.toString());
                return null != actual && matchesPattern.matcher(actual.toString()).matches();
            }
            case "containsMatch": {
                Pattern containsMatchPattern = Pattern.compile(expected.toString());
                return null != actual && containsMatchPattern.matcher(actual.toString()).find();
            }
            case "hasTruthValue": {
                return TestFrameworkAssertions.isTrue(expected) == TestFrameworkAssertions.isTrue(actual);
            }
            case "greaterThan": {
                return TestFrameworkAssertions.canCompare(actual, expected) && TestFrameworkAssertions.compare(actual, expected) > 0;
            }
            case "lessThan": {
                return TestFrameworkAssertions.canCompare(actual, expected) && TestFrameworkAssertions.compare(actual, expected) < 0;
            }
        }
        return false;
    }

    private static boolean knownCondition(String condition) {
        ImmutableSet allConditions = ImmutableSet.of((Object)IS_NULL, (Object)NOT_NULL, (Object)IS_EQUAL_TO, (Object)EQUAL_TO, (Object)EQUALS, (Object)NOT_EQUAL, (Object[])new String[]{MATCHES, CONTAINS_MATCH, CONTAINS, IS_EMPTY, NOT_EMPTY, HAS_TRUTH_VALUE, GREATER_THAN, LESS_THAN});
        return allConditions.contains(condition);
    }

    private static boolean canCompare(@Nullable Object actual, @Nullable Object expected) {
        return actual != null && expected != null && actual instanceof Comparable && actual.getClass().equals(expected.getClass());
    }

    private static int compare(@Nullable Object actual, @Nullable Object expected) {
        if (!TestFrameworkAssertions.canCompare(actual, expected)) {
            throw new IllegalArgumentException("Arguments are not comparable: " + actual + ", " + expected);
        }
        Comparable a = (Comparable)actual;
        Comparable e = (Comparable)expected;
        return a.compareTo(e);
    }

    static void failAssertion(String target, String assertion, Object expected, Object actual) {
        throw new AssertionError((Object)Joiner.on((char)' ').join((Object)Objects.toString(target), (Object)"expected", new Object[]{Objects.toString(assertion), Objects.toString(expected), "but found", Objects.toString(actual)}));
    }

    static void abort(String target, String assertion, Object expected, Object actual) {
        throw new AbortError(Objects.toString(target) + " matched abort criteria '" + Objects.toString(assertion) + " " + Objects.toString(expected) + "', found " + Objects.toString(actual));
    }

    private static boolean isTrue(Object object) {
        return null != object && Boolean.valueOf(object.toString()) != false;
    }

    public static class AssertionSupport {
        private List<AssertionError> failures = new ArrayList<AssertionError>();

        public void fail(String target, String assertion, Object expected) {
            this.failures.add(new AssertionError((Object)Joiner.on((char)' ').join((Object)(null != target ? target : "null"), (Object)(null != assertion ? assertion : "null"), new Object[]{null != expected ? expected : "null"})));
        }

        public void fail(Throwable throwable) {
            this.failures.add(new AssertionError(throwable.getMessage(), throwable));
        }

        public void validate() {
            if (0 < this.failures.size()) {
                if (1 == this.failures.size()) {
                    throw this.failures.get(0);
                }
                StringBuilder builder = new StringBuilder();
                for (AssertionError assertionError : this.failures) {
                    builder.append(((Throwable)((Object)assertionError)).getMessage()).append("\n");
                }
                throw new AssertionError("Assertions failed:\n" + builder, (Throwable)new CompoundRuntimeException("Assertions", this.failures));
            }
        }
    }

    public static class AssertionOptions {
        protected Map<String, Object> flags = MutableMap.of();
        protected List<? extends Map<String, ?>> assertions = ImmutableList.of();
        protected List<? extends Map<String, ?>> abortConditions = ImmutableList.of();
        protected String target;
        protected Supplier<?> supplier;

        public AssertionOptions(String target, Supplier<?> supplier) {
            this.target = target;
            this.supplier = supplier;
        }

        public AssertionOptions flags(Map<String, ?> val) {
            this.flags.putAll(val);
            return this;
        }

        public AssertionOptions timeout(Duration val) {
            this.flags.put("timeout", val);
            return this;
        }

        public AssertionOptions maxAttempts(Integer val) {
            this.flags.put("maxAttempts", val);
            return this;
        }

        public AssertionOptions backoffToPeriod(Duration val) {
            this.flags.put("backoffToPeriod", val);
            return this;
        }

        public AssertionOptions assertions(Map<String, ?> val) {
            this.assertions = ImmutableList.of(val);
            return this;
        }

        public AssertionOptions assertions(List<? extends Map<String, ?>> val) {
            this.assertions = val;
            return this;
        }

        public AssertionOptions abortConditions(Map<String, ?> val) {
            this.abortConditions = ImmutableList.of(val);
            return this;
        }

        public AssertionOptions abortConditions(List<? extends Map<String, ?>> val) {
            this.abortConditions = val;
            return this;
        }

        public AssertionOptions target(String val) {
            this.target = val;
            return this;
        }

        public AssertionOptions supplier(Supplier<?> val) {
            this.supplier = val;
            return this;
        }
    }
}

