/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.mongodb;

import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.entity.nosql.mongodb.MongoDBAuthenticationMixins;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDBAuthenticationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDBAuthenticationUtils.class);

    private MongoDBAuthenticationUtils() {
    }

    public static boolean usesAuthentication(Entity entity) {
        String keyfileContents = (String)entity.config().get(MongoDBAuthenticationMixins.MONGODB_KEYFILE_CONTENTS);
        String keyfileUrl = (String)entity.config().get(MongoDBAuthenticationMixins.MONGODB_KEYFILE_URL);
        return Strings.isNonBlank((CharSequence)keyfileContents) || Strings.isNonBlank((CharSequence)keyfileUrl);
    }

    public static String getRootPassword(Entity entity) {
        String password = (String)entity.config().get(MongoDBAuthenticationMixins.ROOT_PASSWORD);
        if (Strings.isEmpty((CharSequence)password)) {
            LOG.debug(entity + " has no password specified for " + MongoDBAuthenticationMixins.ROOT_PASSWORD.getName() + "; using a random string");
            password = Identifiers.makeRandomPassword((int)16);
            entity.sensors().set(MongoDBAuthenticationMixins.ROOT_PASSWORD, (Object)password);
            entity.config().set(MongoDBAuthenticationMixins.ROOT_PASSWORD, (Object)password);
        }
        return password;
    }

    public static void setAuthenticationConfig(EntitySpec<?> spec, Entity source) {
        if (MongoDBAuthenticationUtils.usesAuthentication(source)) {
            spec.configure(MongoDBAuthenticationMixins.MONGODB_KEYFILE_CONTENTS, source.config().get(MongoDBAuthenticationMixins.MONGODB_KEYFILE_CONTENTS));
            spec.configure(MongoDBAuthenticationMixins.MONGODB_KEYFILE_URL, source.config().get(MongoDBAuthenticationMixins.MONGODB_KEYFILE_URL));
            spec.configure(MongoDBAuthenticationMixins.ROOT_USERNAME, source.config().get(MongoDBAuthenticationMixins.ROOT_USERNAME));
            spec.configure(MongoDBAuthenticationMixins.ROOT_PASSWORD, (Object)MongoDBAuthenticationUtils.getRootPassword(source));
        }
    }

    public static void setAuthenticationConfig(Entity entity, Entity source) {
        if (MongoDBAuthenticationUtils.usesAuthentication(source)) {
            entity.config().set(MongoDBAuthenticationMixins.MONGODB_KEYFILE_CONTENTS, source.config().get(MongoDBAuthenticationMixins.MONGODB_KEYFILE_CONTENTS));
            entity.config().set(MongoDBAuthenticationMixins.MONGODB_KEYFILE_URL, source.config().get(MongoDBAuthenticationMixins.MONGODB_KEYFILE_URL));
            entity.config().set(MongoDBAuthenticationMixins.ROOT_USERNAME, source.config().get(MongoDBAuthenticationMixins.ROOT_USERNAME));
            entity.config().set(MongoDBAuthenticationMixins.ROOT_PASSWORD, (Object)MongoDBAuthenticationUtils.getRootPassword(source));
        }
    }
}

