/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.main;

import java.io.File;
import java.net.URI;
import org.apache.karaf.info.ServerInfo;
import org.apache.karaf.main.ConfigProperties;

public class ServerInfoImpl
implements ServerInfo {
    private final String[] args;
    private final ConfigProperties config;

    public ServerInfoImpl(String[] args, ConfigProperties config) {
        this.args = args;
        this.config = config;
    }

    @Override
    public File getHomeDirectory() {
        return this.config.karafHome;
    }

    @Override
    public String resolveHomePath(String filename) {
        return this.resolveWithBase(this.config.karafHome, filename).getAbsolutePath();
    }

    @Override
    public File resolveHome(String filename) {
        return this.resolveWithBase(this.config.karafHome, filename);
    }

    @Override
    public URI resolveHome(URI uri) {
        return this.config.karafHome.toURI().resolve(uri);
    }

    @Override
    public File getBaseDirectory() {
        return this.config.karafBase;
    }

    @Override
    public String resolveBasePath(String filename) {
        return this.resolveWithBase(this.config.karafBase, filename).getAbsolutePath();
    }

    @Override
    public File resolveBase(String filename) {
        return this.resolveWithBase(this.config.karafBase, filename);
    }

    @Override
    public URI resolveBase(URI uri) {
        return this.config.karafBase.toURI().resolve(uri);
    }

    @Override
    public File getDataDirectory() {
        return this.config.karafData;
    }

    @Override
    public File getInstancesDirectory() {
        return this.config.karafInstances;
    }

    @Override
    public String[] getArgs() {
        return (String[])this.args.clone();
    }

    private File resolveWithBase(File baseDir, String filename) {
        File file = new File(filename);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(baseDir, filename);
    }
}

