/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.resources;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementClass;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementManager;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.core.mgmt.usage.ApplicationUsage;
import org.apache.brooklyn.core.mgmt.usage.LocationUsage;
import org.apache.brooklyn.rest.api.UsageApi;
import org.apache.brooklyn.rest.domain.UsageStatistic;
import org.apache.brooklyn.rest.domain.UsageStatistics;
import org.apache.brooklyn.rest.resources.AbstractBrooklynRestResource;
import org.apache.brooklyn.rest.transform.ApplicationTransformer;
import org.apache.brooklyn.rest.util.WebResourceUtils;
import org.apache.brooklyn.util.exceptions.UserFacingException;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsageResource
extends AbstractBrooklynRestResource
implements UsageApi {
    private static final Logger log = LoggerFactory.getLogger(UsageResource.class);
    private static final Set<Lifecycle> WORKING_LIFECYCLES = ImmutableSet.of((Object)Lifecycle.RUNNING, (Object)Lifecycle.CREATED, (Object)Lifecycle.STARTING);

    public List<UsageStatistics> listApplicationsUsage(@Nullable String start, @Nullable String end) {
        log.debug("REST call to get application usage for all applications: dates {} -> {}", new Object[]{start, end});
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.USAGE, null)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to perform this operation", Entitlements.getEntitlementContext().user());
        }
        ArrayList response = Lists.newArrayList();
        Date startDate = this.parseDate(start, new Date(0L));
        Date endDate = this.parseDate(end, new Date());
        this.checkDates(startDate, endDate);
        Set usages = this.mgmtInternal().getUsageManager().getApplicationUsage(Predicates.alwaysTrue());
        for (ApplicationUsage usage : usages) {
            List<UsageStatistic> statistics = this.retrieveApplicationUsage(usage, startDate, endDate);
            if (statistics.size() <= 0) continue;
            response.add(new UsageStatistics(statistics, (Map)ImmutableMap.of()));
        }
        return response;
    }

    public UsageStatistics getApplicationUsage(String application, String start, String end) {
        log.debug("REST call to get application usage for application {}: dates {} -> {}", new Object[]{application, start, end});
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.USAGE, null)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to perform this operation", Entitlements.getEntitlementContext().user());
        }
        Date startDate = this.parseDate(start, new Date(0L));
        Date endDate = this.parseDate(end, new Date());
        this.checkDates(startDate, endDate);
        ApplicationUsage usage = this.mgmtInternal().getUsageManager().getApplicationUsage(application);
        if (usage != null) {
            List<UsageStatistic> statistics = this.retrieveApplicationUsage(usage, startDate, endDate);
            return new UsageStatistics(statistics, (Map)ImmutableMap.of());
        }
        throw WebResourceUtils.notFound("Application '%s' not found", application);
    }

    private List<UsageStatistic> retrieveApplicationUsage(ApplicationUsage usage, Date startDate, Date endDate) {
        log.debug("Determining application usage for application {}: dates {} -> {}", new Object[]{usage.getApplicationId(), startDate, endDate});
        log.trace("Considering application usage events of {}: {}", (Object)usage.getApplicationId(), (Object)usage.getEvents());
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.USAGE, null)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to perform this operation", Entitlements.getEntitlementContext().user());
        }
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < usage.getEvents().size(); ++i) {
            Date eventEndDate;
            ApplicationUsage.ApplicationEvent current = (ApplicationUsage.ApplicationEvent)usage.getEvents().get(i);
            Date eventStartDate = current.getDate();
            if (i < usage.getEvents().size() - 1) {
                ApplicationUsage.ApplicationEvent next = (ApplicationUsage.ApplicationEvent)usage.getEvents().get(i + 1);
                eventEndDate = next.getDate();
            } else {
                eventEndDate = current.getState() == Lifecycle.DESTROYED ? eventStartDate : new Date();
            }
            if (eventStartDate.compareTo(endDate) > 0 || eventEndDate.compareTo(startDate) < 0) continue;
            if (eventStartDate.compareTo(startDate) < 0) {
                eventStartDate = startDate;
            }
            if (eventEndDate.compareTo(endDate) > 0) {
                eventEndDate = endDate;
            }
            long duration = eventEndDate.getTime() - eventStartDate.getTime();
            UsageStatistic statistic = new UsageStatistic(ApplicationTransformer.statusFromLifecycle(current.getState()), usage.getApplicationId(), usage.getApplicationId(), this.format(eventStartDate), this.format(eventEndDate), duration, usage.getMetadata());
            log.trace("Adding application usage statistic to response for app {}: {}", (Object)usage.getApplicationId(), (Object)statistic);
            result.add(statistic);
        }
        return result;
    }

    public List<UsageStatistics> listMachinesUsage(final String application, String start, String end) {
        log.debug("REST call to get machine usage for application {}: dates {} -> {}", new Object[]{application, start, end});
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.USAGE, null)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to perform this operation", Entitlements.getEntitlementContext().user());
        }
        final Date startDate = this.parseDate(start, new Date(0L));
        final Date endDate = this.parseDate(end, new Date());
        this.checkDates(startDate, endDate);
        Set matches = this.mgmtInternal().getUsageManager().getLocationUsage((Predicate)new Predicate<LocationUsage>(){

            public boolean apply(LocationUsage input) {
                LocationUsage.LocationEvent first = (LocationUsage.LocationEvent)input.getEvents().get(0);
                if (endDate.compareTo(first.getDate()) < 0) {
                    return false;
                }
                LocationUsage.LocationEvent last = (LocationUsage.LocationEvent)input.getEvents().get(input.getEvents().size() - 1);
                if (!WORKING_LIFECYCLES.contains(last.getState()) && startDate.compareTo(last.getDate()) > 0) {
                    return false;
                }
                if (application != null) {
                    for (LocationUsage.LocationEvent e : input.getEvents()) {
                        if (!Objects.equal((Object)application, (Object)e.getApplicationId())) continue;
                        return true;
                    }
                    return false;
                }
                return true;
            }
        });
        ArrayList response = Lists.newArrayList();
        for (LocationUsage usage : matches) {
            List<UsageStatistic> statistics = this.retrieveMachineUsage(usage, startDate, endDate);
            if (statistics.size() <= 0) continue;
            response.add(new UsageStatistics(statistics, (Map)ImmutableMap.of()));
        }
        return response;
    }

    public UsageStatistics getMachineUsage(String machine, String start, String end) {
        log.debug("REST call to get machine usage for machine {}: dates {} -> {}", new Object[]{machine, start, end});
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.USAGE, null)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to perform this operation", Entitlements.getEntitlementContext().user());
        }
        Date startDate = this.parseDate(start, new Date(0L));
        Date endDate = this.parseDate(end, new Date());
        this.checkDates(startDate, endDate);
        LocationUsage usage = this.mgmtInternal().getUsageManager().getLocationUsage(machine);
        if (usage == null) {
            throw WebResourceUtils.notFound("Machine '%s' not found", machine);
        }
        List<UsageStatistic> statistics = this.retrieveMachineUsage(usage, startDate, endDate);
        return new UsageStatistics(statistics, (Map)ImmutableMap.of());
    }

    private List<UsageStatistic> retrieveMachineUsage(LocationUsage usage, Date startDate, Date endDate) {
        log.debug("Determining machine usage for location {}", (Object)usage.getLocationId());
        log.trace("Considering machine usage events of {}: {}", (Object)usage.getLocationId(), (Object)usage.getEvents());
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.USAGE, null)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to perform this operation", Entitlements.getEntitlementContext().user());
        }
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < usage.getEvents().size(); ++i) {
            Date eventEndDate;
            LocationUsage.LocationEvent current = (LocationUsage.LocationEvent)usage.getEvents().get(i);
            Date eventStartDate = current.getDate();
            if (i < usage.getEvents().size() - 1) {
                LocationUsage.LocationEvent next = (LocationUsage.LocationEvent)usage.getEvents().get(i + 1);
                eventEndDate = next.getDate();
            } else {
                eventEndDate = current.getState() == Lifecycle.DESTROYED || current.getState() == Lifecycle.STOPPED ? eventStartDate : new Date();
            }
            if (eventStartDate.compareTo(endDate) > 0 || eventEndDate.compareTo(startDate) < 0) continue;
            if (eventStartDate.compareTo(startDate) < 0) {
                eventStartDate = startDate;
            }
            if (eventEndDate.compareTo(endDate) > 0) {
                eventEndDate = endDate;
            }
            long duration = eventEndDate.getTime() - eventStartDate.getTime();
            UsageStatistic statistic = new UsageStatistic(ApplicationTransformer.statusFromLifecycle(current.getState()), usage.getLocationId(), current.getApplicationId(), this.format(eventStartDate), this.format(eventEndDate), duration, usage.getMetadata());
            log.trace("Adding machine usage statistic to response for app {}: {}", (Object)usage.getLocationId(), (Object)statistic);
            result.add(statistic);
        }
        return result;
    }

    private void checkDates(Date startDate, Date endDate) {
        if (startDate.compareTo(endDate) > 0) {
            throw new UserFacingException((Throwable)new IllegalArgumentException("Start must be less than or equal to end: " + startDate + " > " + endDate + " (" + startDate.getTime() + " > " + endDate.getTime() + ")"));
        }
    }

    private Date parseDate(String toParse, Date def) {
        return Strings.isBlank((CharSequence)toParse) ? def : Time.parseDate((String)toParse);
    }

    private String format(Date date) {
        return Time.makeDateString((Date)date, (String)"yyyy-MM-dd'T'HH:mm:ssZ", (TimeZone)Time.TIME_ZONE_UTC);
    }
}

