/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.resources;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import io.swagger.annotations.ApiParam;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.brooklyn.api.catalog.CatalogItem;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementClass;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementManager;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.core.catalog.internal.CatalogUtils;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.core.mgmt.ha.OsgiBundleInstallationResult;
import org.apache.brooklyn.core.mgmt.ha.OsgiManager;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.typereg.RegisteredTypePredicates;
import org.apache.brooklyn.core.typereg.RegisteredTypes;
import org.apache.brooklyn.rest.api.CatalogApi;
import org.apache.brooklyn.rest.domain.ApiError;
import org.apache.brooklyn.rest.domain.BundleInstallationRestResult;
import org.apache.brooklyn.rest.domain.CatalogEnricherSummary;
import org.apache.brooklyn.rest.domain.CatalogEntitySummary;
import org.apache.brooklyn.rest.domain.CatalogItemSummary;
import org.apache.brooklyn.rest.domain.CatalogLocationSummary;
import org.apache.brooklyn.rest.domain.CatalogPolicySummary;
import org.apache.brooklyn.rest.filter.HaHotStateRequired;
import org.apache.brooklyn.rest.resources.AbstractBrooklynRestResource;
import org.apache.brooklyn.rest.transform.CatalogTransformer;
import org.apache.brooklyn.rest.transform.TypeTransformer;
import org.apache.brooklyn.rest.util.WebResourceUtils;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.ReferenceWithError;
import org.apache.brooklyn.util.text.StringPredicates;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.yaml.Yamls;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HaHotStateRequired
public class CatalogResource
extends AbstractBrooklynRestResource
implements CatalogApi {
    private static final Logger log = LoggerFactory.getLogger(CatalogResource.class);
    private static final String LATEST = "latest";
    static Set<String> missingIcons = MutableSet.of();

    @Deprecated
    private Function<RegisteredType, CatalogItemSummary> toCatalogItemSummary(final UriInfo ui) {
        return new Function<RegisteredType, CatalogItemSummary>(){

            public CatalogItemSummary apply(@Nullable RegisteredType input) {
                return CatalogTransformer.catalogItemSummary(CatalogResource.this.brooklyn(), input, ui.getBaseUriBuilder());
            }
        };
    }

    private String processVersion(String version) {
        if (version != null && LATEST.equals(version.toLowerCase())) {
            version = null;
        }
        return version;
    }

    @Beta
    public Response createFromUpload(byte[] item, boolean forceUpdate) {
        Exception yamlException = null;
        try {
            MutableList.copyOf((Iterable)Yamls.parseAll((Reader)new InputStreamReader(new ByteArrayInputStream(item))));
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            yamlException = e;
        }
        if (yamlException == null) {
            return this.createFromYaml(new String(item), forceUpdate);
        }
        return this.createFromArchive(item, false, forceUpdate);
    }

    @Deprecated
    public Response create(String yaml, boolean forceUpdate) {
        return this.createFromYaml(yaml, forceUpdate);
    }

    public Response createFromYaml(String yaml, boolean forceUpdate) {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.ADD_CATALOG_ITEM, (Object)yaml)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to add catalog item", Entitlements.getEntitlementContext().user());
        }
        try {
            Iterable items = this.brooklyn().getCatalog().addItems(yaml, true, forceUpdate);
            MutableList itemsRT = MutableList.of();
            for (CatalogItem ci : items) {
                RegisteredType rt = this.brooklyn().getTypeRegistry().get(ci.getId());
                itemsRT.add(rt != null ? rt : RegisteredTypes.of((CatalogItem)ci));
            }
            return this.buildCreateResponse((Iterable<RegisteredType>)itemsRT);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            return this.badRequest(e);
        }
    }

    @Beta
    public Response createFromArchive(byte[] zipInput, boolean detail, boolean forceUpdate) {
        Response.Status status;
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.ROOT, null)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to add catalog item", Entitlements.getEntitlementContext().user());
        }
        ReferenceWithError result = ((OsgiManager)((ManagementContextInternal)this.mgmt()).getOsgiManager().get()).install(null, (InputStream)new ByteArrayInputStream(zipInput), true, true, forceUpdate);
        if (result.hasError()) {
            if (log.isTraceEnabled()) {
                log.trace("Unable to create from archive, returning 400: " + result.getError().getMessage(), result.getError());
            }
            return ApiError.builder().errorCode(Response.Status.BAD_REQUEST).message(((OsgiBundleInstallationResult)result.getWithoutError()).getMessage()).data((Object)TypeTransformer.bundleInstallationResult((OsgiBundleInstallationResult)result.getWithoutError(), this.mgmt(), this.brooklyn(), this.ui)).build().asJsonResponse();
        }
        BundleInstallationRestResult resultR = TypeTransformer.bundleInstallationResult((OsgiBundleInstallationResult)result.get(), this.mgmt(), this.brooklyn(), this.ui);
        switch (((OsgiBundleInstallationResult)result.get()).getCode()) {
            case IGNORING_BUNDLE_AREADY_INSTALLED: 
            case IGNORING_BUNDLE_FORCIBLY_REMOVED: {
                status = Response.Status.OK;
                break;
            }
            default: {
                status = Response.Status.CREATED;
            }
        }
        return Response.status((Response.Status)status).entity(detail ? resultR : resultR.getTypes()).build();
    }

    private Response buildCreateResponse(Iterable<RegisteredType> catalogItems) {
        log.info("REST created catalog items: " + catalogItems);
        MutableMap result = MutableMap.of();
        for (RegisteredType catalogItem : catalogItems) {
            try {
                result.put(catalogItem.getId(), CatalogTransformer.catalogItemSummary(this.brooklyn(), catalogItem, this.ui.getBaseUriBuilder()));
            }
            catch (Throwable t) {
                log.warn("Error loading catalog item '" + catalogItem + "' (rethrowing): " + t);
                throw Exceptions.propagateAnnotated((String)("At least one unusable item was added (" + catalogItem.getId() + ")"), (Throwable)t);
            }
        }
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)result).build();
    }

    @Deprecated
    public void deleteApplication(String symbolicName, String version) throws Exception {
        this.deleteEntity(symbolicName, version);
    }

    @Deprecated
    public void deleteEntity(String symbolicName, String version) throws Exception {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.MODIFY_CATALOG_ITEM, (Object)Entitlements.StringAndArgument.of((String)(symbolicName + (Strings.isBlank((CharSequence)version) ? "" : ":" + version)), (Object)"delete"))) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to modify catalog", Entitlements.getEntitlementContext().user());
        }
        version = this.processVersion(version);
        RegisteredType item = this.mgmt().getTypeRegistry().get(symbolicName, version);
        if (item == null) {
            throw WebResourceUtils.notFound("Entity with id '%s:%s' not found", symbolicName, version);
        }
        if (!RegisteredTypePredicates.IS_ENTITY.apply((Object)item) && !RegisteredTypePredicates.IS_APPLICATION.apply((Object)item)) {
            throw WebResourceUtils.preconditionFailed("Item with id '%s:%s' not an entity", symbolicName, version);
        }
        this.brooklyn().getCatalog().deleteCatalogItem(item.getSymbolicName(), item.getVersion());
    }

    @Deprecated
    public void deletePolicy(String policyId, String version) throws Exception {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.MODIFY_CATALOG_ITEM, (Object)Entitlements.StringAndArgument.of((String)(policyId + (Strings.isBlank((CharSequence)version) ? "" : ":" + version)), (Object)"delete"))) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to modify catalog", Entitlements.getEntitlementContext().user());
        }
        version = this.processVersion(version);
        RegisteredType item = this.mgmt().getTypeRegistry().get(policyId, version);
        if (item == null) {
            throw WebResourceUtils.notFound("Policy with id '%s:%s' not found", policyId, version);
        }
        if (!RegisteredTypePredicates.IS_POLICY.apply((Object)item)) {
            throw WebResourceUtils.preconditionFailed("Item with id '%s:%s' not a policy", policyId, version);
        }
        this.brooklyn().getCatalog().deleteCatalogItem(item.getSymbolicName(), item.getVersion());
    }

    @Deprecated
    public void deleteLocation(String locationId, String version) throws Exception {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.MODIFY_CATALOG_ITEM, (Object)Entitlements.StringAndArgument.of((String)(locationId + (Strings.isBlank((CharSequence)version) ? "" : ":" + version)), (Object)"delete"))) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to modify catalog", Entitlements.getEntitlementContext().user());
        }
        version = this.processVersion(version);
        RegisteredType item = this.mgmt().getTypeRegistry().get(locationId, version);
        if (item == null) {
            throw WebResourceUtils.notFound("Location with id '%s:%s' not found", locationId, version);
        }
        if (!RegisteredTypePredicates.IS_LOCATION.apply((Object)item)) {
            throw WebResourceUtils.preconditionFailed("Item with id '%s:%s' not a location", locationId, version);
        }
        this.brooklyn().getCatalog().deleteCatalogItem(item.getSymbolicName(), item.getVersion());
    }

    @Deprecated
    public List<CatalogEntitySummary> listEntities(String regex, String fragment, boolean allVersions) {
        Predicate filter = Predicates.and((Predicate)RegisteredTypePredicates.IS_ENTITY, (Predicate)RegisteredTypePredicates.disabled((boolean)false));
        List<CatalogItemSummary> result = this.getCatalogItemSummariesMatchingRegexFragment((Predicate<RegisteredType>)filter, regex, fragment, allVersions);
        return CatalogResource.castList(result, CatalogEntitySummary.class);
    }

    @Deprecated
    public List<CatalogItemSummary> listApplications(String regex, String fragment, boolean allVersions) {
        Predicate filter = Predicates.and((Predicate[])new Predicate[]{RegisteredTypePredicates.template((boolean)true), RegisteredTypePredicates.deprecated((boolean)false), RegisteredTypePredicates.disabled((boolean)false)});
        return this.getCatalogItemSummariesMatchingRegexFragment((Predicate<RegisteredType>)filter, regex, fragment, allVersions);
    }

    @Deprecated
    public CatalogEntitySummary getEntity(String symbolicName, String version) {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_CATALOG_ITEM, (Object)(symbolicName + (Strings.isBlank((CharSequence)version) ? "" : ":" + version)))) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to see catalog entry", Entitlements.getEntitlementContext().user());
        }
        version = this.processVersion(version);
        RegisteredType result = this.brooklyn().getTypeRegistry().get(symbolicName, version);
        if (result == null) {
            throw WebResourceUtils.notFound("Entity with id '%s:%s' not found", symbolicName, version);
        }
        return CatalogTransformer.catalogEntitySummary(this.brooklyn(), result, this.ui.getBaseUriBuilder());
    }

    @Deprecated
    public CatalogEntitySummary getApplication(String symbolicName, String version) {
        return this.getEntity(symbolicName, version);
    }

    @Deprecated
    public List<CatalogPolicySummary> listPolicies(String regex, String fragment, boolean allVersions) {
        Predicate filter = Predicates.and((Predicate)RegisteredTypePredicates.IS_POLICY, (Predicate)RegisteredTypePredicates.disabled((boolean)false));
        List<CatalogItemSummary> result = this.getCatalogItemSummariesMatchingRegexFragment((Predicate<RegisteredType>)filter, regex, fragment, allVersions);
        return CatalogResource.castList(result, CatalogPolicySummary.class);
    }

    @Deprecated
    public CatalogPolicySummary getPolicy(String policyId, String version) throws Exception {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_CATALOG_ITEM, (Object)(policyId + (Strings.isBlank((CharSequence)version) ? "" : ":" + version)))) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to see catalog entry", Entitlements.getEntitlementContext().user());
        }
        version = this.processVersion(version);
        RegisteredType result = this.brooklyn().getTypeRegistry().get(policyId, version);
        if (result == null) {
            throw WebResourceUtils.notFound("Policy with id '%s:%s' not found", policyId, version);
        }
        return CatalogTransformer.catalogPolicySummary(this.brooklyn(), result, this.ui.getBaseUriBuilder());
    }

    @Deprecated
    public List<CatalogLocationSummary> listLocations(String regex, String fragment, boolean allVersions) {
        Predicate filter = Predicates.and((Predicate)RegisteredTypePredicates.IS_LOCATION, (Predicate)RegisteredTypePredicates.disabled((boolean)false));
        List<CatalogItemSummary> result = this.getCatalogItemSummariesMatchingRegexFragment((Predicate<RegisteredType>)filter, regex, fragment, allVersions);
        return CatalogResource.castList(result, CatalogLocationSummary.class);
    }

    @Deprecated
    public CatalogLocationSummary getLocation(String locationId, String version) throws Exception {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_CATALOG_ITEM, (Object)(locationId + (Strings.isBlank((CharSequence)version) ? "" : ":" + version)))) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to see catalog entry", Entitlements.getEntitlementContext().user());
        }
        version = this.processVersion(version);
        RegisteredType result = this.brooklyn().getTypeRegistry().get(locationId, version);
        if (result == null) {
            throw WebResourceUtils.notFound("Location with id '%s:%s' not found", locationId, version);
        }
        return CatalogTransformer.catalogLocationSummary(this.brooklyn(), result, this.ui.getBaseUriBuilder());
    }

    @Deprecated
    private <T, SpecT> List<CatalogItemSummary> getCatalogItemSummariesMatchingRegexFragment(Predicate<RegisteredType> type, String regex, String fragment, boolean allVersions) {
        ArrayList<Object> filters = new ArrayList<Object>();
        filters.add(type);
        if (Strings.isNonEmpty((CharSequence)regex)) {
            filters.add(RegisteredTypePredicates.stringRepresentationMatches((Predicate)StringPredicates.containsRegex((String)regex)));
        }
        if (Strings.isNonEmpty((CharSequence)fragment)) {
            filters.add(RegisteredTypePredicates.stringRepresentationMatches((Predicate)StringPredicates.containsLiteralIgnoreCase((String)fragment)));
        }
        if (!allVersions) {
            filters.add(RegisteredTypePredicates.isBestVersion((ManagementContext)this.mgmt()));
        }
        filters.add(RegisteredTypePredicates.entitledToSee((ManagementContext)this.mgmt()));
        ImmutableList sortedItems = FluentIterable.from((Iterable)this.brooklyn().getTypeRegistry().getMatching(Predicates.and(filters))).toSortedList(RegisteredTypes.RegisteredTypeNameThenBestFirstComparator.INSTANCE);
        return Lists.transform((List)sortedItems, this.toCatalogItemSummary(this.ui));
    }

    public Response getIcon(String itemId, String version) {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_CATALOG_ITEM, (Object)(itemId + (Strings.isBlank((CharSequence)version) ? "" : ":" + version)))) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to see catalog entry", Entitlements.getEntitlementContext().user());
        }
        version = this.processVersion(version);
        return this.getCatalogItemIcon(this.mgmt().getTypeRegistry().get(itemId, version));
    }

    @Deprecated
    public void setDeprecated(String itemId, boolean deprecated) {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.MODIFY_CATALOG_ITEM, (Object)Entitlements.StringAndArgument.of((String)itemId, (Object)"deprecated"))) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to modify catalog", Entitlements.getEntitlementContext().user());
        }
        CatalogUtils.setDeprecated((ManagementContext)this.mgmt(), (String)itemId, (boolean)deprecated);
    }

    @Deprecated
    public void setDisabled(String itemId, boolean disabled) {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.MODIFY_CATALOG_ITEM, (Object)Entitlements.StringAndArgument.of((String)itemId, (Object)"disabled"))) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to modify catalog", Entitlements.getEntitlementContext().user());
        }
        CatalogUtils.setDisabled((ManagementContext)this.mgmt(), (String)itemId, (boolean)disabled);
    }

    @Deprecated
    public List<CatalogEnricherSummary> listEnrichers(@ApiParam(name="regex", value="Regular expression to search for") @DefaultValue(value="") String regex, @ApiParam(name="fragment", value="Substring case-insensitive to search for") @DefaultValue(value="") String fragment, @ApiParam(name="allVersions", value="Include all versions (defaults false, only returning the best version)") @DefaultValue(value="false") boolean includeAllVersions) {
        Predicate filter = Predicates.and((Predicate)RegisteredTypePredicates.IS_ENRICHER, (Predicate)RegisteredTypePredicates.disabled((boolean)false));
        List<CatalogItemSummary> result = this.getCatalogItemSummariesMatchingRegexFragment((Predicate<RegisteredType>)filter, regex, fragment, includeAllVersions);
        return CatalogResource.castList(result, CatalogEnricherSummary.class);
    }

    @Deprecated
    public CatalogEnricherSummary getEnricher(@ApiParam(name="enricherId", value="The ID of the enricher to retrieve", required=true) String enricherId, @ApiParam(name="version", value="The version identifier of the enricher to retrieve", required=true) String version) throws Exception {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_CATALOG_ITEM, (Object)(enricherId + (Strings.isBlank((CharSequence)version) ? "" : ":" + version)))) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to see catalog entry", Entitlements.getEntitlementContext().user());
        }
        version = this.processVersion(version);
        RegisteredType result = this.brooklyn().getTypeRegistry().get(enricherId, version);
        if (result == null) {
            throw WebResourceUtils.notFound("Enricher with id '%s:%s' not found", enricherId, version);
        }
        return CatalogTransformer.catalogEnricherSummary(this.brooklyn(), result, this.ui.getBaseUriBuilder());
    }

    @Deprecated
    public void deleteEnricher(@ApiParam(name="enricherId", value="The ID of the enricher to delete", required=true) String enricherId, @ApiParam(name="version", value="The version identifier of the enricher to delete", required=true) String version) throws Exception {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.MODIFY_CATALOG_ITEM, (Object)Entitlements.StringAndArgument.of((String)(enricherId + (Strings.isBlank((CharSequence)version) ? "" : ":" + version)), (Object)"delete"))) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to modify catalog", Entitlements.getEntitlementContext().user());
        }
        RegisteredType item = this.mgmt().getTypeRegistry().get(enricherId, version);
        if (item == null) {
            throw WebResourceUtils.notFound("Enricher with id '%s:%s' not found", enricherId, version);
        }
        if (!RegisteredTypePredicates.IS_ENRICHER.apply((Object)item)) {
            throw WebResourceUtils.preconditionFailed("Item with id '%s:%s' not an enricher", enricherId, version);
        }
        this.brooklyn().getCatalog().deleteCatalogItem(item.getSymbolicName(), item.getVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response getCatalogItemIcon(RegisteredType result) {
        String url = result.getIconUrl();
        if (url == null) {
            log.debug("No icon available for " + result + "; returning " + Response.Status.NO_CONTENT);
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        if (this.brooklyn().isUrlServerSideAndSafe(url)) {
            log.debug("Loading and returning " + url + " as icon for " + result);
            MediaType mime = WebResourceUtils.getImageMediaTypeFromExtension(Files.getFileExtension((String)url));
            try {
                InputStream content = ResourceUtils.create((Object)CatalogUtils.newClassLoadingContext((ManagementContext)this.mgmt(), (RegisteredType)result)).getResourceFromUrl(url);
                return Response.ok((Object)content, (MediaType)mime).build();
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                Set<String> set = missingIcons;
                synchronized (set) {
                    if (missingIcons.add(url)) {
                        log.warn("Missing icon data for " + result.getId() + ", expected at: " + url + " (subsequent messages will log debug only)");
                        log.debug("Trace for missing icon data at " + url + ": " + e, (Throwable)e);
                    } else {
                        log.debug("Missing icon data for " + result.getId() + ", expected at: " + url + " (already logged WARN and error details)");
                    }
                }
                throw WebResourceUtils.notFound("Icon unavailable for %s", result.getId());
            }
        }
        log.debug("Returning redirect to " + url + " as icon for " + result);
        return Response.temporaryRedirect((URI)URI.create(url)).build();
    }

    private static <T> List<T> castList(List<? super T> list, Class<T> elementType) {
        ArrayList result = Lists.newArrayList();
        Iterator<T> li = list.iterator();
        while (li.hasNext()) {
            try {
                result.add(li.next());
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof NoClassDefFoundError)) {
                    Exceptions.propagateIfFatal((Throwable)throwable);
                }
                log.debug("Ignoring invalid catalog item: " + throwable);
            }
        }
        return result;
    }
}

