/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.exceptions;

import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropagatedRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 3959054308510077172L;
    private static final Logger LOG = LoggerFactory.getLogger(PropagatedRuntimeException.class);
    private final boolean causeEmbeddedInMessage;

    public PropagatedRuntimeException(String message, Throwable cause) {
        super(message, cause);
        this.warnIfWrapping(cause);
        this.causeEmbeddedInMessage = this.checkCauseEmbedded();
    }

    private boolean checkCauseEmbedded() {
        String causalText = Exceptions.collapseText(this.getCause());
        if (Strings.isBlank(causalText)) {
            return false;
        }
        return this.getMessage().endsWith(causalText);
    }

    public PropagatedRuntimeException(String messagePart1, String messagePart2PossiblyIncludingPart1, Throwable cause) {
        super(messagePart2PossiblyIncludingPart1 != null && messagePart2PossiblyIncludingPart1.startsWith(messagePart1) ? messagePart2PossiblyIncludingPart1 : messagePart1 + messagePart2PossiblyIncludingPart1, cause);
        this.warnIfWrapping(cause);
        this.causeEmbeddedInMessage = this.checkCauseEmbedded();
    }

    public PropagatedRuntimeException(String message, Throwable cause, boolean causeEmbeddedInMessage) {
        super(message, cause);
        this.warnIfWrapping(cause);
        this.causeEmbeddedInMessage = causeEmbeddedInMessage;
    }

    public PropagatedRuntimeException(Throwable cause) {
        super("", cause);
        this.warnIfWrapping(cause);
        this.causeEmbeddedInMessage = false;
    }

    private void warnIfWrapping(Throwable cause) {
        if (LOG.isTraceEnabled() && cause instanceof PropagatedRuntimeException) {
            LOG.trace("Wrapping a PropagatedRuntimeException in another PropagatedRuntimeException. Call chain:", (Throwable)new Exception());
        }
    }

    @Override
    public String toString() {
        if (this.causeEmbeddedInMessage) {
            return super.toString();
        }
        return Exceptions.appendSeparator(super.toString(), Exceptions.collapseText(this.getCause()));
    }

    public boolean isCauseEmbeddedInMessage() {
        return this.causeEmbeddedInMessage;
    }
}

