/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.zookeeper;

import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.reflect.TypeToken;
import java.util.List;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.sensor.BasicAttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.group.DynamicCluster;
import org.apache.brooklyn.entity.zookeeper.ZooKeeperEnsembleImpl;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.guava.Suppliers;

@Catalog(name="ZooKeeper ensemble", description="A cluster of ZooKeeper servers. Apache ZooKeeper enables highly reliable distributed coordination.")
@ImplementedBy(value=ZooKeeperEnsembleImpl.class)
public interface ZooKeeperEnsemble
extends DynamicCluster {
    @SetFromFlag(value="clusterName")
    public static final BasicAttributeSensorAndConfigKey<String> CLUSTER_NAME = new BasicAttributeSensorAndConfigKey(String.class, "zookeeper.cluster.name", "Name of the Zookeeper cluster", (Object)"BrooklynZookeeperCluster");
    @SetFromFlag(value="initialSize")
    public static final ConfigKey<Integer> INITIAL_SIZE = ConfigKeys.newConfigKeyWithDefault((ConfigKey)DynamicCluster.INITIAL_SIZE, (Object)3);
    public static final ConfigKey<Supplier<Integer>> NODE_ID_SUPPLIER = ConfigKeys.builder((TypeToken)new TypeToken<Supplier<Integer>>(){}).name("zookeeper.nodeId.supplier").description("Supplies values for members id in zoo.cfg").defaultValue((Object)Suppliers.incrementing()).constraint(Predicates.notNull()).build();
    public static final AttributeSensor<List<String>> ZOOKEEPER_SERVERS = Sensors.newSensor((TypeToken)new TypeToken<List<String>>(){}, (String)"zookeeper.servers", (String)"Hostnames to connect to cluster with");
    public static final AttributeSensor<String> ZOOKEEPER_ENDPOINTS = Sensors.newStringSensor((String)"zookeeper.endpoints", (String)"A comma-separated host:port list of members of the ensemble");

    @Deprecated
    public String getClusterName();
}

