/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.proto.BookkeeperProtocol;
import org.apache.bookkeeper.proto.CompletionKey;
import org.apache.bookkeeper.proto.CompletionValue;
import org.apache.bookkeeper.proto.PerChannelBookieClient;

class WriteLacCompletion
extends CompletionValue {
    final BookkeeperInternalCallbacks.WriteLacCallback cb;

    public WriteLacCompletion(final CompletionKey key, final BookkeeperInternalCallbacks.WriteLacCallback originalCallback, final Object originalCtx, long ledgerId, PerChannelBookieClient perChannelBookieClient) {
        super("WriteLAC", originalCtx, ledgerId, -1L, perChannelBookieClient);
        this.opLogger = perChannelBookieClient.writeLacOpLogger;
        this.timeoutOpLogger = perChannelBookieClient.writeLacTimeoutOpLogger;
        this.cb = new BookkeeperInternalCallbacks.WriteLacCallback(){

            @Override
            public void writeLacComplete(int rc, long ledgerId, BookieId addr, Object ctx) {
                WriteLacCompletion.this.logOpResult(rc);
                originalCallback.writeLacComplete(rc, ledgerId, addr, originalCtx);
                key.release();
            }
        };
    }

    @Override
    public void errorOut() {
        this.errorOut(-8);
    }

    @Override
    public void errorOut(int rc) {
        this.errorOutAndRunCallback(() -> this.cb.writeLacComplete(rc, this.ledgerId, this.perChannelBookieClient.bookieId, this.ctx));
    }

    @Override
    public void handleV3Response(BookkeeperProtocol.Response response) {
        BookkeeperProtocol.WriteLacResponse writeLacResponse = response.getWriteLacResponse();
        BookkeeperProtocol.StatusCode status = response.getStatus() == BookkeeperProtocol.StatusCode.EOK ? writeLacResponse.getStatus() : response.getStatus();
        long ledgerId = writeLacResponse.getLedgerId();
        if (LOG.isDebugEnabled()) {
            this.logResponse(status, "ledger", ledgerId);
        }
        int rc = this.convertStatus(status, -12);
        this.cb.writeLacComplete(rc, ledgerId, this.perChannelBookieClient.bookieId, this.ctx);
    }
}

