/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.ClientCnxn;
import org.apache.zookeeper.ClientCnxnSocket;
import org.apache.zookeeper.ClientCnxnSocketNIO;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.client.HostProvider;
import org.apache.zookeeper.client.ZKClientConfig;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClientCnxnSocketFragilityTest
extends QuorumPeerTestBase {
    private static final int SERVER_COUNT = 3;
    private static final int SESSION_TIMEOUT = 40000;
    public static final int CONNECTION_TIMEOUT = 30000;
    private final UnsafeCoordinator unsafeCoordinator = new UnsafeCoordinator();
    private volatile CustomZooKeeper zk = null;
    private volatile FragileClientCnxnSocketNIO socket = null;
    private volatile CustomClientCnxn cnxn = null;

    private String getCxnString(int[] clientPorts) {
        StringBuffer hostPortBuffer = new StringBuffer();
        for (int i = 0; i < clientPorts.length; ++i) {
            hostPortBuffer.append("127.0.0.1:");
            hostPortBuffer.append(clientPorts[i]);
            if (i == clientPorts.length - 1) continue;
            hostPortBuffer.append(',');
        }
        return hostPortBuffer.toString();
    }

    private void closeZookeeper(ZooKeeper zk) {
        Executors.newSingleThreadExecutor().submit(() -> {
            try {
                LOG.info("closeZookeeper is fired");
                zk.close();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }

    @Test
    public void testClientCnxnSocketFragility() throws Exception {
        int i;
        System.setProperty("zookeeper.clientCnxnSocket", FragileClientCnxnSocketNIO.class.getName());
        System.setProperty("zookeeper.request.timeout", "1000");
        int[] clientPorts = new int[3];
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < 3; ++i2) {
            clientPorts[i2] = PortAssignment.unique();
            String server = "server." + i2 + "=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":participant;127.0.0.1:" + clientPorts[i2];
            sb.append(server + "\n");
        }
        String currentQuorumCfgSection = sb.toString();
        QuorumPeerTestBase.MainThread[] mt = new QuorumPeerTestBase.MainThread[3];
        for (i = 0; i < 3; ++i) {
            mt[i] = new QuorumPeerTestBase.MainThread(i, clientPorts[i], currentQuorumCfgSection, false);
            mt[i].start();
        }
        for (i = 0; i < 3; ++i) {
            Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[i], 30000L), (String)("waiting for server " + i + " being up"));
        }
        String path = "/testClientCnxnSocketFragility";
        String data = "balabala";
        ClientWatcher watcher = new ClientWatcher();
        this.zk = new CustomZooKeeper(this.getCxnString(clientPorts), 40000, watcher);
        watcher.watchFor(this.zk);
        this.zk.create(path, data.getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assertions.assertEquals((Object)new String(this.zk.getData(path, false, new Stat())), (Object)data);
        Assertions.assertTrue((!watcher.isSessionExpired() ? 1 : 0) != 0);
        this.socket.mute();
        boolean catchKeeperException = false;
        try {
            this.zk.getData(path, false, new Stat());
        }
        catch (KeeperException e) {
            catchKeeperException = true;
            Assertions.assertFalse((boolean)(e instanceof KeeperException.SessionExpiredException));
        }
        this.socket.unmute();
        Assertions.assertTrue((boolean)catchKeeperException);
        Assertions.assertTrue((!watcher.isSessionExpired() ? 1 : 0) != 0);
        GetDataRetryForeverBackgroundTask retryForeverGetData = new GetDataRetryForeverBackgroundTask(this.zk, path);
        retryForeverGetData.startTask();
        this.socket.mute();
        this.cnxn.attemptClose();
        this.cnxn.waitUntilHitUnsafeRegion();
        this.closeZookeeper(this.zk);
        TimeUnit.MILLISECONDS.sleep(3000L);
        Assertions.assertTrue((!this.zk.isAlive() ? 1 : 0) != 0);
        Assertions.assertTrue((!watcher.isSessionExpired() ? 1 : 0) != 0);
        retryForeverGetData.syncCloseTask();
        for (int i3 = 0; i3 < 3; ++i3) {
            mt[i3].shutdown();
        }
    }

    class CustomZooKeeper
    extends ZooKeeper {
        public CustomZooKeeper(String connectString, int sessionTimeout, Watcher watcher) throws IOException {
            super(connectString, sessionTimeout, watcher);
        }

        public boolean isAlive() {
            return this.cnxn.getState().isAlive();
        }

        ClientCnxn createConnection(String chrootPath, HostProvider hostProvider, int sessionTimeout, ZKClientConfig clientConfig, Watcher defaultWatcher, ClientCnxnSocket clientCnxnSocket, boolean canBeReadOnly) throws IOException {
            Assertions.assertTrue((boolean)(clientCnxnSocket instanceof FragileClientCnxnSocketNIO));
            ClientCnxnSocketFragilityTest.this.socket = (FragileClientCnxnSocketNIO)clientCnxnSocket;
            ClientCnxnSocketFragilityTest.this.cnxn = new CustomClientCnxn(chrootPath, hostProvider, sessionTimeout, clientConfig, defaultWatcher, clientCnxnSocket, canBeReadOnly);
            return ClientCnxnSocketFragilityTest.this.cnxn;
        }
    }

    class CustomClientCnxn
    extends ClientCnxn {
        private volatile boolean closing;
        private volatile boolean hitUnsafeRegion;

        public CustomClientCnxn(String chrootPath, HostProvider hostProvider, int sessionTimeout, ZKClientConfig zkClientConfig, Watcher defaultWatcher, ClientCnxnSocket clientCnxnSocket, boolean canBeReadOnly) throws IOException {
            super(chrootPath, hostProvider, sessionTimeout, zkClientConfig, defaultWatcher, clientCnxnSocket, canBeReadOnly);
            this.closing = false;
            this.hitUnsafeRegion = false;
        }

        void attemptClose() {
            this.closing = true;
        }

        void waitUntilHitUnsafeRegion() {
            while (!this.hitUnsafeRegion) {
                try {
                    TimeUnit.MILLISECONDS.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        protected void onConnecting(InetSocketAddress addr) {
            if (this.closing) {
                LOG.info("Attempt to connnecting {} {} {}", new Object[]{addr, this.closing, this.state});
                this.hitUnsafeRegion = true;
                ClientCnxnSocketFragilityTest.this.unsafeCoordinator.sync(this.closing);
            }
        }

        public void disconnect() {
            Assertions.assertTrue((boolean)this.closing);
            LOG.info("Attempt to disconnecting client for session: 0x{} {} {}", new Object[]{Long.toHexString(this.getSessionId()), this.closing, this.state});
            this.sendThread.close();
            ClientCnxnSocketFragilityTest.this.unsafeCoordinator.sync(this.closing);
            try {
                this.sendThread.join();
            }
            catch (InterruptedException ex) {
                LOG.warn("Got interrupted while waiting for the sender thread to close", (Throwable)ex);
            }
            this.eventThread.queueEventOfDeath();
        }
    }

    class UnsafeCoordinator {
        private CountDownLatch syncLatch = new CountDownLatch(2);

        UnsafeCoordinator() {
        }

        void sync(boolean closing) {
            LOG.info("Attempt to sync with {}", (Object)closing);
            if (closing) {
                this.syncLatch.countDown();
                try {
                    this.syncLatch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    class ClientWatcher
    implements Watcher {
        private ZooKeeper zk;
        private boolean sessionExpired = false;

        ClientWatcher() {
        }

        void watchFor(ZooKeeper zk) {
            this.zk = zk;
        }

        public void process(WatchedEvent event) {
            LOG.info("Watcher got {}", (Object)event);
            if (event.getState() == Watcher.Event.KeeperState.Expired) {
                this.sessionExpired = true;
            }
        }

        boolean isSessionExpired() {
            return this.sessionExpired;
        }
    }

    public static class FragileClientCnxnSocketNIO
    extends ClientCnxnSocketNIO {
        private volatile boolean mute = false;

        public FragileClientCnxnSocketNIO(ZKClientConfig clientConfig) throws IOException {
            super(clientConfig);
        }

        synchronized void mute() {
            if (!this.mute) {
                LOG.info("Fire socket mute");
                this.mute = true;
            }
        }

        synchronized void unmute() {
            if (this.mute) {
                LOG.info("Fire socket unmute");
                this.mute = false;
            }
        }

        void doTransport(int waitTimeOut, Queue<ClientCnxn.Packet> pendingQueue, ClientCnxn cnxn) throws IOException, InterruptedException {
            if (this.mute) {
                throw new IOException("Socket is mute");
            }
            super.doTransport(waitTimeOut, pendingQueue, cnxn);
        }

        void connect(InetSocketAddress addr) throws IOException {
            if (this.mute) {
                throw new IOException("Socket is mute");
            }
            super.connect(addr);
        }
    }

    class GetDataRetryForeverBackgroundTask
    extends Thread {
        private volatile boolean alive = false;
        private final CustomZooKeeper zk;
        private final String path;

        GetDataRetryForeverBackgroundTask(CustomZooKeeper zk, String path) {
            this.zk = zk;
            this.path = path;
            this.setDaemon(true);
        }

        void startTask() {
            this.alive = true;
            this.start();
        }

        void syncCloseTask() throws InterruptedException {
            this.alive = false;
            this.join();
        }

        @Override
        public void run() {
            while (this.alive) {
                try {
                    this.zk.getData(this.path, false, new Stat());
                    TimeUnit.MILLISECONDS.sleep(500L);
                }
                catch (Exception e) {
                    LOG.info("zookeeper getData failed on path {}", (Object)this.path);
                }
            }
        }
    }
}

