/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class QuorumCanonicalizeTest
extends ZKTestCase {
    private static final InetSocketAddress SA_DONT_CARE = InetSocketAddress.createUnresolved("dont.care.invalid", 80);
    private static final String ZK1_ALIAS = "zookeeper.invalid";
    private static final String ZK1_FQDN = "zk1.invalid";
    private static final String ZK1_IP = "169.254.0.42";
    private static final InetAddress IA_MOCK_ZK1;

    private static InetAddress getInetAddress(InetSocketAddress addr) {
        if (addr.getHostName().equals(ZK1_ALIAS) || addr.getHostName().equals(ZK1_IP)) {
            return IA_MOCK_ZK1;
        }
        return addr.getAddress();
    }

    @AfterEach
    public void cleanUpEnvironment() {
        System.clearProperty("zookeeper.kerberos.canonicalizeHostNames");
    }

    private QuorumPeer.QuorumServer createQuorumServer(String hostName) throws QuorumPeerConfig.ConfigException {
        return new QuorumPeer.QuorumServer(0L, hostName + ":1234:5678", QuorumCanonicalizeTest::getInetAddress);
    }

    @Test
    public void testQuorumDefaultCanonicalization() throws QuorumPeerConfig.ConfigException {
        QuorumPeer.QuorumServer qps = this.createQuorumServer(ZK1_ALIAS);
        Assertions.assertEquals((Object)ZK1_ALIAS, (Object)qps.hostname, (String)"The host name has been \"changed\" (canonicalized?) despite default settings");
    }

    @Test
    public void testQuorumNoCanonicalization() throws QuorumPeerConfig.ConfigException {
        System.setProperty("zookeeper.kerberos.canonicalizeHostNames", Boolean.FALSE.toString());
        QuorumPeer.QuorumServer qps = this.createQuorumServer(ZK1_ALIAS);
        Assertions.assertEquals((Object)ZK1_ALIAS, (Object)qps.hostname, (String)"The host name has been \"changed\" (canonicalized?) despite default settings");
    }

    @Test
    public void testQuorumCanonicalization() throws QuorumPeerConfig.ConfigException {
        System.setProperty("zookeeper.kerberos.canonicalizeHostNames", Boolean.TRUE.toString());
        QuorumPeer.QuorumServer qps = this.createQuorumServer(ZK1_ALIAS);
        Assertions.assertEquals((Object)ZK1_FQDN, (Object)qps.hostname, (String)"The host name hasn't been correctly canonicalized");
    }

    @Test
    public void testQuorumCanonicalizationFromIp() throws QuorumPeerConfig.ConfigException {
        System.setProperty("zookeeper.kerberos.canonicalizeHostNames", Boolean.TRUE.toString());
        QuorumPeer.QuorumServer qps = this.createQuorumServer(ZK1_IP);
        Assertions.assertEquals((Object)ZK1_FQDN, (Object)qps.hostname, (String)"The host name hasn't been correctly canonicalized");
    }

    static {
        InetAddress ia = (InetAddress)Mockito.mock(InetAddress.class);
        Mockito.when((Object)ia.getCanonicalHostName()).thenReturn((Object)ZK1_FQDN);
        IA_MOCK_ZK1 = ia;
    }
}

