/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.ldb;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.LastAddConfirmedUpdateNotification;
import org.apache.bookkeeper.bookie.storage.ldb.LedgerMetadataIndex;
import org.apache.bookkeeper.common.util.Watchable;
import org.apache.bookkeeper.common.util.Watcher;

class TransientLedgerInfo
extends Watchable<LastAddConfirmedUpdateNotification>
implements AutoCloseable {
    static final long LEDGER_INFO_CACHING_TIME_MINUTES = 10L;
    static final long NOT_ASSIGNED_LAC = Long.MIN_VALUE;
    private volatile long lac = Long.MIN_VALUE;
    private ByteBuffer explicitLac = null;
    private boolean isClosed;
    private final long ledgerId;
    private final LedgerMetadataIndex ledgerIndex;
    private long lastAccessed;

    public TransientLedgerInfo(long ledgerId, LedgerMetadataIndex ledgerIndex) {
        super(LastAddConfirmedUpdateNotification.WATCHER_RECYCLER);
        this.ledgerId = ledgerId;
        this.ledgerIndex = ledgerIndex;
        this.lastAccessed = System.currentTimeMillis();
    }

    long getLastAddConfirmed() {
        return this.lac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long setLastAddConfirmed(long lac) {
        long lacToReturn;
        boolean changed = false;
        TransientLedgerInfo transientLedgerInfo = this;
        synchronized (transientLedgerInfo) {
            if (this.lac == Long.MIN_VALUE || this.lac < lac) {
                this.lac = lac;
                changed = true;
                this.lastAccessed = System.currentTimeMillis();
            }
            lacToReturn = this.lac;
        }
        if (changed) {
            this.notifyWatchers(lacToReturn);
        }
        return lacToReturn;
    }

    synchronized boolean waitForLastAddConfirmedUpdate(long previousLAC, Watcher<LastAddConfirmedUpdateNotification> watcher) throws IOException {
        this.lastAccessed = System.currentTimeMillis();
        if (this.lac != Long.MIN_VALUE && this.lac > previousLAC || this.isClosed) {
            return false;
        }
        this.addWatcher(watcher);
        return true;
    }

    synchronized void cancelWaitForLastAddConfirmedUpdate(Watcher<LastAddConfirmedUpdateNotification> watcher) throws IOException {
        this.deleteWatcher(watcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuf getExplicitLac() {
        ByteBuf retLac = null;
        TransientLedgerInfo transientLedgerInfo = this;
        synchronized (transientLedgerInfo) {
            if (this.explicitLac != null) {
                retLac = Unpooled.buffer((int)this.explicitLac.capacity());
                this.explicitLac.rewind();
                retLac.writeBytes(this.explicitLac);
                this.explicitLac.rewind();
                return retLac;
            }
        }
        return retLac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExplicitLac(ByteBuf lac) {
        long explicitLacValue;
        TransientLedgerInfo transientLedgerInfo = this;
        synchronized (transientLedgerInfo) {
            if (this.explicitLac == null) {
                this.explicitLac = ByteBuffer.allocate(lac.capacity());
            }
            int readerIndex = lac.readerIndex();
            lac.readBytes(this.explicitLac);
            lac.readerIndex(readerIndex);
            this.explicitLac.rewind();
            this.explicitLac.getLong();
            explicitLacValue = this.explicitLac.getLong();
            this.explicitLac.rewind();
            this.lastAccessed = System.currentTimeMillis();
        }
        this.setLastAddConfirmed(explicitLacValue);
    }

    boolean isStale() {
        return this.lastAccessed + TimeUnit.MINUTES.toMillis(10L) < System.currentTimeMillis();
    }

    void notifyWatchers(long lastAddConfirmed) {
        this.notifyWatchers(LastAddConfirmedUpdateNotification.FUNC, lastAddConfirmed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        TransientLedgerInfo transientLedgerInfo = this;
        synchronized (transientLedgerInfo) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }
        this.notifyWatchers(Long.MAX_VALUE);
    }
}

