/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.DummyWatcher;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.admin.ZooKeeperAdmin;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.server.quorum.QuorumServerConfigBuilder;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.ReconfigTest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class QuorumPeerMainMultiAddressTest
extends QuorumPeerTestBase {
    private static final int FIRST_SERVER = 0;
    private static final int SECOND_SERVER = 1;
    private static final int THIRD_SERVER = 2;
    private static final int FIRST_ADDRESS = 0;
    private static final int SECOND_ADDRESS = 1;
    private static final String UNREACHABLE_HOST = "invalid.hostname.unreachable.com";
    private static final String IPV6_LOCALHOST = "[0:0:0:0:0:0:0:1]";
    private String hostName = "127.0.0.1";
    private int zNodeId = 0;

    @BeforeEach
    public void setUp() throws Exception {
        System.setProperty("zookeeper.multiAddress.enabled", "true");
        ClientBase.setupTestEnv();
        System.setProperty("zookeeper.DigestAuthenticationProvider.superDigest", "super:D/InIHSb7yEEbrWz8b9l71RjZJU=");
        QuorumPeerConfig.setReconfigEnabled((boolean)true);
        System.setProperty("zookeeper.jmx.log4j.disable", "true");
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        System.clearProperty("zookeeper.multiAddress.enabled");
        System.clearProperty("zookeeper.jmx.log4j.disable");
    }

    @Test
    public void shouldStartClusterWithMultipleAddresses() throws Exception {
        QuorumServerConfigBuilder quorumConfig = new QuorumServerConfigBuilder(this.hostName, 3, 2);
        QuorumServerConfigBuilder builderForServer1 = new QuorumServerConfigBuilder(quorumConfig);
        QuorumServerConfigBuilder builderForServer2 = new QuorumServerConfigBuilder(quorumConfig);
        QuorumServerConfigBuilder builderForServer3 = new QuorumServerConfigBuilder(quorumConfig);
        this.launchServers(Arrays.asList(builderForServer1, builderForServer2, builderForServer3));
        this.checkIfZooKeeperQuorumWorks(quorumConfig);
    }

    @Test
    public void shouldStartClusterWithMultipleAddresses_IPv6() throws Exception {
        this.hostName = IPV6_LOCALHOST;
        this.shouldStartClusterWithMultipleAddresses();
    }

    @Test
    public void shouldStartClusterWhenSomeAddressesAreUnreachable() throws Exception {
        QuorumServerConfigBuilder quorumConfig = new QuorumServerConfigBuilder(this.hostName, 3, 2).changeHostName(0, 1, UNREACHABLE_HOST).changeHostName(1, 1, UNREACHABLE_HOST).changeHostName(2, 1, UNREACHABLE_HOST);
        QuorumServerConfigBuilder builderForServer1 = new QuorumServerConfigBuilder(quorumConfig);
        QuorumServerConfigBuilder builderForServer2 = new QuorumServerConfigBuilder(quorumConfig);
        QuorumServerConfigBuilder builderForServer3 = new QuorumServerConfigBuilder(quorumConfig);
        this.launchServers(Arrays.asList(builderForServer1, builderForServer2, builderForServer3));
        this.checkIfZooKeeperQuorumWorks(quorumConfig);
    }

    @Test
    public void shouldStartClusterWhenSomeAddressesAreUnreachable_IPv6() throws Exception {
        this.hostName = IPV6_LOCALHOST;
        this.shouldStartClusterWhenSomeAddressesAreUnreachable();
    }

    @Test
    public void shouldReconfigIncrementallyByAddingMoreAddresses() throws Exception {
        QuorumServerConfigBuilder initialQuorumConfig = new QuorumServerConfigBuilder(this.hostName, 3, 2);
        this.launchServers(Arrays.asList(initialQuorumConfig, initialQuorumConfig, initialQuorumConfig));
        this.checkIfZooKeeperQuorumWorks(initialQuorumConfig);
        QuorumServerConfigBuilder newQuorumConfig = new QuorumServerConfigBuilder(initialQuorumConfig).addNewServerAddress(0);
        ZooKeeperAdmin zkAdmin = this.newZooKeeperAdmin(initialQuorumConfig);
        ReconfigTest.reconfig(zkAdmin, newQuorumConfig.buildAsStringList(), null, null, -1L);
        this.checkIfZooKeeperQuorumWorks(newQuorumConfig);
    }

    @Test
    public void shouldReconfigIncrementallyByDeletingSomeAddresses() throws Exception {
        QuorumServerConfigBuilder initialQuorumConfig = new QuorumServerConfigBuilder(this.hostName, 3, 3);
        this.launchServers(Arrays.asList(initialQuorumConfig, initialQuorumConfig, initialQuorumConfig));
        this.checkIfZooKeeperQuorumWorks(initialQuorumConfig);
        QuorumServerConfigBuilder newQuorumConfig = new QuorumServerConfigBuilder(initialQuorumConfig).deleteLastServerAddress(0).deleteLastServerAddress(1).deleteLastServerAddress(1).deleteLastServerAddress(2);
        ZooKeeperAdmin zkAdmin = this.newZooKeeperAdmin(initialQuorumConfig);
        ReconfigTest.reconfig(zkAdmin, newQuorumConfig.buildAsStringList(), null, null, -1L);
        this.checkIfZooKeeperQuorumWorks(newQuorumConfig);
    }

    @Test
    public void shouldReconfigNonIncrementally() throws Exception {
        QuorumServerConfigBuilder initialQuorumConfig = new QuorumServerConfigBuilder(this.hostName, 3, 2);
        this.launchServers(Arrays.asList(initialQuorumConfig, initialQuorumConfig, initialQuorumConfig));
        this.checkIfZooKeeperQuorumWorks(initialQuorumConfig);
        QuorumServerConfigBuilder newQuorumConfig = new QuorumServerConfigBuilder(initialQuorumConfig).deleteLastServerAddress(0).deleteLastServerAddress(1).deleteLastServerAddress(1).deleteLastServerAddress(2).addNewServerAddress(1).addNewServerAddress(2);
        ZooKeeperAdmin zkAdmin = this.newZooKeeperAdmin(initialQuorumConfig);
        ReconfigTest.reconfig(zkAdmin, null, null, newQuorumConfig.buildAsStringList(), -1L);
        this.checkIfZooKeeperQuorumWorks(newQuorumConfig);
    }

    @Test
    public void shouldReconfigIncrementally_IPv6() throws Exception {
        this.hostName = IPV6_LOCALHOST;
        QuorumServerConfigBuilder initialQuorumConfig = new QuorumServerConfigBuilder(this.hostName, 3, 2);
        this.launchServers(Arrays.asList(initialQuorumConfig, initialQuorumConfig, initialQuorumConfig));
        this.checkIfZooKeeperQuorumWorks(initialQuorumConfig);
        QuorumServerConfigBuilder newQuorumConfig = new QuorumServerConfigBuilder(initialQuorumConfig).deleteLastServerAddress(0).deleteLastServerAddress(1).deleteLastServerAddress(1).deleteLastServerAddress(2).addNewServerAddress(1).addNewServerAddress(2);
        ZooKeeperAdmin zkAdmin = this.newZooKeeperAdmin(initialQuorumConfig);
        ReconfigTest.reconfig(zkAdmin, newQuorumConfig.buildAsStringList(), null, null, -1L);
        this.checkIfZooKeeperQuorumWorks(newQuorumConfig);
    }

    @Test
    public void shouldFailToReconfigWithMultipleAddressesWhenFeatureIsDisabled() throws Exception {
        System.setProperty("zookeeper.multiAddress.enabled", "false");
        QuorumServerConfigBuilder initialQuorumConfig = new QuorumServerConfigBuilder(this.hostName, 3, 1);
        this.launchServers(Arrays.asList(initialQuorumConfig, initialQuorumConfig, initialQuorumConfig));
        this.checkIfZooKeeperQuorumWorks(initialQuorumConfig);
        QuorumServerConfigBuilder newQuorumConfig = new QuorumServerConfigBuilder(initialQuorumConfig).addNewServerAddress(0);
        ZooKeeperAdmin zkAdmin = this.newZooKeeperAdmin(initialQuorumConfig);
        try {
            ReconfigTest.reconfig(zkAdmin, newQuorumConfig.buildAsStringList(), null, null, -1L);
            Assertions.fail((String)"Reconfig succeeded with multiple addresses without exception when the MultiAddress feature is disabled");
        }
        catch (KeeperException.BadArgumentsException badArgumentsException) {
        }
        catch (Exception e) {
            Assertions.fail((String)"Reconfig failed in a wrong way. We expected KeeperException.BadArgumentsException.");
        }
    }

    private void launchServers(List<QuorumServerConfigBuilder> builders) throws IOException, InterruptedException {
        int i;
        this.numServers = builders.size();
        this.servers = new QuorumPeerTestBase.Servers();
        this.servers.clientPorts = new int[this.numServers];
        this.servers.mt = new QuorumPeerTestBase.MainThread[this.numServers];
        this.servers.zk = new ZooKeeper[this.numServers];
        for (i = 0; i < this.numServers; ++i) {
            QuorumServerConfigBuilder quorumServerConfigBuilder = builders.get(i);
            String quorumCfgSection = quorumServerConfigBuilder.build();
            LOG.info(String.format("starting server %d with quorum config:\n%s", i, quorumCfgSection));
            this.servers.clientPorts[i] = quorumServerConfigBuilder.getClientPort(i);
            this.servers.mt[i] = new QuorumPeerTestBase.MainThread(i, this.servers.clientPorts[i], quorumCfgSection);
            this.servers.mt[i].start();
            this.servers.restartClient(i, this);
        }
        this.waitForAll(this.servers, ZooKeeper.States.CONNECTED);
        for (i = 0; i < this.numServers; ++i) {
            this.servers.zk[i].close(5000);
        }
    }

    private void checkIfZooKeeperQuorumWorks(QuorumServerConfigBuilder builder) throws IOException, InterruptedException, KeeperException {
        LOG.info("starting to verify if Quorum works");
        ++this.zNodeId;
        String zNodePath = "/foo_" + this.zNodeId;
        ZooKeeper zk = this.connectToZkServer(builder, 0);
        zk.create(zNodePath, "foobar1".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assertions.assertEquals((Object)new String(zk.getData(zNodePath, null, null)), (Object)"foobar1");
        zk.close(1000);
        zk = this.connectToZkServer(builder, 1);
        Assertions.assertEquals((Object)new String(zk.getData(zNodePath, null, null)), (Object)"foobar1");
        zk.close(1000);
        zk = this.connectToZkServer(builder, 2);
        Assertions.assertEquals((Object)new String(zk.getData(zNodePath, null, null)), (Object)"foobar1");
        zk.close(1000);
        LOG.info("Quorum verification finished successfully");
    }

    private ZooKeeper connectToZkServer(QuorumServerConfigBuilder builder, int serverId) throws IOException, InterruptedException {
        QuorumServerConfigBuilder.ServerAddress server = builder.getServerAddress(serverId, 0);
        int clientPort = builder.getClientPort(serverId);
        ZooKeeper zk = new ZooKeeper(server.getHost() + ":" + clientPort, ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        QuorumPeerMainMultiAddressTest.waitForOne(zk, ZooKeeper.States.CONNECTED);
        return zk;
    }

    private ZooKeeperAdmin newZooKeeperAdmin(QuorumServerConfigBuilder quorumConfig) throws IOException {
        ZooKeeperAdmin zkAdmin = new ZooKeeperAdmin(this.hostName + ":" + quorumConfig.getClientPort(0), ClientBase.CONNECTION_TIMEOUT, (Watcher)DummyWatcher.INSTANCE);
        zkAdmin.addAuthInfo("digest", "super:test".getBytes());
        return zkAdmin;
    }
}

