/*
 * Decompiled with CFR 0.152.
 */
package com.scurrilous.circe.checksum;

import com.google.common.annotations.VisibleForTesting;
import com.scurrilous.circe.IncrementalIntHash;
import com.scurrilous.circe.checksum.Crc32cSse42Provider;
import com.scurrilous.circe.crc.Sse42Crc32C;
import com.scurrilous.circe.crc.StandardCrcProvider;
import com.scurrilous.circe.params.CrcParameters;
import io.netty.buffer.ByteBuf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Crc32cIntChecksum {
    private static final Logger log = LoggerFactory.getLogger(Crc32cIntChecksum.class);
    @VisibleForTesting
    static final IncrementalIntHash CRC32C_HASH;

    public static int computeChecksum(ByteBuf payload) {
        if (payload.hasMemoryAddress() && CRC32C_HASH instanceof Sse42Crc32C) {
            return CRC32C_HASH.calculate(payload.memoryAddress() + (long)payload.readerIndex(), payload.readableBytes());
        }
        if (payload.hasArray()) {
            return CRC32C_HASH.calculate(payload.array(), payload.arrayOffset() + payload.readerIndex(), payload.readableBytes());
        }
        return CRC32C_HASH.calculate(payload.nioBuffer());
    }

    public static int resumeChecksum(int previousChecksum, ByteBuf payload) {
        if (payload.hasMemoryAddress() && CRC32C_HASH instanceof Sse42Crc32C) {
            return CRC32C_HASH.resume(previousChecksum, payload.memoryAddress() + (long)payload.readerIndex(), payload.readableBytes());
        }
        if (payload.hasArray()) {
            return CRC32C_HASH.resume(previousChecksum, payload.array(), payload.arrayOffset() + payload.readerIndex(), payload.readableBytes());
        }
        return CRC32C_HASH.resume(previousChecksum, payload.nioBuffer());
    }

    static {
        if (Sse42Crc32C.isSupported()) {
            CRC32C_HASH = new Crc32cSse42Provider().getIncrementalInt(CrcParameters.CRC32C);
            log.info("SSE4.2 CRC32C provider initialized");
        } else {
            CRC32C_HASH = new StandardCrcProvider().getIncrementalInt(CrcParameters.CRC32C);
            log.warn("Failed to load Circe JNI library. Falling back to Java based CRC32c provider");
        }
    }
}

