/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.Destroyable;
import org.bouncycastle.jcajce.provider.KeyUtil;
import org.bouncycastle.util.Arrays;

class PBKDFPBEKey
extends SecretKeySpec
implements Destroyable,
PBEKey {
    private final AtomicBoolean hasBeenDestroyed = new AtomicBoolean(false);
    private final char[] password;
    private final byte[] salt;
    private final int iterationCount;

    public PBKDFPBEKey(byte[] byArray, String string, PBEKeySpec pBEKeySpec) {
        super(byArray, string);
        this.password = pBEKeySpec.getPassword();
        this.salt = pBEKeySpec.getSalt();
        this.iterationCount = pBEKeySpec.getIterationCount();
    }

    public String getAlgorithm() {
        KeyUtil.checkDestroyed(this);
        return super.getAlgorithm();
    }

    public String getFormat() {
        KeyUtil.checkDestroyed(this);
        return "RAW";
    }

    public byte[] getEncoded() {
        KeyUtil.checkDestroyed(this);
        return super.getEncoded();
    }

    public char[] getPassword() {
        KeyUtil.checkDestroyed(this);
        return this.password;
    }

    public byte[] getSalt() {
        KeyUtil.checkDestroyed(this);
        return Arrays.clone(this.salt);
    }

    public int getIterationCount() {
        KeyUtil.checkDestroyed(this);
        return this.iterationCount;
    }

    public void destroy() {
        if (!this.hasBeenDestroyed.getAndSet(true)) {
            if (this.password != null) {
                Arrays.fill(this.password, '\u0000');
            }
            if (this.salt != null) {
                Arrays.fill(this.salt, (byte)0);
            }
        }
    }

    public boolean isDestroyed() {
        return this.hasBeenDestroyed.get();
    }
}

