/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.commons.configuration.Configuration;
import org.apache.distributedlog.BKAsyncLogWriter;
import org.apache.distributedlog.BKDistributedLogManager;
import org.apache.distributedlog.BKLogSegmentWriter;
import org.apache.distributedlog.BKLogWriteHandler;
import org.apache.distributedlog.BKSyncLogWriter;
import org.apache.distributedlog.DLMTestUtil;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.LogRecord;
import org.apache.distributedlog.LogRecordWithDLSN;
import org.apache.distributedlog.LogSegmentMetadata;
import org.apache.distributedlog.TestDistributedLogBase;
import org.apache.distributedlog.TestZooKeeperClientBuilder;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.api.AsyncLogReader;
import org.apache.distributedlog.api.AsyncLogWriter;
import org.apache.distributedlog.api.DistributedLogManager;
import org.apache.distributedlog.api.LogReader;
import org.apache.distributedlog.api.LogWriter;
import org.apache.distributedlog.api.MetadataAccessor;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.api.namespace.NamespaceBuilder;
import org.apache.distributedlog.api.subscription.SubscriptionsStore;
import org.apache.distributedlog.bk.LedgerMetadata;
import org.apache.distributedlog.callback.LogSegmentListener;
import org.apache.distributedlog.exceptions.AlreadyTruncatedTransactionException;
import org.apache.distributedlog.exceptions.BKTransmitException;
import org.apache.distributedlog.exceptions.DLIllegalStateException;
import org.apache.distributedlog.exceptions.EndOfStreamException;
import org.apache.distributedlog.exceptions.InvalidStreamNameException;
import org.apache.distributedlog.exceptions.LogEmptyException;
import org.apache.distributedlog.exceptions.LogNotFoundException;
import org.apache.distributedlog.exceptions.LogReadException;
import org.apache.distributedlog.exceptions.LogRecordTooLongException;
import org.apache.distributedlog.exceptions.TransactionIdOutOfOrderException;
import org.apache.distributedlog.impl.BKNamespaceDriver;
import org.apache.distributedlog.impl.ZKLogSegmentMetadataStore;
import org.apache.distributedlog.io.Abortables;
import org.apache.distributedlog.io.AsyncAbortable;
import org.apache.distributedlog.io.AsyncCloseable;
import org.apache.distributedlog.logsegment.LogSegmentMetadataStore;
import org.apache.distributedlog.metadata.LogMetadata;
import org.apache.distributedlog.metadata.LogSegmentMetadataStoreUpdater;
import org.apache.distributedlog.metadata.MetadataUpdater;
import org.apache.distributedlog.util.Utils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestBKDistributedLogManager
extends TestDistributedLogBase {
    static final Logger LOG = LoggerFactory.getLogger(TestBKDistributedLogManager.class);
    private static final Random RAND = new Random(System.currentTimeMillis());
    @Rule
    public TestName testNames = new TestName();
    private static final long DEFAULT_SEGMENT_SIZE = 1000L;

    private void testNonPartitionedWritesInternal(String name, DistributedLogConfiguration conf) throws Exception {
        BKDistributedLogManager dlm = this.createNewDLM(conf, name);
        long txid = 1L;
        for (long i = 0L; i < 3L; ++i) {
            long start = txid;
            BKSyncLogWriter writer = dlm.startLogSegmentNonPartitioned();
            for (long j = 1L; j <= 1000L; ++j) {
                writer.write(DLMTestUtil.getLogRecordInstance(txid++));
            }
            BKLogSegmentWriter perStreamLogWriter = writer.getCachedLogWriter();
            writer.closeAndComplete();
            BKLogWriteHandler blplm = dlm.createWriteHandler(true);
            Assert.assertNotNull((Object)this.zkc.exists(blplm.completedLedgerZNode(start, txid - 1L, perStreamLogWriter.getLogSegmentSequenceNumber()), false));
            Utils.ioResult((CompletableFuture)blplm.asyncClose());
        }
        BKSyncLogWriter writer = dlm.startLogSegmentNonPartitioned();
        for (long j = 1L; j <= 500L; ++j) {
            writer.write(DLMTestUtil.getLogRecordInstance(txid++));
        }
        writer.flush();
        writer.commit();
        writer.close();
        LogReader reader = dlm.getInputStream(1L);
        long numTrans = 0L;
        LogRecordWithDLSN record = reader.readNext(false);
        long lastTxId = -1L;
        while (null != record) {
            DLMTestUtil.verifyLogRecord((LogRecord)record);
            assert (lastTxId < record.getTransactionId());
            lastTxId = record.getTransactionId();
            ++numTrans;
            record = reader.readNext(false);
        }
        reader.close();
        Assert.assertEquals((long)(txid - 1L), (long)numTrans);
    }

    @Test(timeout=60000L)
    public void testSimpleWrite() throws Exception {
        BKDistributedLogManager dlm = this.createNewDLM(conf, "distrlog-simplewrite");
        BKSyncLogWriter out = dlm.startLogSegmentNonPartitioned();
        for (long i = 1L; i <= 100L; ++i) {
            LogRecord op = DLMTestUtil.getLogRecordInstance(i);
            out.write(op);
        }
        BKLogSegmentWriter perStreamLogWriter = out.getCachedLogWriter();
        out.closeAndComplete();
        BKLogWriteHandler blplm = dlm.createWriteHandler(true);
        Assert.assertNotNull((Object)this.zkc.exists(blplm.completedLedgerZNode(1L, 100L, perStreamLogWriter.getLogSegmentSequenceNumber()), false));
        Utils.ioResult((CompletableFuture)blplm.asyncClose());
    }

    @Test(timeout=60000L)
    public void testNumberOfTransactions() throws Exception {
        String name = "distrlog-txncount";
        BKDistributedLogManager dlm = this.createNewDLM(conf, name);
        BKSyncLogWriter out = (BKSyncLogWriter)dlm.startLogSegmentNonPartitioned();
        for (long i = 1L; i <= 100L; ++i) {
            LogRecord op = DLMTestUtil.getLogRecordInstance(i);
            out.write(op);
        }
        out.closeAndComplete();
        long numTrans = DLMTestUtil.getNumberofLogRecords((DistributedLogManager)this.createNewDLM(conf, name), 1L);
        Assert.assertEquals((long)100L, (long)numTrans);
        dlm.close();
    }

    @Test(timeout=60000L)
    public void testContinuousReaders() throws Exception {
        String name = "distrlog-continuous";
        BKDistributedLogManager dlm = this.createNewDLM(conf, name);
        long txid = 1L;
        for (long i = 0L; i < 3L; ++i) {
            long start = txid;
            BKSyncLogWriter out = dlm.startLogSegmentNonPartitioned();
            for (long j = 1L; j <= 1000L; ++j) {
                LogRecord op = DLMTestUtil.getLogRecordInstance(txid++);
                out.write(op);
            }
            BKLogSegmentWriter perStreamLogWriter = out.getCachedLogWriter();
            out.closeAndComplete();
            BKLogWriteHandler blplm = dlm.createWriteHandler(true);
            Assert.assertNotNull((Object)this.zkc.exists(blplm.completedLedgerZNode(start, txid - 1L, perStreamLogWriter.getLogSegmentSequenceNumber()), false));
            Utils.ioResult((CompletableFuture)blplm.asyncClose());
        }
        BKSyncLogWriter out = dlm.startLogSegmentNonPartitioned();
        for (long j = 1L; j <= 500L; ++j) {
            LogRecord op = DLMTestUtil.getLogRecordInstance(txid++);
            out.write(op);
        }
        out.flush();
        out.commit();
        out.close();
        dlm.close();
        dlm = this.createNewDLM(conf, name);
        LogReader reader = dlm.getInputStream(1L);
        long numTrans = 0L;
        LogRecordWithDLSN record = reader.readNext(false);
        while (null != record) {
            DLMTestUtil.verifyLogRecord((LogRecord)record);
            ++numTrans;
            record = reader.readNext(false);
        }
        Assert.assertEquals((long)(txid - 1L), (long)numTrans);
        Assert.assertEquals((long)(txid - 1L), (long)dlm.getLogRecordCount());
        reader.close();
        dlm.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testWriteRestartFrom1() throws Exception {
        LogRecord op;
        BKDistributedLogManager dlm = this.createNewDLM(conf, "distrlog-restartFrom1");
        long txid = 1L;
        BKSyncLogWriter out = (BKSyncLogWriter)dlm.startLogSegmentNonPartitioned();
        for (long j = 1L; j <= 1000L; ++j) {
            op = DLMTestUtil.getLogRecordInstance(txid++);
            out.write(op);
        }
        out.closeAndComplete();
        txid = 1L;
        try {
            out = (BKSyncLogWriter)dlm.startLogSegmentNonPartitioned();
            out.write(DLMTestUtil.getLogRecordInstance(txid));
            Assert.fail((String)("Shouldn't be able to start another journal from " + txid + " when one already exists"));
        }
        catch (Exception ioe) {
            LOG.info("Caught exception as expected", (Throwable)ioe);
        }
        finally {
            out.close();
        }
        txid = 999L;
        try {
            out = (BKSyncLogWriter)dlm.startLogSegmentNonPartitioned();
            out.write(DLMTestUtil.getLogRecordInstance(txid));
            Assert.fail((String)("Shouldn't be able to start another journal from " + txid + " when one already exists"));
        }
        catch (TransactionIdOutOfOrderException rste) {
            LOG.info("Caught exception as expected", (Throwable)rste);
        }
        finally {
            out.close();
        }
        txid = 1001L;
        out = (BKSyncLogWriter)dlm.startLogSegmentNonPartitioned();
        Assert.assertNotNull((Object)out);
        for (long j = 1L; j <= 1000L; ++j) {
            op = DLMTestUtil.getLogRecordInstance(txid++);
            out.write(op);
        }
        out.closeAndComplete();
        txid = 4000L;
        out = (BKSyncLogWriter)dlm.startLogSegmentNonPartitioned();
        out.write(DLMTestUtil.getLogRecordInstance(txid));
        out.close();
        dlm.close();
    }

    @Test(timeout=60000L)
    public void testTwoWritersOnLockDisabled() throws Exception {
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.addConfiguration((Configuration)conf);
        confLocal.setOutputBufferSize(0);
        confLocal.setWriteLockEnabled(false);
        String name = "distrlog-two-writers-lock-disabled";
        BKDistributedLogManager manager = this.createNewDLM(confLocal, name);
        AsyncLogWriter writer1 = (AsyncLogWriter)Utils.ioResult((CompletableFuture)manager.openAsyncLogWriter());
        Utils.ioResult((CompletableFuture)writer1.write(DLMTestUtil.getLogRecordInstance(1L)));
        AsyncLogWriter writer2 = (AsyncLogWriter)Utils.ioResult((CompletableFuture)manager.openAsyncLogWriter());
        Utils.ioResult((CompletableFuture)writer2.write(DLMTestUtil.getLogRecordInstance(2L)));
        try {
            Utils.ioResult((CompletableFuture)writer1.write(DLMTestUtil.getLogRecordInstance(3L)));
            Assert.fail((String)"Should fail writing record to writer 1 again as writer 2 took over the ownership");
        }
        catch (BKTransmitException bkte) {
            Assert.assertEquals((long)-101L, (long)bkte.getBKResultCode());
        }
    }

    @Test(timeout=60000L)
    public void testSimpleRead() throws Exception {
        String name = "distrlog-simpleread";
        BKDistributedLogManager dlm = this.createNewDLM(conf, name);
        long numTransactions = 10000L;
        BKSyncLogWriter out = (BKSyncLogWriter)dlm.startLogSegmentNonPartitioned();
        for (long i = 1L; i <= 10000L; ++i) {
            LogRecord op = DLMTestUtil.getLogRecordInstance(i);
            out.write(op);
        }
        out.closeAndComplete();
        Assert.assertEquals((long)10000L, (long)DLMTestUtil.getNumberofLogRecords((DistributedLogManager)this.createNewDLM(conf, name), 1L));
        dlm.close();
    }

    @Test(timeout=60000L)
    public void testNumberOfTransactionsWithInprogressAtEnd() throws Exception {
        String name = "distrlog-inprogressAtEnd";
        BKDistributedLogManager dlm = this.createNewDLM(conf, name);
        long txid = 1L;
        for (long i = 0L; i < 3L; ++i) {
            long start = txid;
            BKSyncLogWriter out = (BKSyncLogWriter)dlm.startLogSegmentNonPartitioned();
            for (long j = 1L; j <= 1000L; ++j) {
                LogRecord op = DLMTestUtil.getLogRecordInstance(txid++);
                out.write(op);
            }
            BKLogSegmentWriter perStreamLogWriter = out.getCachedLogWriter();
            out.closeAndComplete();
            BKLogWriteHandler blplm = dlm.createWriteHandler(true);
            Assert.assertNotNull((Object)this.zkc.exists(blplm.completedLedgerZNode(start, txid - 1L, perStreamLogWriter.getLogSegmentSequenceNumber()), false));
            Utils.ioResult((CompletableFuture)blplm.asyncClose());
        }
        BKSyncLogWriter out = (BKSyncLogWriter)dlm.startLogSegmentNonPartitioned();
        for (long j = 1L; j <= 500L; ++j) {
            LogRecord op = DLMTestUtil.getLogRecordInstance(txid++);
            out.write(op);
        }
        out.flush();
        out.commit();
        out.close();
        long numTrans = DLMTestUtil.getNumberofLogRecords((DistributedLogManager)this.createNewDLM(conf, name), 1L);
        Assert.assertEquals((long)(txid - 1L), (long)numTrans);
    }

    @Test(timeout=60000L)
    public void testContinuousReaderBulk() throws Exception {
        String name = "distrlog-continuous-bulk";
        BKDistributedLogManager dlm = this.createNewDLM(conf, name);
        long txid = 1L;
        for (long i = 0L; i < 3L; ++i) {
            BKSyncLogWriter out = (BKSyncLogWriter)dlm.startLogSegmentNonPartitioned();
            for (long j = 1L; j <= 1000L; ++j) {
                LogRecord op = DLMTestUtil.getLogRecordInstance(txid++);
                out.write(op);
            }
            out.closeAndComplete();
        }
        BKSyncLogWriter out = (BKSyncLogWriter)dlm.startLogSegmentNonPartitioned();
        for (long j = 1L; j <= 500L; ++j) {
            LogRecord op = DLMTestUtil.getLogRecordInstance(txid++);
            out.write(op);
        }
        out.flush();
        out.commit();
        out.close();
        dlm.close();
        dlm = this.createNewDLM(conf, name);
        LogReader reader = dlm.getInputStream(1L);
        long numTrans = 0L;
        List recordList = reader.readBulk(false, 13);
        long lastTxId = -1L;
        while (!recordList.isEmpty()) {
            for (LogRecord record : recordList) {
                assert (lastTxId < record.getTransactionId());
                lastTxId = record.getTransactionId();
                DLMTestUtil.verifyLogRecord(record);
                ++numTrans;
            }
            recordList = reader.readBulk(false, 13);
        }
        reader.close();
        Assert.assertEquals((long)(txid - 1L), (long)numTrans);
    }

    @Test(timeout=60000L)
    public void testContinuousReadersWithEmptyLedgers() throws Exception {
        String name = "distrlog-continuous-emptyledgers";
        BKDistributedLogManager dlm = this.createNewDLM(conf, name);
        long txid = 1L;
        for (long i = 0L; i < 3L; ++i) {
            long start = txid;
            BKSyncLogWriter out = (BKSyncLogWriter)dlm.startLogSegmentNonPartitioned();
            for (long j = 1L; j <= 1000L; ++j) {
                LogRecord op = DLMTestUtil.getLogRecordInstance(txid++);
                out.write(op);
            }
            BKLogSegmentWriter writer = out.getCachedLogWriter();
            out.closeAndComplete();
            BKLogWriteHandler blplm = dlm.createWriteHandler(true);
            Assert.assertNotNull((Object)this.zkc.exists(blplm.completedLedgerZNode(start, txid - 1L, writer.getLogSegmentSequenceNumber()), false));
            BKLogSegmentWriter perStreamLogWriter = blplm.startLogSegment(txid - 1L);
            blplm.completeAndCloseLogSegment(perStreamLogWriter.getLogSegmentSequenceNumber(), perStreamLogWriter.getLogSegmentId(), txid - 1L, txid - 1L, 0);
            Assert.assertNotNull((Object)this.zkc.exists(blplm.completedLedgerZNode(txid - 1L, txid - 1L, perStreamLogWriter.getLogSegmentSequenceNumber()), false));
            Utils.ioResult((CompletableFuture)blplm.asyncClose());
        }
        BKSyncLogWriter out = (BKSyncLogWriter)dlm.startLogSegmentNonPartitioned();
        for (long j = 1L; j <= 500L; ++j) {
            LogRecord op = DLMTestUtil.getLogRecordInstance(txid++);
            out.write(op);
        }
        out.flush();
        out.commit();
        out.close();
        dlm.close();
        dlm = this.createNewDLM(conf, name);
        AsyncLogReader asyncreader = dlm.getAsyncLogReader(DLSN.InvalidDLSN);
        long numTrans = 0L;
        LogRecordWithDLSN record = (LogRecordWithDLSN)Utils.ioResult((CompletableFuture)asyncreader.readNext());
        while (null != record) {
            DLMTestUtil.verifyLogRecord((LogRecord)record);
            if (++numTrans >= txid - 1L) break;
            record = (LogRecordWithDLSN)Utils.ioResult((CompletableFuture)asyncreader.readNext());
        }
        Assert.assertEquals((long)(txid - 1L), (long)numTrans);
        Utils.close((AsyncCloseable)asyncreader);
        LogReader reader = dlm.getInputStream(1L);
        numTrans = 0L;
        record = reader.readNext(false);
        while (null != record) {
            DLMTestUtil.verifyLogRecord((LogRecord)record);
            ++numTrans;
            record = reader.readNext(false);
        }
        Assert.assertEquals((long)(txid - 1L), (long)numTrans);
        reader.close();
        Assert.assertEquals((long)(txid - 1L), (long)dlm.getLogRecordCount());
        dlm.close();
    }

    @Test(timeout=60000L)
    public void testNonPartitionedWrites() throws Exception {
        String name = "distrlog-non-partitioned-bulk";
        this.testNonPartitionedWritesInternal(name, conf);
    }

    @Test(timeout=60000L)
    public void testCheckLogExists() throws Exception {
        String name = "distrlog-check-log-exists";
        BKDistributedLogManager dlm = this.createNewDLM(conf, name);
        long txid = 1L;
        LogWriter writer = dlm.startLogSegmentNonPartitioned();
        for (long j = 1L; j <= 500L; ++j) {
            writer.write(DLMTestUtil.getLogRecordInstance(txid++));
        }
        writer.flush();
        writer.commit();
        writer.close();
        dlm.close();
        URI uri = this.createDLMURI("/" + name);
        Namespace namespace = NamespaceBuilder.newBuilder().conf(conf).uri(uri).build();
        Assert.assertTrue((boolean)namespace.logExists(name));
        Assert.assertFalse((boolean)namespace.logExists("non-existent-log"));
        URI nonExistentUri = this.createDLMURI("/non-existent-ns");
        Namespace nonExistentNS = NamespaceBuilder.newBuilder().conf(conf).uri(nonExistentUri).build();
        Assert.assertFalse((boolean)nonExistentNS.logExists(name));
        int logCount = 0;
        Iterator logIter = namespace.getLogs();
        while (logIter.hasNext()) {
            String log = (String)logIter.next();
            ++logCount;
            Assert.assertEquals((Object)name, (Object)log);
        }
        Assert.assertEquals((long)1L, (long)logCount);
        namespace.close();
    }

    @Test(timeout=60000L)
    public void testMetadataAccessor() throws Exception {
        String name = "distrlog-metadata-accessor";
        MetadataAccessor metadata = DLMTestUtil.createNewMetadataAccessor(conf, name, this.createDLMURI("/" + name));
        Assert.assertEquals((Object)name, (Object)metadata.getStreamName());
        metadata.createOrUpdateMetadata(name.getBytes());
        Assert.assertEquals((Object)name, (Object)new String(metadata.getMetadata()));
        metadata.deleteMetadata();
        Assert.assertEquals(null, (Object)metadata.getMetadata());
    }

    @Test(timeout=60000L)
    public void testSubscriptionsStore() throws Exception {
        String name = "distrlog-subscriptions-store";
        String subscriber0 = "subscriber-0";
        String subscriber1 = "subscriber-1";
        String subscriber2 = "subscriber-2";
        DLSN commitPosition0 = new DLSN(4L, 33L, 5L);
        DLSN commitPosition1 = new DLSN(4L, 34L, 5L);
        DLSN commitPosition2 = new DLSN(5L, 34L, 5L);
        DLSN commitPosition3 = new DLSN(6L, 35L, 6L);
        BKDistributedLogManager dlm = this.createNewDLM(conf, name);
        SubscriptionsStore store = dlm.getSubscriptionsStore();
        Assert.assertEquals((Object)Utils.ioResult((CompletableFuture)store.getLastCommitPosition(subscriber0)), (Object)DLSN.NonInclusiveLowerBound);
        Assert.assertEquals((Object)Utils.ioResult((CompletableFuture)store.getLastCommitPosition(subscriber1)), (Object)DLSN.NonInclusiveLowerBound);
        Assert.assertEquals((Object)Utils.ioResult((CompletableFuture)store.getLastCommitPosition(subscriber2)), (Object)DLSN.NonInclusiveLowerBound);
        Assert.assertTrue((boolean)((Map)Utils.ioResult((CompletableFuture)store.getLastCommitPositions())).isEmpty());
        Utils.ioResult((CompletableFuture)store.advanceCommitPosition(subscriber0, commitPosition0));
        Assert.assertEquals((Object)commitPosition0, (Object)Utils.ioResult((CompletableFuture)store.getLastCommitPosition(subscriber0)));
        Map committedPositions = (Map)Utils.ioResult((CompletableFuture)store.getLastCommitPositions());
        Assert.assertEquals((long)1L, (long)committedPositions.size());
        Assert.assertEquals((Object)commitPosition0, committedPositions.get(subscriber0));
        Utils.ioResult((CompletableFuture)store.advanceCommitPosition(subscriber1, commitPosition1));
        Assert.assertEquals((Object)commitPosition1, (Object)Utils.ioResult((CompletableFuture)store.getLastCommitPosition(subscriber1)));
        committedPositions = (Map)Utils.ioResult((CompletableFuture)store.getLastCommitPositions());
        Assert.assertEquals((long)2L, (long)committedPositions.size());
        Assert.assertEquals((Object)commitPosition0, committedPositions.get(subscriber0));
        Assert.assertEquals((Object)commitPosition1, committedPositions.get(subscriber1));
        Utils.ioResult((CompletableFuture)store.advanceCommitPosition(subscriber2, commitPosition2));
        Assert.assertEquals((Object)commitPosition2, (Object)Utils.ioResult((CompletableFuture)store.getLastCommitPosition(subscriber2)));
        committedPositions = (Map)Utils.ioResult((CompletableFuture)store.getLastCommitPositions());
        Assert.assertEquals((long)3L, (long)committedPositions.size());
        Assert.assertEquals((Object)commitPosition0, committedPositions.get(subscriber0));
        Assert.assertEquals((Object)commitPosition1, committedPositions.get(subscriber1));
        Assert.assertEquals((Object)commitPosition2, committedPositions.get(subscriber2));
        BKDistributedLogManager newDLM = this.createNewDLM(conf, name);
        SubscriptionsStore newStore = newDLM.getSubscriptionsStore();
        Utils.ioResult((CompletableFuture)newStore.advanceCommitPosition(subscriber2, commitPosition3));
        newStore.close();
        newDLM.close();
        committedPositions = (Map)Utils.ioResult((CompletableFuture)store.getLastCommitPositions());
        Assert.assertEquals((long)3L, (long)committedPositions.size());
        Assert.assertEquals((Object)commitPosition0, committedPositions.get(subscriber0));
        Assert.assertEquals((Object)commitPosition1, committedPositions.get(subscriber1));
        Assert.assertEquals((Object)commitPosition3, committedPositions.get(subscriber2));
        dlm.close();
    }

    private long writeAndMarkEndOfStream(DistributedLogManager dlm, long txid) throws Exception {
        for (long i = 0L; i < 3L; ++i) {
            BKLogWriteHandler blplm;
            long start = txid;
            BKSyncLogWriter writer = (BKSyncLogWriter)dlm.startLogSegmentNonPartitioned();
            for (long j = 1L; j <= 1000L; ++j) {
                writer.write(DLMTestUtil.getLogRecordInstance(txid++));
            }
            BKLogSegmentWriter perStreamLogWriter = writer.getCachedLogWriter();
            if (i < 2L) {
                writer.closeAndComplete();
                blplm = ((BKDistributedLogManager)dlm).createWriteHandler(true);
                Assert.assertNotNull((Object)this.zkc.exists(blplm.completedLedgerZNode(start, txid - 1L, perStreamLogWriter.getLogSegmentSequenceNumber()), false));
                Utils.ioResult((CompletableFuture)blplm.asyncClose());
                continue;
            }
            writer.markEndOfStream();
            blplm = ((BKDistributedLogManager)dlm).createWriteHandler(true);
            Assert.assertNotNull((Object)this.zkc.exists(blplm.completedLedgerZNode(start, Long.MAX_VALUE, perStreamLogWriter.getLogSegmentSequenceNumber()), false));
            Utils.ioResult((CompletableFuture)blplm.asyncClose());
        }
        return txid;
    }

    @Test(timeout=60000L)
    public void testMarkEndOfStream() throws Exception {
        String name = "distrlog-mark-end-of-stream";
        BKDistributedLogManager dlm = this.createNewDLM(conf, name);
        long txid = 1L;
        txid = this.writeAndMarkEndOfStream((DistributedLogManager)dlm, txid);
        LogReader reader = dlm.getInputStream(1L);
        long numTrans = 0L;
        boolean exceptionEncountered = false;
        LogRecordWithDLSN record = null;
        try {
            record = reader.readNext(false);
            long expectedTxId = 1L;
            while (null != record) {
                DLMTestUtil.verifyLogRecord((LogRecord)record);
                Assert.assertEquals((long)expectedTxId, (long)record.getTransactionId());
                ++expectedTxId;
                ++numTrans;
                record = reader.readNext(false);
            }
        }
        catch (EndOfStreamException exc) {
            LOG.info("Encountered EndOfStream on reading records after {}", (Object)record);
            exceptionEncountered = true;
        }
        Assert.assertEquals((long)(txid - 1L), (long)numTrans);
        Assert.assertTrue((boolean)exceptionEncountered);
        exceptionEncountered = false;
        try {
            reader.readNext(false);
        }
        catch (EndOfStreamException exc) {
            exceptionEncountered = true;
        }
        Assert.assertTrue((boolean)exceptionEncountered);
        reader.close();
    }

    @Test(timeout=60000L)
    public void testWriteFailsAfterMarkEndOfStream() throws Exception {
        String name = "distrlog-mark-end-failure";
        BKDistributedLogManager dlm = this.createNewDLM(conf, name);
        long txid = 1L;
        txid = this.writeAndMarkEndOfStream((DistributedLogManager)dlm, txid);
        Assert.assertEquals((long)(txid - 1L), (long)dlm.getLastTxId());
        LogRecordWithDLSN last = dlm.getLastLogRecord();
        Assert.assertEquals((long)(txid - 1L), (long)last.getTransactionId());
        DLMTestUtil.verifyLogRecord((LogRecord)last);
        Assert.assertTrue((boolean)dlm.isEndOfStreamMarked());
        LogWriter writer = null;
        boolean exceptionEncountered = false;
        try {
            writer = dlm.startLogSegmentNonPartitioned();
            for (long j = 1L; j <= 500L; ++j) {
                writer.write(DLMTestUtil.getLogRecordInstance(txid++));
            }
        }
        catch (EndOfStreamException exc) {
            exceptionEncountered = true;
        }
        writer.close();
        Assert.assertTrue((boolean)exceptionEncountered);
    }

    @Test(timeout=60000L)
    public void testMarkEndOfStreamOnEmptyStream() throws Exception {
        this.markEndOfStreamOnEmptyLogSegment(0);
    }

    @Test(timeout=60000L)
    public void testMarkEndOfStreamOnClosedStream() throws Exception {
        this.markEndOfStreamOnEmptyLogSegment(3);
    }

    private void markEndOfStreamOnEmptyLogSegment(int numCompletedSegments) throws Exception {
        String name = "distrlog-mark-end-empty-" + numCompletedSegments;
        BKDistributedLogManager dlm = this.createNewDLM(conf, name);
        DLMTestUtil.generateCompletedLogSegments((DistributedLogManager)dlm, conf, numCompletedSegments, 1000L);
        BKSyncLogWriter writer = (BKSyncLogWriter)dlm.startLogSegmentNonPartitioned();
        writer.markEndOfStream();
        LogReader reader = dlm.getInputStream(1L);
        long numTrans = 0L;
        boolean exceptionEncountered = false;
        try {
            LogRecordWithDLSN record = reader.readNext(false);
            long lastTxId = -1L;
            while (null != record) {
                DLMTestUtil.verifyLogRecord((LogRecord)record);
                assert (lastTxId < record.getTransactionId());
                lastTxId = record.getTransactionId();
                ++numTrans;
                record = reader.readNext(false);
            }
        }
        catch (EndOfStreamException exc) {
            exceptionEncountered = true;
        }
        Assert.assertEquals((long)((long)numCompletedSegments * 1000L), (long)numTrans);
        Assert.assertTrue((boolean)exceptionEncountered);
        exceptionEncountered = false;
        try {
            reader.readNext(false);
        }
        catch (EndOfStreamException exc) {
            exceptionEncountered = true;
        }
        Assert.assertTrue((boolean)exceptionEncountered);
        reader.close();
    }

    @Test(timeout=60000L, expected=LogRecordTooLongException.class)
    public void testMaxLogRecSize() throws Exception {
        BKDistributedLogManager dlm = this.createNewDLM(conf, "distrlog-maxlogRecSize");
        AsyncLogWriter writer = (AsyncLogWriter)Utils.ioResult((CompletableFuture)dlm.openAsyncLogWriter());
        Utils.ioResult((CompletableFuture)writer.write(new LogRecord(1L, DLMTestUtil.repeatString(DLMTestUtil.repeatString("abcdefgh", 256), 512).getBytes())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testMaxTransmissionSize() throws Exception {
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.loadConf(conf);
        confLocal.setOutputBufferSize(0x100000);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, "distrlog-transmissionSize");
        AsyncLogWriter out = (AsyncLogWriter)Utils.ioResult((CompletableFuture)dlm.openAsyncLogWriter());
        boolean exceptionEncountered = false;
        byte[] largePayload = new byte[522242];
        RAND.nextBytes(largePayload);
        try {
            LogRecord op = new LogRecord(1L, largePayload);
            CompletableFuture firstWriteFuture = out.write(op);
            op = new LogRecord(2L, largePayload);
            out.write(op);
            Utils.ioResult((CompletableFuture)firstWriteFuture);
        }
        catch (LogRecordTooLongException exc) {
            exceptionEncountered = true;
        }
        finally {
            Utils.ioResult((CompletableFuture)out.asyncClose());
        }
        Assert.assertFalse((boolean)exceptionEncountered);
        Abortables.abortQuietly((AsyncAbortable)out);
        dlm.close();
    }

    @Test(timeout=60000L)
    public void deleteDuringRead() throws Exception {
        String name = "distrlog-delete-with-reader";
        BKDistributedLogManager dlm = this.createNewDLM(conf, name);
        long txid = 1L;
        for (long i = 0L; i < 3L; ++i) {
            long start = txid;
            BKSyncLogWriter writer = (BKSyncLogWriter)dlm.startLogSegmentNonPartitioned();
            for (long j = 1L; j <= 1000L; ++j) {
                writer.write(DLMTestUtil.getLogRecordInstance(txid++));
            }
            BKLogSegmentWriter perStreamLogWriter = writer.getCachedLogWriter();
            writer.closeAndComplete();
            BKLogWriteHandler blplm = dlm.createWriteHandler(true);
            Assert.assertNotNull((Object)this.zkc.exists(blplm.completedLedgerZNode(start, txid - 1L, perStreamLogWriter.getLogSegmentSequenceNumber()), false));
            Utils.ioResult((CompletableFuture)blplm.asyncClose());
        }
        LogReader reader = dlm.getInputStream(1L);
        LogRecordWithDLSN record = reader.readNext(false);
        assert (null != record);
        DLMTestUtil.verifyLogRecord((LogRecord)record);
        long lastTxId = record.getTransactionId();
        dlm.delete();
        try {
            record = reader.readNext(false);
            while (null != record) {
                DLMTestUtil.verifyLogRecord((LogRecord)record);
                assert (lastTxId < record.getTransactionId());
                lastTxId = record.getTransactionId();
                record = reader.readNext(false);
            }
            while (true) {
                reader.readNext(false);
            }
        }
        catch (DLIllegalStateException | LogNotFoundException | LogReadException e) {
            boolean exceptionEncountered = true;
            Assert.assertTrue((boolean)exceptionEncountered);
            reader.close();
            return;
        }
    }

    @Test(timeout=60000L)
    public void testImmediateFlush() throws Exception {
        String name = "distrlog-immediate-flush";
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.loadConf(conf);
        confLocal.setOutputBufferSize(0);
        this.testNonPartitionedWritesInternal(name, confLocal);
    }

    @Test(timeout=60000L)
    public void testLastLogRecordWithEmptyLedgers() throws Exception {
        String name = "distrlog-lastLogRec-emptyledgers";
        BKDistributedLogManager dlm = this.createNewDLM(conf, name);
        long txid = 1L;
        for (long i = 0L; i < 3L; ++i) {
            long start = txid;
            BKSyncLogWriter out = (BKSyncLogWriter)dlm.startLogSegmentNonPartitioned();
            for (long j = 1L; j <= 1000L; ++j) {
                LogRecord op = DLMTestUtil.getLogRecordInstance(txid++);
                out.write(op);
            }
            BKLogSegmentWriter perStreamLogWriter = out.getCachedLogWriter();
            out.closeAndComplete();
            BKLogWriteHandler blplm = dlm.createWriteHandler(true);
            Assert.assertNotNull((Object)this.zkc.exists(blplm.completedLedgerZNode(start, txid - 1L, perStreamLogWriter.getLogSegmentSequenceNumber()), false));
            BKLogSegmentWriter writer = blplm.startLogSegment(txid - 1L);
            blplm.completeAndCloseLogSegment(writer.getLogSegmentSequenceNumber(), writer.getLogSegmentId(), txid - 1L, txid - 1L, 0);
            Assert.assertNotNull((Object)this.zkc.exists(blplm.completedLedgerZNode(txid - 1L, txid - 1L, writer.getLogSegmentSequenceNumber()), false));
            Utils.ioResult((CompletableFuture)blplm.asyncClose());
        }
        BKSyncLogWriter out = (BKSyncLogWriter)dlm.startLogSegmentNonPartitioned();
        LogRecord op = DLMTestUtil.getLogRecordInstance(txid);
        op.setControl();
        out.write(op);
        out.flush();
        out.commit();
        out.abort();
        dlm.close();
        dlm = this.createNewDLM(conf, name);
        Assert.assertEquals((long)(txid - 1L), (long)dlm.getLastTxId());
        LogRecordWithDLSN last = dlm.getLastLogRecord();
        Assert.assertEquals((long)(txid - 1L), (long)last.getTransactionId());
        DLMTestUtil.verifyLogRecord((LogRecord)last);
        Assert.assertEquals((long)(txid - 1L), (long)dlm.getLogRecordCount());
        dlm.close();
    }

    @Test(timeout=60000L)
    public void testLogSegmentListener() throws Exception {
        String name = "distrlog-logsegment-listener";
        int numSegments = 3;
        final CountDownLatch[] latches = new CountDownLatch[numSegments + 1];
        for (int i = 0; i < numSegments + 1; ++i) {
            latches[i] = new CountDownLatch(1);
        }
        final AtomicInteger numFailures = new AtomicInteger(0);
        final AtomicReference receivedStreams = new AtomicReference();
        BKDistributedLogManager dlm = this.createNewDLM(conf, name);
        Utils.ioResult((CompletableFuture)dlm.getWriterMetadataStore().getLog(dlm.getUri(), name, true, true));
        dlm.registerListener(new LogSegmentListener(){

            public void onSegmentsUpdated(List<LogSegmentMetadata> segments) {
                int updates = segments.size();
                boolean hasIncompletedLogSegments = false;
                for (LogSegmentMetadata l : segments) {
                    if (!l.isInProgress()) continue;
                    hasIncompletedLogSegments = true;
                    break;
                }
                if (hasIncompletedLogSegments) {
                    return;
                }
                if (updates >= 1 && segments.get(segments.size() - 1).getLogSegmentSequenceNumber() != (long)updates) {
                    numFailures.incrementAndGet();
                }
                receivedStreams.set(segments);
                latches[updates].countDown();
            }

            public void onLogStreamDeleted() {
            }
        });
        long txid = 1L;
        for (int i = 0; i < numSegments; ++i) {
            LOG.info("Waiting for creating log segment {}.", (Object)i);
            latches[i].await();
            LOG.info("Creating log segment {}.", (Object)i);
            BKSyncLogWriter out = dlm.startLogSegmentNonPartitioned();
            LOG.info("Created log segment {}.", (Object)i);
            for (long j = 1L; j <= 1000L; ++j) {
                LogRecord op = DLMTestUtil.getLogRecordInstance(txid++);
                out.write(op);
            }
            out.closeAndComplete();
            LOG.info("Completed log segment {}.", (Object)i);
        }
        latches[numSegments].await();
        Assert.assertEquals((long)0L, (long)numFailures.get());
        Assert.assertNotNull(receivedStreams.get());
        Assert.assertEquals((long)numSegments, (long)((Collection)receivedStreams.get()).size());
        int seqno = 1;
        for (LogSegmentMetadata m : (Collection)receivedStreams.get()) {
            Assert.assertEquals((long)seqno, (long)m.getLogSegmentSequenceNumber());
            Assert.assertEquals((long)((long)(seqno - 1) * 1000L + 1L), (long)m.getFirstTxId());
            Assert.assertEquals((long)((long)seqno * 1000L), (long)m.getLastTxId());
            ++seqno;
        }
        dlm.close();
    }

    @Test(timeout=60000L)
    public void testGetLastDLSN() throws Exception {
        LogRecord record;
        String name = "distrlog-get-last-dlsn";
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.loadConf(conf);
        confLocal.setFirstNumEntriesPerReadLastRecordScan(2);
        confLocal.setMaxNumEntriesPerReadLastRecordScan(4);
        confLocal.setImmediateFlushEnabled(true);
        confLocal.setOutputBufferSize(0);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        BKAsyncLogWriter writer = (BKAsyncLogWriter)dlm.startAsyncLogSegmentNonPartitioned();
        long txid = 1L;
        LOG.info("Writing 10 control records");
        for (int i = 0; i < 10; ++i) {
            record = DLMTestUtil.getLogRecordInstance(txid++);
            record.setControl();
            Utils.ioResult((CompletableFuture)writer.writeControlRecord(record));
        }
        LOG.info("10 control records are written");
        try {
            dlm.getLastDLSN();
            Assert.fail((String)"Should fail on getting last dlsn from an empty log.");
        }
        catch (LogEmptyException i) {
            // empty catch block
        }
        writer.closeAndComplete();
        LOG.info("Completed first log segment");
        writer = (BKAsyncLogWriter)dlm.startAsyncLogSegmentNonPartitioned();
        Utils.ioResult((CompletableFuture)writer.write(DLMTestUtil.getLogRecordInstance(txid++)));
        LOG.info("Completed second log segment");
        LOG.info("Writing another 10 control records");
        for (int i = 1; i < 10; ++i) {
            record = DLMTestUtil.getLogRecordInstance(txid++);
            record.setControl();
            Utils.ioResult((CompletableFuture)writer.write(record));
        }
        Assert.assertEquals((Object)new DLSN(2L, 0L, 0L), (Object)dlm.getLastDLSN());
        writer.closeAndComplete();
        LOG.info("Completed third log segment");
        Assert.assertEquals((Object)new DLSN(2L, 0L, 0L), (Object)dlm.getLastDLSN());
        writer.close();
        dlm.close();
    }

    @Test(timeout=60000L)
    public void testGetLogRecordCountAsync() throws Exception {
        BKDistributedLogManager dlm = this.createNewDLM(conf, this.testNames.getMethodName());
        BKAsyncLogWriter writer = (BKAsyncLogWriter)dlm.startAsyncLogSegmentNonPartitioned();
        DLMTestUtil.generateCompletedLogSegments((DistributedLogManager)dlm, conf, 2L, 10L);
        CompletableFuture futureCount = dlm.getLogRecordCountAsync(DLSN.InitialDLSN);
        Long count = (Long)Utils.ioResult((CompletableFuture)futureCount, (long)2L, (TimeUnit)TimeUnit.SECONDS);
        Assert.assertEquals((long)20L, (long)count);
        writer.close();
        dlm.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testInvalidStreamFromInvalidZkPath() throws Exception {
        String baseName = this.testNames.getMethodName();
        String streamName = "\u0000blah";
        URI uri = this.createDLMURI("/" + baseName);
        Namespace namespace = NamespaceBuilder.newBuilder().conf(conf).uri(uri).build();
        DistributedLogManager dlm = null;
        AsyncLogWriter writer = null;
        try {
            dlm = namespace.openLog(streamName);
            writer = dlm.startAsyncLogSegmentNonPartitioned();
            Assert.fail((String)"should have thrown");
        }
        catch (InvalidStreamNameException invalidStreamNameException) {
        }
        finally {
            if (null != writer) {
                Utils.close((AsyncCloseable)writer);
            }
            if (null != dlm) {
                dlm.close();
            }
            namespace.close();
        }
    }

    @Test(timeout=60000L)
    public void testTruncationValidation() throws Exception {
        LogRecord record;
        String name = "distrlog-truncation-validation";
        URI uri = this.createDLMURI("/" + name);
        ZooKeeperClient zookeeperClient = TestZooKeeperClientBuilder.newBuilder().uri(uri).build();
        OrderedScheduler scheduler = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().name("test-truncation-validation").numThreads(1).build();
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.loadConf(conf);
        confLocal.setDLLedgerMetadataLayoutVersion(LogSegmentMetadata.LEDGER_METADATA_CURRENT_LAYOUT_VERSION);
        confLocal.setOutputBufferSize(0);
        confLocal.setLogSegmentCacheEnabled(false);
        ZKLogSegmentMetadataStore metadataStore = new ZKLogSegmentMetadataStore(confLocal, zookeeperClient, scheduler);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        DLSN truncDLSN = DLSN.InitialDLSN;
        DLSN beyondTruncDLSN = DLSN.InitialDLSN;
        long beyondTruncTxId = 1L;
        long txid = 1L;
        for (long i = 0L; i < 3L; ++i) {
            long start = txid;
            BKAsyncLogWriter writer = dlm.startAsyncLogSegmentNonPartitioned();
            for (long j = 1L; j <= 10L; ++j) {
                record = DLMTestUtil.getLargeLogRecordInstance(txid++);
                CompletableFuture dlsn = writer.write(record);
                if (i == 1L && j == 2L) {
                    truncDLSN = (DLSN)Utils.ioResult((CompletableFuture)dlsn);
                    continue;
                }
                if (i == 2L && j == 3L) {
                    beyondTruncDLSN = (DLSN)Utils.ioResult((CompletableFuture)dlsn);
                    beyondTruncTxId = record.getTransactionId();
                    continue;
                }
                if (j != 10L) continue;
                Utils.ioResult((CompletableFuture)dlsn);
            }
            writer.close();
        }
        LogReader reader = dlm.getInputStream(DLSN.InitialDLSN);
        LogRecordWithDLSN record2 = reader.readNext(false);
        Assert.assertTrue((record2 != null && record2.getDlsn().compareTo(DLSN.InitialDLSN) == 0 ? 1 : 0) != 0);
        reader.close();
        Map<Long, LogSegmentMetadata> segmentList = DLMTestUtil.readLogSegments(zookeeperClient, LogMetadata.getLogSegmentsPath((URI)uri, (String)name, (String)confLocal.getUnpartitionedStreamName()));
        LOG.info("Read segments before truncating first segment : {}", segmentList);
        MetadataUpdater updater = LogSegmentMetadataStoreUpdater.createMetadataUpdater((DistributedLogConfiguration)confLocal, (LogSegmentMetadataStore)metadataStore);
        Utils.ioResult((CompletableFuture)updater.setLogSegmentTruncated(segmentList.get(1L)));
        segmentList = DLMTestUtil.readLogSegments(zookeeperClient, LogMetadata.getLogSegmentsPath((URI)uri, (String)name, (String)confLocal.getUnpartitionedStreamName()));
        LOG.info("Read segments after truncated first segment : {}", segmentList);
        LogReader reader2 = dlm.getInputStream(DLSN.InitialDLSN);
        LogRecordWithDLSN record3 = reader2.readNext(false);
        Assert.assertTrue((String)("Unexpected record : " + record3), (record3 != null && record3.getDlsn().compareTo(new DLSN(2L, 0L, 0L)) == 0 ? 1 : 0) != 0);
        reader2.close();
        reader2 = dlm.getInputStream(1L);
        record3 = reader2.readNext(false);
        Assert.assertTrue((record3 != null && record3.getDlsn().compareTo(new DLSN(2L, 0L, 0L)) == 0 ? 1 : 0) != 0);
        reader2.close();
        updater = LogSegmentMetadataStoreUpdater.createMetadataUpdater((DistributedLogConfiguration)confLocal, (LogSegmentMetadataStore)metadataStore);
        Utils.ioResult((CompletableFuture)updater.setLogSegmentActive(segmentList.get(1L)));
        segmentList = DLMTestUtil.readLogSegments(zookeeperClient, LogMetadata.getLogSegmentsPath((URI)uri, (String)name, (String)confLocal.getUnpartitionedStreamName()));
        LOG.info("Read segments after marked first segment as active : {}", segmentList);
        updater = LogSegmentMetadataStoreUpdater.createMetadataUpdater((DistributedLogConfiguration)confLocal, (LogSegmentMetadataStore)metadataStore);
        Utils.ioResult((CompletableFuture)updater.setLogSegmentTruncated(segmentList.get(2L)));
        segmentList = DLMTestUtil.readLogSegments(zookeeperClient, LogMetadata.getLogSegmentsPath((URI)uri, (String)name, (String)confLocal.getUnpartitionedStreamName()));
        LOG.info("Read segments after truncated second segment : {}", segmentList);
        reader2 = dlm.getAsyncLogReader(DLSN.InitialDLSN);
        long expectedTxId = 1L;
        boolean exceptionEncountered = false;
        try {
            for (int i = 0; i < 30; ++i) {
                record = (LogRecordWithDLSN)Utils.ioResult((CompletableFuture)reader2.readNext());
                DLMTestUtil.verifyLargeLogRecord(record);
                Assert.assertEquals((long)expectedTxId, (long)record.getTransactionId());
                ++expectedTxId;
            }
        }
        catch (AlreadyTruncatedTransactionException exc) {
            exceptionEncountered = true;
        }
        Assert.assertTrue((boolean)exceptionEncountered);
        Utils.close((AsyncCloseable)reader2);
        updater = LogSegmentMetadataStoreUpdater.createMetadataUpdater((DistributedLogConfiguration)conf, (LogSegmentMetadataStore)metadataStore);
        Utils.ioResult((CompletableFuture)updater.setLogSegmentActive(segmentList.get(2L)));
        BKAsyncLogWriter writer = dlm.startAsyncLogSegmentNonPartitioned();
        Assert.assertTrue((boolean)((Boolean)Utils.ioResult((CompletableFuture)writer.truncate(truncDLSN))));
        BKLogWriteHandler handler = writer.getCachedWriteHandler();
        List cachedSegments = handler.getCachedLogSegments(LogSegmentMetadata.COMPARATOR);
        for (LogSegmentMetadata segment : cachedSegments) {
            if (segment.getLastDLSN().compareTo(truncDLSN) < 0) {
                Assert.assertTrue((boolean)segment.isTruncated());
                Assert.assertTrue((!segment.isPartiallyTruncated() ? 1 : 0) != 0);
                continue;
            }
            if (segment.getFirstDLSN().compareTo(truncDLSN) < 0) {
                Assert.assertTrue((!segment.isTruncated() ? 1 : 0) != 0);
                Assert.assertTrue((boolean)segment.isPartiallyTruncated());
                continue;
            }
            Assert.assertTrue((!segment.isTruncated() ? 1 : 0) != 0);
            Assert.assertTrue((!segment.isPartiallyTruncated() ? 1 : 0) != 0);
        }
        segmentList = DLMTestUtil.readLogSegments(zookeeperClient, LogMetadata.getLogSegmentsPath((URI)uri, (String)name, (String)conf.getUnpartitionedStreamName()));
        Assert.assertTrue((segmentList.get(truncDLSN.getLogSegmentSequenceNo()).getMinActiveDLSN().compareTo(truncDLSN) == 0 ? 1 : 0) != 0);
        LogReader reader3 = dlm.getInputStream(DLSN.InitialDLSN);
        LogRecordWithDLSN record4 = reader3.readNext(false);
        Assert.assertTrue((record4 != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)truncDLSN, (Object)record4.getDlsn());
        reader3.close();
        reader3 = dlm.getInputStream(1L);
        record4 = reader3.readNext(false);
        Assert.assertTrue((record4 != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)truncDLSN, (Object)record4.getDlsn());
        reader3.close();
        reader3 = dlm.getAsyncLogReader(DLSN.InitialDLSN);
        record4 = (LogRecordWithDLSN)Utils.ioResult((CompletableFuture)reader3.readNext());
        Assert.assertTrue((record4 != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)truncDLSN, (Object)record4.getDlsn());
        Utils.close((AsyncCloseable)reader3);
        reader3 = dlm.getInputStream(beyondTruncDLSN);
        record4 = reader3.readNext(false);
        Assert.assertTrue((record4 != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)beyondTruncDLSN, (Object)record4.getDlsn());
        reader3.close();
        reader3 = dlm.getInputStream(beyondTruncTxId);
        record4 = reader3.readNext(false);
        Assert.assertTrue((record4 != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)beyondTruncDLSN, (Object)record4.getDlsn());
        Assert.assertEquals((long)beyondTruncTxId, (long)record4.getTransactionId());
        reader3.close();
        reader3 = dlm.getAsyncLogReader(beyondTruncDLSN);
        record4 = (LogRecordWithDLSN)Utils.ioResult((CompletableFuture)reader3.readNext());
        Assert.assertTrue((record4 != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)beyondTruncDLSN, (Object)record4.getDlsn());
        Utils.close((AsyncCloseable)reader3);
        zookeeperClient.close();
    }

    @Test(timeout=60000L)
    public void testDeleteLog() throws Exception {
        String name = "delete-log-should-delete-ledgers";
        BKDistributedLogManager dlm = this.createNewDLM(conf, name);
        long txid = 1L;
        BKSyncLogWriter writer = (BKSyncLogWriter)dlm.startLogSegmentNonPartitioned();
        for (long j = 1L; j <= 1000L; ++j) {
            writer.write(DLMTestUtil.getLogRecordInstance(txid++));
        }
        BKLogSegmentWriter perStreamLogWriter = writer.getCachedLogWriter();
        writer.closeAndComplete();
        BKLogWriteHandler blplm = dlm.createWriteHandler(true);
        Assert.assertNotNull((Object)this.zkc.exists(blplm.completedLedgerZNode(txid, txid - 1L, perStreamLogWriter.getLogSegmentSequenceNumber()), false));
        Utils.ioResult((CompletableFuture)blplm.asyncClose());
        long ledgerId = perStreamLogWriter.getLogSegmentId();
        BKNamespaceDriver driver = (BKNamespaceDriver)dlm.getNamespaceDriver();
        driver.getReaderBKC().get().openLedgerNoRecovery(ledgerId, BookKeeper.DigestType.CRC32, conf.getBKDigestPW().getBytes(StandardCharsets.UTF_8));
        dlm.delete();
        try {
            driver.getReaderBKC().get().openLedgerNoRecovery(ledgerId, BookKeeper.DigestType.CRC32, conf.getBKDigestPW().getBytes(StandardCharsets.UTF_8));
            Assert.fail((String)"Should fail to open ledger after we delete the log");
        }
        catch (BKException.BKNoSuchLedgerExistsOnMetadataServerException bKNoSuchLedgerExistsOnMetadataServerException) {
            // empty catch block
        }
        try {
            dlm.delete();
        }
        catch (IOException ioe) {
            Assert.fail((String)"Delete log twice should not throw any exception");
        }
    }

    @Test(timeout=60000L)
    public void testSyncLogWithLedgerMetadata() throws Exception {
        String application = "myapplication";
        String component = "mycomponent";
        String custom = "mycustommetadata";
        LedgerMetadata ledgerMetadata = new LedgerMetadata();
        ledgerMetadata.setApplication(application);
        ledgerMetadata.setComponent(component);
        ledgerMetadata.addCustomMetadata("custom", custom);
        BKDistributedLogManager dlm = this.createNewDLM(conf, "distrlog-writemetadata-sync");
        BKSyncLogWriter sync = dlm.openLogWriter(ledgerMetadata);
        sync.write(DLMTestUtil.getLogRecordInstance(1L));
        LedgerHandle lh = this.getLedgerHandle(sync.getCachedLogWriter());
        Map customMeta = lh.getCustomMetadata();
        Assert.assertEquals((Object)application, (Object)new String((byte[])customMeta.get("application"), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)component, (Object)new String((byte[])customMeta.get("component"), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)custom, (Object)new String((byte[])customMeta.get("custom"), StandardCharsets.UTF_8));
        sync.closeAndComplete();
    }

    @Test(timeout=60000L)
    public void testAsyncLogWithLedgerMetadata() throws Exception {
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.addConfiguration((Configuration)conf);
        confLocal.setOutputBufferSize(0);
        confLocal.setWriteLockEnabled(false);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, "distrlog-writemetadata-async");
        String application = "myapplication";
        String custom = "mycustommetadata";
        LedgerMetadata ledgerMetadata = new LedgerMetadata();
        ledgerMetadata.setApplication(application);
        ledgerMetadata.addCustomMetadata("custom", custom);
        AsyncLogWriter async = (AsyncLogWriter)Utils.ioResult((CompletableFuture)dlm.openAsyncLogWriter(ledgerMetadata));
        Utils.ioResult((CompletableFuture)async.write(DLMTestUtil.getLogRecordInstance(2L)));
        LedgerHandle lh = this.getLedgerHandle(((BKAsyncLogWriter)async).getCachedLogWriter());
        Map customMeta = lh.getCustomMetadata();
        Assert.assertEquals((Object)application, (Object)new String((byte[])customMeta.get("application"), StandardCharsets.UTF_8));
        Assert.assertNull(customMeta.get("component"));
        Assert.assertEquals((Object)custom, (Object)new String((byte[])customMeta.get("custom"), StandardCharsets.UTF_8));
    }
}

