/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.shaded.org.openjdk.tools.javac.file;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.file.FSInfo;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.util.Context;

public class CacheFSInfo
extends FSInfo {
    private final Map<Path, Entry> cache = new ConcurrentHashMap<Path, Entry>();

    public static void preRegister(Context context) {
        context.put(FSInfo.class, new Context.Factory<FSInfo>(){

            @Override
            public FSInfo make(Context c) {
                CacheFSInfo instance = new CacheFSInfo();
                c.put(FSInfo.class, instance);
                return instance;
            }
        });
    }

    public void clearCache() {
        this.cache.clear();
    }

    @Override
    public Path getCanonicalFile(Path file) {
        Entry e = this.getEntry(file);
        return e.canonicalFile;
    }

    @Override
    public boolean exists(Path file) {
        Entry e = this.getEntry(file);
        return e.exists;
    }

    @Override
    public boolean isDirectory(Path file) {
        Entry e = this.getEntry(file);
        return e.isDirectory;
    }

    @Override
    public boolean isFile(Path file) {
        Entry e = this.getEntry(file);
        return e.isFile;
    }

    @Override
    public List<Path> getJarClassPath(Path file) throws IOException {
        Entry e = this.getEntry(file);
        if (e.jarClassPath == null) {
            e.jarClassPath = super.getJarClassPath(file);
        }
        return e.jarClassPath;
    }

    private Entry getEntry(Path file) {
        Entry e = this.cache.get(file);
        if (e == null) {
            e = new Entry();
            e.canonicalFile = super.getCanonicalFile(file);
            e.exists = super.exists(file);
            e.isDirectory = super.isDirectory(file);
            e.isFile = super.isFile(file);
            this.cache.put(file, e);
        }
        return e;
    }

    private static class Entry {
        Path canonicalFile;
        boolean exists;
        boolean isFile;
        boolean isDirectory;
        List<Path> jarClassPath;

        private Entry() {
        }
    }
}

