/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.excerpt;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import org.inferred.freebuilder.processor.BuildableType;
import org.inferred.freebuilder.processor.BuilderFactory;
import org.inferred.freebuilder.processor.source.Excerpt;
import org.inferred.freebuilder.processor.source.LazyName;
import org.inferred.freebuilder.processor.source.SourceBuilder;
import org.inferred.freebuilder.processor.source.ValueType;
import org.inferred.freebuilder.processor.source.feature.GuavaLibrary;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableList;

public class BuildableList
extends ValueType
implements Excerpt {
    private final BuildableType element;

    public static LazyName of(BuildableType element) {
        return new BuildableList(element).name();
    }

    private BuildableList(BuildableType element) {
        this.element = element;
    }

    LazyName name() {
        return LazyName.of(this.element.type().getSimpleName() + "BuilderList", this);
    }

    @Override
    public void addTo(SourceBuilder code) {
        code.addLine("@%s({\"rawtypes\", \"unchecked\"})", SuppressWarnings.class).addLine("private class %s extends %s<%s> implements %s {", this.name(), AbstractList.class, this.element.builderType(), RandomAccess.class).addLine("", new Object[0]).addLine("  // A list of value or builder instances", new Object[0]);
        if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
            code.addLine("  private %s elements = %s.of();", List.class, ImmutableList.class);
        } else {
            code.addLine("  private final %1$s elements = new %1$s();", ArrayList.class);
        }
        BuildableList.addSize(code);
        this.addGet(code);
        this.addSet(code);
        this.addAdd(code);
        this.addRemove(code);
        BuildableList.addEnsureCapacity(code);
        this.addAddValue(code);
        this.addAddAllValues(code);
        this.addBuild(code, "build");
        this.addBuild(code, "buildPartial");
        code.addLine("}", new Object[0]);
    }

    private static void addSize(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("@Override", new Object[0]).addLine("public int size() {", new Object[0]).addLine("  return elements.size();", new Object[0]).addLine("}", new Object[0]);
    }

    private void addGet(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("@Override", new Object[0]).addLine("public %s get(int index) {", this.element.builderType()).addLine("  Object element = elements.get(index);", new Object[0]).addLine("  if (element instanceof %s) {", this.element.type().getQualifiedName());
        BuildableList.convertToArrayList(code);
        this.convertToBuilder("element", code);
        code.addLine("    elements.set(index, element);", new Object[0]).addLine("  }", new Object[0]).addLine("  return (%s) element;", this.element.builderType()).addLine("}", new Object[0]);
    }

    private void addSet(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("@Override", new Object[0]).addLine("public %1$s set(int index, %1$s element) {", this.element.builderType());
        BuildableList.convertToArrayList(code);
        code.addLine("  Object oldElement = elements.set(index, element);", new Object[0]).addLine("  if (oldElement instanceof %s) {", this.element.type().getQualifiedName());
        this.convertToBuilder("oldElement", code);
        code.addLine("  }", new Object[0]).addLine("  return (%s) oldElement;", this.element.builderType()).addLine("}", new Object[0]);
    }

    private void addAdd(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("@Override", new Object[0]).addLine("public void add(int index, %s element) {", this.element.builderType());
        BuildableList.convertToArrayList(code);
        code.addLine("  elements.add(index, element);", new Object[0]).addLine("}", new Object[0]);
    }

    private void addRemove(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("@Override", new Object[0]).addLine("public %s remove(int index) {", this.element.builderType());
        BuildableList.convertToArrayList(code);
        code.addLine("  Object oldElement = elements.remove(index);", new Object[0]).addLine("  if (oldElement instanceof %s) {", this.element.type().getQualifiedName());
        this.convertToBuilder("oldElement", code);
        code.addLine("  }", new Object[0]).addLine("  return (%s) oldElement;", this.element.builderType()).addLine("}", new Object[0]);
    }

    private static void addEnsureCapacity(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("void ensureCapacity(int minCapacity) {", new Object[0]);
        if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
            BuildableList.convertToArrayList(code);
            code.add("  ((%s) elements)", ArrayList.class);
        } else {
            code.add("  elements", new Object[0]);
        }
        code.add(".ensureCapacity(minCapacity);%n", new Object[0]).addLine("}", new Object[0]);
    }

    private void addAddValue(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("void addValue(%s element) {", this.element.type()).addLine("  %s.requireNonNull(element);", Objects.class);
        BuildableList.convertToArrayList(code);
        code.addLine("  elements.add(element);", new Object[0]).addLine("}", new Object[0]);
    }

    private void addAddAllValues(SourceBuilder code) {
        if (!code.feature(GuavaLibrary.GUAVA).isAvailable()) {
            return;
        }
        code.addLine("", new Object[0]).addLine("void addAllValues(%s<? extends %s> values) {", Iterable.class, this.element.type()).addLine("  if (elements.isEmpty() && values instanceof %s) {", ImmutableList.class).addLine("    elements = (%s) values;", ImmutableList.class).addLine("  } else {", new Object[0]);
        BuildableList.convertToArrayList(code);
        code.addLine("    if (values instanceof %s) {", Collection.class).addLine("      int newSize = elements.size() + ((%s) values).size();", Collection.class).addLine("      ((%s) elements).ensureCapacity(newSize);", ArrayList.class).addLine("    }", new Object[0]).addLine("    values.forEach(this::addValue);", new Object[0]).addLine("  }", new Object[0]).addLine("}", new Object[0]);
    }

    private void addBuild(SourceBuilder code, String buildMethod) {
        code.addLine("", new Object[0]);
        if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
            code.addLine("%s<%s> %s() {", ImmutableList.class, this.element.type(), buildMethod).addLine("  if (elements instanceof %s) {", ImmutableList.class).addLine("    return (%s<%s>) elements;", ImmutableList.class, this.element.type()).addLine("  }", new Object[0]).addLine("  %1$s.Builder<%2$s> values = %1$s.builder();", ImmutableList.class, this.element.type()).addLine("  for (Object element : elements) {", new Object[0]).addLine("    values.add(%s(element));", buildMethod).addLine("  }", new Object[0]).addLine("  return values.build();", new Object[0]);
        } else {
            code.addLine("%s<%s> %s() {", List.class, this.element.type(), buildMethod).addLine("  switch (elements.size()) {", new Object[0]).addLine("    case 0:", new Object[0]).addLine("      return %s.emptyList();", Collections.class).addLine("    case 1:", new Object[0]).addLine("      return %s.singletonList(%s(elements.get(0)));", Collections.class, buildMethod).addLine("    default:", new Object[0]).addLine("      Object[] values = new Object[elements.size()];", new Object[0]).addLine("      for (int i = 0; i < elements.size(); i++) {", new Object[0]).addLine("        values[i] = %s(elements.get(i));", buildMethod).addLine("      }", new Object[0]).addLine("      return (%1$s<%2$s>)(%1$s<?>)", List.class, this.element.type()).addLine("          %s.unmodifiableList(%s.asList(values));", Collections.class, Arrays.class).addLine("  }", new Object[0]);
        }
        code.addLine("}", new Object[0]).addLine("", new Object[0]).addLine("private %s %s(Object element) {", this.element.type(), buildMethod).addLine("  if (element instanceof %s) {", this.element.type().getQualifiedName()).addLine("    return (%s) element;", this.element.type()).addLine("  } else {", new Object[0]).addLine("    return ((%s) element).%s();", this.element.builderType(), buildMethod).addLine("  }", new Object[0]).addLine("}", new Object[0]);
    }

    private static void convertToArrayList(SourceBuilder code) {
        if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
            code.addLine("if (elements instanceof %s) {", ImmutableList.class).addLine("  elements = new %s(elements);", ArrayList.class).addLine("}", new Object[0]);
        }
    }

    @Override
    protected void addFields(ValueType.FieldReceiver fields) {
        fields.add("type", this.element);
    }

    private void convertToBuilder(String variable, SourceBuilder code) {
        if (this.element.partialToBuilder() == BuildableType.PartialToBuilderMethod.TO_BUILDER_AND_MERGE) {
            code.addLine("    %1$s = ((%2$s) %1$s).toBuilder();", variable, this.element.type());
        } else {
            code.addLine("    %1$s = %2$s.mergeFrom((%3$s) %1$s);", variable, this.element.builderFactory().newBuilder(this.element.builderType(), BuilderFactory.TypeInference.EXPLICIT_TYPES), this.element.type());
        }
    }
}

