/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.OutputArchive;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.proto.CreateRequest;
import org.apache.zookeeper.proto.GetDataRequest;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumZooKeeperServer;
import org.apache.zookeeper.server.quorum.UpgradeableSessionTracker;
import org.apache.zookeeper.test.QuorumBase;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiOpSessionUpgradeTest
extends QuorumBase {
    protected static final Logger LOG = LoggerFactory.getLogger(MultiOpSessionUpgradeTest.class);

    @Override
    public void setUp() throws Exception {
        this.localSessionsEnabled = true;
        this.localSessionsUpgradingEnabled = true;
        super.setUp();
    }

    @Test
    public void ephemeralCreateMultiOpTest() throws KeeperException, InterruptedException, IOException {
        TestableZooKeeper zk = this.createClient();
        String data = "test";
        String path = "/ephemeralcreatemultiop";
        zk.create(path, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        QuorumZooKeeperServer server = this.getConnectedServer(zk.getSessionId());
        Assert.assertNotNull((String)"unable to find server interlocutor", (Object)server);
        UpgradeableSessionTracker sessionTracker = (UpgradeableSessionTracker)server.getSessionTracker();
        Assert.assertFalse((String)"session already global", (boolean)sessionTracker.isGlobalSession(zk.getSessionId()));
        List multi = null;
        try {
            multi = zk.multi(Arrays.asList(Op.setData((String)path, (byte[])data.getBytes(), (int)0), Op.create((String)(path + "/e"), (byte[])data.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.EPHEMERAL), Op.create((String)(path + "/p"), (byte[])data.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.create((String)(path + "/q"), (byte[])data.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.EPHEMERAL)));
        }
        catch (KeeperException.SessionExpiredException e) {
            Assert.fail((String)"received session expired for a session promotion in a multi-op");
        }
        Assert.assertNotNull(multi);
        Assert.assertEquals((long)4L, (long)multi.size());
        Assert.assertEquals((Object)data, (Object)new String(zk.getData(path + "/e", false, null)));
        Assert.assertEquals((Object)data, (Object)new String(zk.getData(path + "/p", false, null)));
        Assert.assertEquals((Object)data, (Object)new String(zk.getData(path + "/q", false, null)));
        Assert.assertTrue((String)"session not promoted", (boolean)sessionTracker.isGlobalSession(zk.getSessionId()));
    }

    @Test
    public void directCheckUpgradeSessionTest() throws IOException, InterruptedException, KeeperException {
        TestableZooKeeper zk = this.createClient();
        String path = "/directcheckupgradesession";
        zk.create(path, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        QuorumZooKeeperServer server = this.getConnectedServer(zk.getSessionId());
        Assert.assertNotNull((String)"unable to find server interlocutor", (Object)server);
        Request readRequest = this.makeGetDataRequest(path, zk.getSessionId());
        Request createRequest = this.makeCreateRequest(path + "/e", zk.getSessionId());
        Assert.assertNull((String)"tried to upgrade on a read", (Object)server.checkUpgradeSession(readRequest));
        Assert.assertNotNull((String)"failed to upgrade on a create", (Object)server.checkUpgradeSession(createRequest));
        Assert.assertNull((String)"tried to upgrade after successful promotion", (Object)server.checkUpgradeSession(createRequest));
    }

    private Request makeGetDataRequest(String path, long sessionId) throws IOException {
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive((OutputStream)boas);
        GetDataRequest getDataRequest = new GetDataRequest(path, false);
        getDataRequest.serialize((OutputArchive)boa, "request");
        ByteBuffer bb = ByteBuffer.wrap(boas.toByteArray());
        return new Request(null, sessionId, 1, 4, bb, new ArrayList());
    }

    private Request makeCreateRequest(String path, long sessionId) throws IOException {
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive((OutputStream)boas);
        CreateRequest createRequest = new CreateRequest(path, "data".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL.toFlag());
        createRequest.serialize((OutputArchive)boa, "request");
        ByteBuffer bb = ByteBuffer.wrap(boas.toByteArray());
        return new Request(null, sessionId, 1, 15, bb, new ArrayList());
    }

    private QuorumZooKeeperServer getConnectedServer(long sessionId) {
        for (QuorumPeer peer : this.getPeerList()) {
            if (!peer.getActiveServer().getSessionTracker().isTrackingSession(sessionId)) continue;
            return (QuorumZooKeeperServer)peer.getActiveServer();
        }
        return null;
    }
}

