/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.ClientCnxn;
import org.apache.zookeeper.ClientCnxnSocket;
import org.apache.zookeeper.ClientCnxnSocketNIO;
import org.apache.zookeeper.ClientWatchManager;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.client.HostProvider;
import org.apache.zookeeper.client.ZKClientConfig;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ClientReconnectTest
extends ZKTestCase {
    private SocketChannel sc;
    private CountDownLatch countDownLatch = new CountDownLatch(3);

    @Test
    public void testClientReconnect() throws IOException, InterruptedException {
        HostProvider hostProvider = (HostProvider)Mockito.mock(HostProvider.class);
        Mockito.when((Object)hostProvider.size()).thenReturn((Object)1);
        InetSocketAddress inaddr = new InetSocketAddress("127.0.0.1", 1111);
        Mockito.when((Object)hostProvider.next(ArgumentMatchers.anyLong())).thenReturn((Object)inaddr);
        ZooKeeper zk = (ZooKeeper)Mockito.mock(ZooKeeper.class);
        Mockito.when((Object)zk.getClientConfig()).thenReturn((Object)new ZKClientConfig());
        this.sc = SocketChannel.open();
        MockCnxn nioCnxn = new MockCnxn();
        ClientWatchManager watcher = (ClientWatchManager)Mockito.mock(ClientWatchManager.class);
        ClientCnxn clientCnxn = new ClientCnxn("tmp", hostProvider, 5000, zk, watcher, (ClientCnxnSocket)nioCnxn, false);
        clientCnxn.start();
        this.countDownLatch.await(5000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((this.countDownLatch.getCount() == 0L ? 1 : 0) != 0);
        clientCnxn.close();
    }

    class MockCnxn
    extends ClientCnxnSocketNIO {
        MockCnxn() throws IOException {
            super(new ZKClientConfig());
        }

        void registerAndConnect(SocketChannel sock, InetSocketAddress addr) throws IOException {
            ClientReconnectTest.this.countDownLatch.countDown();
            throw new IOException("failed to register");
        }

        SocketChannel createSock() {
            return ClientReconnectTest.this.sc;
        }
    }
}

