/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.io;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.crypto.CipherOutputStream;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.StreamException;
import org.bouncycastle.crypto.internal.BufferedBlockCipher;
import org.bouncycastle.crypto.internal.StreamCipher;
import org.bouncycastle.crypto.internal.io.StreamIOException;
import org.bouncycastle.crypto.internal.io.Utils;
import org.bouncycastle.crypto.internal.modes.AEADBlockCipher;

public class CipherOutputStreamImpl
extends CipherOutputStream {
    private final String algorithmName;
    private final boolean isApprovedMode;
    private OutputStream out;
    private BufferedBlockCipher bufferedBlockCipher;
    private StreamCipher streamCipher;
    private AEADBlockCipher aeadBlockCipher;
    private final byte[] oneByte = new byte[1];
    private byte[] buf;

    public CipherOutputStreamImpl(OutputStream outputStream, BufferedBlockCipher bufferedBlockCipher) {
        this.isApprovedMode = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.algorithmName = bufferedBlockCipher.getUnderlyingCipher().getAlgorithmName();
        this.out = outputStream;
        this.bufferedBlockCipher = bufferedBlockCipher;
    }

    public CipherOutputStreamImpl(OutputStream outputStream, StreamCipher streamCipher) {
        this.isApprovedMode = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.algorithmName = streamCipher.getAlgorithmName();
        this.out = outputStream;
        this.streamCipher = streamCipher;
    }

    public CipherOutputStreamImpl(OutputStream outputStream, AEADBlockCipher aEADBlockCipher) {
        this.isApprovedMode = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.algorithmName = aEADBlockCipher.getAlgorithmName();
        this.out = outputStream;
        this.aeadBlockCipher = aEADBlockCipher;
    }

    public void write(int n) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.oneByte[0] = (byte)n;
        if (this.streamCipher != null) {
            this.out.write(this.streamCipher.returnByte((byte)n));
        } else {
            this.write(this.oneByte, 0, 1);
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.ensureCapacity(n2, false);
        if (this.bufferedBlockCipher != null) {
            int n3 = this.bufferedBlockCipher.processBytes(byArray, n, n2, this.buf, 0);
            if (n3 != 0) {
                this.out.write(this.buf, 0, n3);
            }
        } else if (this.aeadBlockCipher != null) {
            int n4 = this.aeadBlockCipher.processBytes(byArray, n, n2, this.buf, 0);
            if (n4 != 0) {
                this.out.write(this.buf, 0, n4);
            }
        } else {
            this.streamCipher.processBytes(byArray, n, n2, this.buf, 0);
            this.out.write(this.buf, 0, n2);
        }
    }

    private void ensureCapacity(int n, boolean bl) {
        int n2 = n;
        if (bl) {
            if (this.bufferedBlockCipher != null) {
                n2 = this.bufferedBlockCipher.getOutputSize(n);
            } else if (this.aeadBlockCipher != null) {
                n2 = this.aeadBlockCipher.getOutputSize(n);
            }
        } else if (this.bufferedBlockCipher != null) {
            n2 = this.bufferedBlockCipher.getUpdateOutputSize(n);
        } else if (this.aeadBlockCipher != null) {
            n2 = this.aeadBlockCipher.getUpdateOutputSize(n);
        }
        if (this.buf == null || this.buf.length < n2) {
            this.buf = new byte[n2];
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        IOException iOException;
        block14: {
            Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
            this.ensureCapacity(0, true);
            iOException = null;
            try {
                int n;
                if (this.bufferedBlockCipher != null) {
                    n = this.bufferedBlockCipher.doFinal(this.buf, 0);
                    if (n != 0) {
                        this.out.write(this.buf, 0, n);
                    }
                } else if (this.aeadBlockCipher != null) {
                    n = this.aeadBlockCipher.doFinal(this.buf, 0);
                    if (n != 0) {
                        this.out.write(this.buf, 0, n);
                    }
                } else if (this.streamCipher != null) {
                    this.streamCipher.reset();
                }
            }
            catch (org.bouncycastle.crypto.internal.InvalidCipherTextException invalidCipherTextException) {
                iOException = new InvalidCipherTextException("Error finalising cipher data: " + invalidCipherTextException.getMessage(), invalidCipherTextException);
            }
            catch (IllegalStateException illegalStateException) {
                iOException = new StreamException(illegalStateException.getMessage(), illegalStateException.getCause());
            }
            catch (Exception exception) {
                iOException = new StreamIOException("Error closing stream: ", exception);
            }
            try {
                this.flush();
            }
            catch (IOException iOException2) {
                if (iOException != null) break block14;
                iOException = iOException2;
            }
        }
        if (iOException != null) {
            throw iOException;
        }
    }
}

