/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.common;

import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.common.PathUtils;
import org.junit.Test;

public class PathUtilsTest
extends ZKTestCase {
    @Test
    public void testValidatePath_ValidPath() {
        PathUtils.validatePath((String)"/this is / a valid/path");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValidatePath_Null() {
        PathUtils.validatePath(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValidatePath_EmptyString() {
        PathUtils.validatePath((String)"");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValidatePath_NotAbsolutePath() {
        PathUtils.validatePath((String)"not/valid");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValidatePath_EndsWithSlash() {
        PathUtils.validatePath((String)"/ends/with/slash/");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValidatePath_ContainsNullCharacter() {
        PathUtils.validatePath((String)"/test\u0000");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValidatePath_DoubleSlash() {
        PathUtils.validatePath((String)"/double//slash");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValidatePath_SinglePeriod() {
        PathUtils.validatePath((String)"/single/./period");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValidatePath_DoublePeriod() {
        PathUtils.validatePath((String)"/double/../period");
    }

    @Test
    public void testValidatePath_NameContainingPeriod() {
        PathUtils.validatePath((String)"/name/with.period.");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValidatePath_0x01() {
        PathUtils.validatePath((String)"/test\u0001");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValidatePath_0x1F() {
        PathUtils.validatePath((String)"/test\u001f");
    }

    @Test
    public void testValidatePath_0x20() {
        PathUtils.validatePath((String)"/test ");
    }

    @Test
    public void testValidatePath_0x7e() {
        PathUtils.validatePath((String)"/test~");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValidatePath_0x7f() {
        PathUtils.validatePath((String)"/test\u007f");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValidatePath_0x9f() {
        PathUtils.validatePath((String)"/test\u009f");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValidatePath_ud800() {
        PathUtils.validatePath((String)"/test\ud800");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValidatePath_uf8ff() {
        PathUtils.validatePath((String)"/test\uf8ff");
    }

    @Test
    public void testValidatePath_HighestAllowableChar() {
        PathUtils.validatePath((String)"/test\uffef");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValidatePath_SupplementaryChar() {
        PathUtils.validatePath((String)"/test\ufff0");
    }
}

