/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bookkeeper.conf.ServerConfiguration;

public class SkipListArena {
    private AtomicReference<Chunk> curChunk = new AtomicReference();
    final int chunkSize;
    final int maxAlloc;

    public SkipListArena(ServerConfiguration cfg) {
        this.chunkSize = cfg.getSkipListArenaChunkSize();
        this.maxAlloc = cfg.getSkipListArenaMaxAllocSize();
        assert (this.maxAlloc <= this.chunkSize);
    }

    public MemorySlice allocateBytes(int size) {
        assert (size >= 0);
        if (size > this.maxAlloc) {
            return null;
        }
        Chunk c;
        int allocOffset;
        while ((allocOffset = (c = this.getCurrentChunk()).alloc(size)) == -1) {
            this.retireCurrentChunk(c);
        }
        return new MemorySlice(c.data, allocOffset);
    }

    private void retireCurrentChunk(Chunk c) {
        this.curChunk.compareAndSet(c, null);
    }

    private Chunk getCurrentChunk() {
        Chunk c;
        do {
            if ((c = this.curChunk.get()) == null) continue;
            return c;
        } while (!this.curChunk.compareAndSet(null, c = new Chunk(this.chunkSize)));
        c.init();
        return c;
    }

    public static class MemorySlice {
        private final byte[] data;
        private final int offset;

        private MemorySlice(byte[] data, int off) {
            this.data = data;
            this.offset = off;
        }

        public String toString() {
            return "Slice:capacity(" + this.data.length + "), offset(" + this.offset + ")";
        }

        byte[] getData() {
            return this.data;
        }

        int getOffset() {
            return this.offset;
        }
    }

    private static class Chunk {
        private byte[] data;
        private static final int UNINITIALIZED = -1;
        private static final int OOM = -2;
        private AtomicInteger nextFreeOffset = new AtomicInteger(-1);
        private AtomicInteger allocCount = new AtomicInteger();
        private final int size;

        private Chunk(int size) {
            this.size = size;
        }

        public void init() {
            assert (this.nextFreeOffset.get() == -1);
            try {
                this.data = new byte[this.size];
            }
            catch (OutOfMemoryError e) {
                boolean failInit = this.nextFreeOffset.compareAndSet(-1, -2);
                assert (failInit);
                throw e;
            }
            boolean okInit = this.nextFreeOffset.compareAndSet(-1, 0);
            assert (okInit);
        }

        public int alloc(int size) {
            int oldOffset;
            while (true) {
                if ((oldOffset = this.nextFreeOffset.get()) == -1) {
                    Thread.yield();
                    continue;
                }
                if (oldOffset == -2) {
                    return -1;
                }
                if (oldOffset + size > this.data.length) {
                    return -1;
                }
                if (this.nextFreeOffset.compareAndSet(oldOffset, oldOffset + size)) break;
            }
            this.allocCount.incrementAndGet();
            return oldOffset;
        }

        public String toString() {
            return "Chunk@" + System.identityHashCode(this) + ": used(" + this.allocCount.get() + "), free(" + (this.data.length - this.nextFreeOffset.get()) + ")";
        }
    }
}

