/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.Vote;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.FLETest;
import org.apache.zookeeper.test.QuorumBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FLERestartTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(FLETest.class);
    private int count;
    private Map<Long, QuorumPeer.QuorumServer> peers;
    private List<FLERestartThread> restartThreads;
    private File[] tmpdir;
    private int[] port;
    private Semaphore finish;

    int countVotes(HashSet<TestVote> hs, long id) {
        int counter = 0;
        for (TestVote v : hs) {
            if (v.leader != id) continue;
            ++counter;
        }
        return counter;
    }

    @Before
    public void setUp() throws Exception {
        this.count = 3;
        this.peers = new HashMap<Long, QuorumPeer.QuorumServer>(this.count);
        this.restartThreads = new ArrayList<FLERestartThread>(this.count);
        this.tmpdir = new File[this.count];
        this.port = new int[this.count];
        this.finish = new Semaphore(0);
    }

    @After
    public void tearDown() throws Exception {
        for (int i = 0; i < this.restartThreads.size(); ++i) {
            this.restartThreads.get((int)i).peer.getElectionAlg().shutdown();
        }
    }

    @Test
    public void testLERestart() throws Exception {
        int i;
        LOG.info("TestLE: {}, {}", (Object)this.getTestName(), (Object)this.count);
        for (i = 0; i < this.count; ++i) {
            this.peers.put(Long.valueOf(i), new QuorumPeer.QuorumServer((long)i, new InetSocketAddress("127.0.0.1", PortAssignment.unique()), new InetSocketAddress("127.0.0.1", PortAssignment.unique())));
            this.tmpdir[i] = ClientBase.createTmpDir();
            this.port[i] = PortAssignment.unique();
        }
        for (i = 0; i < this.count; ++i) {
            QuorumPeer peer = new QuorumPeer(this.peers, this.tmpdir[i], this.tmpdir[i], this.port[i], 3, (long)i, 1000, 2, 2, 2);
            peer.startLeaderElection();
            FLERestartThread thread = new FLERestartThread(peer, i);
            thread.start();
            this.restartThreads.add(thread);
        }
        LOG.info("Started threads {}", (Object)this.getTestName());
        for (i = 0; i < this.restartThreads.size(); ++i) {
            this.restartThreads.get(i).join(10000L);
            if (!this.restartThreads.get(i).isAlive()) continue;
            Assert.fail((String)"Threads didn't join");
        }
    }

    class FLERestartThread
    extends Thread {
        int i;
        QuorumPeer peer;
        int peerRound = 0;

        FLERestartThread(QuorumPeer peer, int i) {
            this.i = i;
            this.peer = peer;
            LOG.info("Constructor: {}", (Object)this.getName());
        }

        @Override
        public void run() {
            try {
                Vote v = null;
                while (true) {
                    this.peer.setPeerState(QuorumPeer.ServerState.LOOKING);
                    LOG.info("Going to call leader election again.");
                    v = this.peer.getElectionAlg().lookForLeader();
                    if (v == null) {
                        LOG.info("Thread {} got a null vote", (Object)this.i);
                        break;
                    }
                    this.peer.setCurrentVote(v);
                    LOG.info("Finished election: {}, {}", (Object)this.i, (Object)v.getId());
                    switch (this.i) {
                        case 0: {
                            if (this.peerRound == 0) {
                                LOG.info("First peer, shutting it down");
                                QuorumBase.shutdown(this.peer);
                                ((FLERestartThread)((FLERestartTest)FLERestartTest.this).restartThreads.get((int)this.i)).peer.getElectionAlg().shutdown();
                                this.peer = new QuorumPeer(FLERestartTest.this.peers, FLERestartTest.this.tmpdir[this.i], FLERestartTest.this.tmpdir[this.i], FLERestartTest.this.port[this.i], 3, (long)this.i, 1000, 2, 2, 2);
                                this.peer.startLeaderElection();
                                ++this.peerRound;
                                break;
                            }
                            FLERestartTest.this.finish.release(2);
                            return;
                        }
                        case 1: {
                            LOG.info("Second entering case");
                            FLERestartTest.this.finish.acquire();
                            LOG.info("Release");
                            return;
                        }
                        case 2: {
                            LOG.info("First peer, do nothing, just join");
                            FLERestartTest.this.finish.acquire();
                            LOG.info("Release");
                            return;
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static class TestVote {
        long leader;

        TestVote(int id, long leader) {
            this.leader = leader;
        }
    }
}

