/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import org.apache.bookkeeper.common.util.ReflectionUtils;
import org.apache.bookkeeper.feature.FeatureProvider;
import org.apache.bookkeeper.net.DNSToSwitchMapping;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.distributedlog.DistributedLogConstants;
import org.apache.distributedlog.LogSegmentMetadata;
import org.apache.distributedlog.bk.QuorumConfig;
import org.apache.distributedlog.feature.DefaultFeatureProvider;
import org.apache.distributedlog.net.DNSResolverForRacks;
import org.apache.distributedlog.net.DNSResolverForRows;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedLogConfiguration
extends CompositeConfiguration {
    static final Logger LOG = LoggerFactory.getLogger(DistributedLogConfiguration.class);
    private static ClassLoader defaultLoader = Thread.currentThread().getContextClassLoader();
    public static final String BKDL_ZK_ACL_ID = "zkAclId";
    public static final String BKDL_ZK_ACL_ID_DEFAULT;
    public static final String BKDL_ZK_SESSION_TIMEOUT_SECONDS = "zkSessionTimeoutSeconds";
    public static final int BKDL_ZK_SESSION_TIMEOUT_SECONDS_DEFAULT = 30;
    public static final String BKDL_ZK_REQUEST_RATE_LIMIT = "zkRequestRateLimit";
    public static final double BKDL_ZK_REQUEST_RATE_LIMIT_DEFAULT = 0.0;
    public static final String BKDL_ZK_NUM_RETRIES = "zkNumRetries";
    public static final int BKDL_ZK_NUM_RETRIES_DEFAULT = 3;
    public static final String BKDL_ZK_RETRY_BACKOFF_START_MILLIS = "zkRetryStartBackoffMillis";
    public static final int BKDL_ZK_RETRY_BACKOFF_START_MILLIS_DEFAULT = 5000;
    public static final String BKDL_ZK_RETRY_BACKOFF_MAX_MILLIS = "zkRetryMaxBackoffMillis";
    public static final int BKDL_ZK_RETRY_BACKOFF_MAX_MILLIS_DEFAULT = 30000;
    public static final String BKDL_ZKCLIENT_NUM_RETRY_THREADS = "zkcNumRetryThreads";
    public static final int BKDL_ZKCLIENT_NUM_RETRY_THREADS_DEFAULT = 1;
    public static final String BKDL_BKCLIENT_ZK_SESSION_TIMEOUT = "bkcZKSessionTimeoutSeconds";
    public static final int BKDL_BKCLIENT_ZK_SESSION_TIMEOUT_DEFAULT = 30;
    public static final String BKDL_BKCLIENT_ZK_REQUEST_RATE_LIMIT = "bkcZKRequestRateLimit";
    public static final double BKDL_BKCLIENT_ZK_REQUEST_RATE_LIMIT_DEFAULT = 0.0;
    public static final String BKDL_BKCLIENT_ZK_NUM_RETRIES = "bkcZKNumRetries";
    public static final int BKDL_BKCLIENT_ZK_NUM_RETRIES_DEFAULT = 3;
    public static final String BKDL_BKCLIENT_ZK_RETRY_BACKOFF_START_MILLIS = "bkcZKRetryStartBackoffMillis";
    public static final int BKDL_BKCLIENT_ZK_RETRY_BACKOFF_START_MILLIS_DEFAULT = 5000;
    public static final String BKDL_BKCLIENT_ZK_RETRY_BACKOFF_MAX_MILLIS = "bkcZKRetryMaxBackoffMillis";
    public static final int BKDL_BKCLIENT_ZK_RETRY_BACKOFF_MAX_MILLIS_DEFAULT = 30000;
    public static final String BKDL_BOOKKEEPER_ENSEMBLE_SIZE = "bkcEnsembleSize";
    public static final String BKDL_BOOKKEEPER_ENSEMBLE_SIZE_OLD = "ensemble-size";
    public static final int BKDL_BOOKKEEPER_ENSEMBLE_SIZE_DEFAULT = 3;
    public static final String BKDL_BOOKKEEPER_WRITE_QUORUM_SIZE = "bkcWriteQuorumSize";
    public static final String BKDL_BOOKKEEPER_WRITE_QUORUM_SIZE_OLD = "write-quorum-size";
    public static final int BKDL_BOOKKEEPER_WRITE_QUORUM_SIZE_DEFAULT = 3;
    public static final String BKDL_BOOKKEEPER_ACK_QUORUM_SIZE = "bkcAckQuorumSize";
    public static final String BKDL_BOOKKEEPER_ACK_QUORUM_SIZE_OLD = "ack-quorum-size";
    public static final int BKDL_BOOKKEEPER_ACK_QUORUM_SIZE_DEFAULT = 2;
    public static final String BKDL_ROW_AWARE_ENSEMBLE_PLACEMENT = "bkRowAwareEnsemblePlacement";
    public static final String BKDL_ROW_AWARE_ENSEMBLE_PLACEMENT_OLD = "row-aware-ensemble-placement";
    public static final boolean BKDL_ROW_AWARE_ENSEMBLE_PLACEMENT_DEFAULT = false;
    public static final String BKDL_ENSEMBLE_PLACEMENT_DNS_RESOLVER_CLASS = "bkEnsemblePlacementDnsResolverClass";
    public static final String BKDL_ENSEMBLE_PLACEMENT_DNS_RESOLVER_CLASS_DEFAULT;
    public static final String BKDL_BK_DNS_RESOLVER_OVERRIDES = "dnsResolverOverrides";
    public static final String BKDL_BK_DNS_RESOLVER_OVERRIDES_DEFAULT = "";
    public static final String BKDL_BOOKKEEPER_DIGEST_PW = "digestPw";
    public static final String BKDL_BOOKKEEPER_DIGEST_PW_DEFAULT = "";
    public static final String BKDL_BKCLIENT_NUM_IO_THREADS = "bkcNumIOThreads";
    public static final String BKDL_TIMEOUT_TIMER_TICK_DURATION_MS = "timerTickDuration";
    public static final long BKDL_TIMEOUT_TIMER_TICK_DURATION_MS_DEFAULT = 100L;
    public static final String BKDL_TIMEOUT_TIMER_NUM_TICKS = "timerNumTicks";
    public static final int BKDL_TIMEOUT_TIMER_NUM_TICKS_DEFAULT = 1024;
    public static final String BKDL_BKCLIENT_READ_TIMEOUT = "bkcReadTimeoutSeconds";
    public static final int BKDL_BKCLIENT_READ_TIMEOUT_DEFAULT = 10;
    public static final String BKDL_BKCLIENT_WRITE_TIMEOUT = "bkcWriteTimeoutSeconds";
    public static final int BKDL_BKCLIENT_WRITE_TIMEOUT_DEFAULT = 10;
    public static final String BKDL_BKCLIENT_NUM_WORKER_THREADS = "bkcNumWorkerThreads";
    public static final int BKDL_BKCLEINT_NUM_WORKER_THREADS_DEFAULT = 1;
    public static final String BKDL_NUM_WORKER_THREADS = "numWorkerThreads";
    public static final String BKDL_NUM_READAHEAD_WORKER_THREADS = "numReadAheadWorkerThreads";
    public static final String BKDL_NUM_LOCKSTATE_THREADS = "numLockStateThreads";
    public static final String BKDL_NUM_RESOURCE_RELEASE_THREADS = "numResourceReleaseThreads";
    public static final String BKDL_SCHEDULER_SHUTDOWN_TIMEOUT_MS = "schedulerShutdownTimeoutMs";
    public static final int BKDL_SCHEDULER_SHUTDOWN_TIMEOUT_MS_DEFAULT = 5000;
    public static final String BKDL_USE_DAEMON_THREAD = "useDaemonThread";
    public static final boolean BKDL_USE_DAEMON_THREAD_DEFAULT = false;
    public static final String BKDL_LEDGER_METADATA_LAYOUT_VERSION = "ledgerMetadataLayoutVersion";
    public static final String BKDL_LEDGER_METADATA_LAYOUT_VERSION_OLD = "ledger-metadata-layout";
    public static final int BKDL_LEDGER_METADATA_LAYOUT_VERSION_DEFAULT;
    public static final String BKDL_LEDGER_METADATA_SKIP_MIN_VERSION_CHECK = "ledgerMetadataSkipMinVersionCheck";
    public static final boolean BKDL_LEDGER_METADATA_SKIP_MIN_VERSION_CHECK_DEFAULT = false;
    public static final String BKDL_FIRST_LOGSEGMENT_SEQUENCE_NUMBER = "firstLogsegmentSequenceNumber";
    public static final String BKDL_FIRST_LOGSEGMENT_SEQUENCE_NUMBER_OLD = "first-logsegment-sequence-number";
    public static final long BKDL_FIRST_LOGSEGMENT_SEQUENCE_NUMBER_DEFAULT = 1L;
    public static final String BKDL_LOGSEGMENT_SEQUENCE_NUMBER_VALIDATION_ENABLED = "logSegmentSequenceNumberValidationEnabled";
    public static final boolean BKDL_LOGSEGMENT_SEQUENCE_NUMBER_VALIDATION_ENABLED_DEFAULT = true;
    public static final String BKDL_ENABLE_RECORD_COUNTS = "enableRecordCounts";
    public static final boolean BKDL_ENABLE_RECORD_COUNTS_DEFAULT = true;
    public static final String BKDL_MAXID_SANITYCHECK = "maxIdSanityCheck";
    public static final boolean BKDL_MAXID_SANITYCHECK_DEFAULT = true;
    public static final String BKDL_ENCODE_REGION_ID_IN_VERSION = "encodeRegionIDInVersion";
    public static final boolean BKDL_ENCODE_REGION_ID_IN_VERSION_DEFAULT = false;
    public static final String BKDL_LOGSEGMENT_NAME_VERSION = "logSegmentNameVersion";
    public static final int BKDL_LOGSEGMENT_NAME_VERSION_DEFAULT = 1;
    public static final String BKDL_UNPARTITIONED_STREAM_NAME = "unpartitionedStreamName";
    public static final String BKDL_UNPARTITIONED_STREAM_NAME_DEFAULT = "<default>";
    public static final String BKDL_LOGSEGMENT_CACHE_TTL_MS = "logSegmentCacheTTLMs";
    public static final long BKDL_LOGSEGMENT_CACHE_TTL_MS_DEFAULT = 600000L;
    public static final String BKDL_LOGSEGMENT_CACHE_MAX_SIZE = "logSegmentCacheMaxSize";
    public static final long BKDL_LOGSEGMENT_CACHE_MAX_SIZE_DEFAULT = 10000L;
    public static final String BKDL_LOGSEGMENT_CACHE_ENABLED = "logSegmentCacheEnabled";
    public static final boolean BKDL_LOGSEGMENT_CACHE_ENABLED_DEFAULT = true;
    public static final String BKDL_CREATE_STREAM_IF_NOT_EXISTS = "createStreamIfNotExists";
    public static final boolean BKDL_CREATE_STREAM_IF_NOT_EXISTS_DEFAULT = true;
    public static final String BKDL_LOG_FLUSH_TIMEOUT = "logFlushTimeoutSeconds";
    public static final int BKDL_LOG_FLUSH_TIMEOUT_DEFAULT = 30;
    public static final String BKDL_COMPRESSION_TYPE = "compressionType";
    public static final String BKDL_COMPRESSION_TYPE_DEFAULT = "none";
    public static final String BKDL_FAILFAST_ON_STREAM_NOT_READY = "failFastOnStreamNotReady";
    public static final boolean BKDL_FAILFAST_ON_STREAM_NOT_READY_DEFAULT = false;
    public static final String BKDL_DISABLE_ROLLING_ON_LOG_SEGMENT_ERROR = "disableRollingOnLogSegmentError";
    public static final boolean BKDL_DISABLE_ROLLING_ON_LOG_SEGMENT_ERROR_DEFAULT = false;
    public static final String BKDL_IS_DURABLE_WRITE_ENABLED = "isDurableWriteEnabled";
    public static final boolean BKDL_IS_DURABLE_WRITE_ENABLED_DEFAULT = true;
    public static final String BKDL_OUTPUT_BUFFER_SIZE = "writerOutputBufferSize";
    public static final String BKDL_OUTPUT_BUFFER_SIZE_OLD = "output-buffer-size";
    public static final int BKDL_OUTPUT_BUFFER_SIZE_DEFAULT = 1024;
    public static final String BKDL_PERIODIC_FLUSH_FREQUENCY_MILLISECONDS = "periodicFlushFrequencyMilliSeconds";
    public static final int BKDL_PERIODIC_FLUSH_FREQUENCY_MILLISECONDS_DEFAULT = 0;
    public static final String BKDL_ENABLE_IMMEDIATE_FLUSH = "enableImmediateFlush";
    public static final boolean BKDL_ENABLE_IMMEDIATE_FLUSH_DEFAULT = false;
    public static final String BKDL_MINIMUM_DELAY_BETWEEN_IMMEDIATE_FLUSH_MILLISECONDS = "minimumDelayBetweenImmediateFlushMilliSeconds";
    public static final int BKDL_MINIMUM_DELAY_BETWEEN_IMMEDIATE_FLUSH_MILLISECONDS_DEFAULT = 0;
    public static final String BKDL_PERIODIC_KEEP_ALIVE_MILLISECONDS = "periodicKeepAliveMilliSeconds";
    public static final int BKDL_PERIODIC_KEEP_ALIVE_MILLISECONDS_DEFAULT = 0;
    public static final String BKDL_RETENTION_PERIOD_IN_HOURS = "logSegmentRetentionHours";
    public static final String BKDL_RETENTION_PERIOD_IN_HOURS_OLD = "retention-size";
    public static final int BKDL_RETENTION_PERIOD_IN_HOURS_DEFAULT = 72;
    public static final String BKDL_EXPLICIT_TRUNCATION_BY_APPLICATION = "explicitTruncationByApp";
    public static final boolean BKDL_EXPLICIT_TRUNCATION_BY_APPLICATION_DEFAULT = false;
    public static final String BKDL_ROLLING_INTERVAL_IN_MINUTES = "logSegmentRollingMinutes";
    public static final String BKDL_ROLLING_INTERVAL_IN_MINUTES_OLD = "rolling-interval";
    public static final int BKDL_ROLLING_INTERVAL_IN_MINUTES_DEFAULT = 120;
    public static final String BKDL_MAX_LOGSEGMENT_BYTES = "maxLogSegmentBytes";
    public static final int BKDL_MAX_LOGSEGMENT_BYTES_DEFAULT = 0x10000000;
    public static final String BKDL_LOGSEGMENT_ROLLING_CONCURRENCY = "logSegmentRollingConcurrency";
    public static final int BKDL_LOGSEGMENT_ROLLING_CONCURRENCY_DEFAULT = 1;
    public static final String BKDL_WRITE_LOCK_ENABLED = "writeLockEnabled";
    public static final boolean BKDL_WRITE_LOCK_ENABLED_DEFAULT = true;
    public static final String BKDL_LOCK_TIMEOUT = "lockTimeoutSeconds";
    public static final long BKDL_LOCK_TIMEOUT_DEFAULT = 30L;
    public static final String BKDL_LOCK_REACQUIRE_TIMEOUT = "lockReacquireTimeoutSeconds";
    public static final long BKDL_LOCK_REACQUIRE_TIMEOUT_DEFAULT = 120L;
    public static final String BKDL_LOCK_OP_TIMEOUT = "lockOpTimeoutSeconds";
    public static final long BKDL_LOCK_OP_TIMEOUT_DEFAULT = 120L;
    public static final String BKDL_ENABLE_LEDGER_ALLOCATOR_POOL = "enableLedgerAllocatorPool";
    public static final boolean BKDL_ENABLE_LEDGER_ALLOCATOR_POOL_DEFAULT = false;
    public static final String BKDL_LEDGER_ALLOCATOR_POOL_PATH = "ledgerAllocatorPoolPath";
    public static final String BKDL_LEDGER_ALLOCATOR_POOL_PATH_DEFAULT = ".allocation_pool";
    public static final String BKDL_LEDGER_ALLOCATOR_POOL_NAME = "ledgerAllocatorPoolName";
    public static final String BKDL_LEDGER_ALLOCATOR_POOL_NAME_DEFAULT;
    public static final String BKDL_LEDGER_ALLOCATOR_POOL_CORE_SIZE = "ledgerAllocatorPoolCoreSize";
    public static final int BKDL_LEDGER_ALLOCATOR_POOL_CORE_SIZE_DEFAULT = 20;
    public static final String BKDL_PER_WRITER_OUTSTANDING_WRITE_LIMIT = "perWriterOutstandingWriteLimit";
    public static final int BKDL_PER_WRITER_OUTSTANDING_WRITE_LIMIT_DEFAULT = -1;
    public static final String BKDL_GLOBAL_OUTSTANDING_WRITE_LIMIT = "globalOutstandingWriteLimit";
    public static final int BKDL_GLOBAL_OUTSTANDING_WRITE_LIMIT_DEFAULT = -1;
    public static final String BKDL_OUTSTANDING_WRITE_LIMIT_DARKMODE = "outstandingWriteLimitDarkmode";
    public static final boolean BKDL_OUTSTANDING_WRITE_LIMIT_DARKMODE_DEFAULT = true;
    public static final String BKDL_READLAC_OPTION = "readLACLongPoll";
    public static final int BKDL_READLAC_OPTION_DEFAULT = 3;
    public static final String BKDL_READLACLONGPOLL_TIMEOUT = "readLACLongPollTimeout";
    public static final int BKDL_READLACLONGPOLL_TIMEOUT_DEFAULT = 1000;
    public static final String BKDL_DESERIALIZE_RECORDSET_ON_READS = "deserializeRecordSetOnReads";
    public static final boolean BKDL_DESERIALIZE_RECORDSET_ON_READS_DEFAULT = true;
    public static final String BKDL_READER_IDLE_WARN_THRESHOLD_MILLIS = "readerIdleWarnThresholdMillis";
    public static final int BKDL_READER_IDLE_WARN_THRESHOLD_MILLIS_DEFAULT = 120000;
    public static final String BKDL_READER_IDLE_ERROR_THRESHOLD_MILLIS = "readerIdleErrorThresholdMillis";
    public static final int BKDL_READER_IDLE_ERROR_THRESHOLD_MILLIS_DEFAULT = Integer.MAX_VALUE;
    public static final String BKDL_READER_IGNORE_TRUNCATION_STATUS = "ignoreTruncationStatus";
    public static final boolean BKDL_READER_IGNORE_TRUNCATION_STATUS_DEFAULT = false;
    public static final String BKDL_READER_ALERT_POSITION_ON_TRUNCATED = "alertPositionOnTruncated";
    public static final boolean BKDL_READER_ALERT_POSITION_ON_TRUNCATED_DEFAULT = true;
    public static final String BKDL_READER_POSITION_GAP_DETECTION_ENABLED = "positionGapDetectionEnabled";
    public static final boolean BKDL_READER_POSITION_GAP_DETECTION_ENABLED_DEFAULT = false;
    public static final String BKDL_ENABLE_READAHEAD = "enableReadAhead";
    public static final boolean BKDL_ENABLE_READAHEAD_DEFAULT = true;
    public static final String BKDL_ENABLE_FORCEREAD = "enableForceRead";
    public static final boolean BKDL_ENABLE_FORCEREAD_DEFAULT = true;
    public static final String BKDL_READAHEAD_MAX_RECORDS = "readAheadMaxRecords";
    public static final String BKDL_READAHEAD_MAX_RECORDS_OLD = "ReadAheadMaxEntries";
    public static final int BKDL_READAHEAD_MAX_RECORDS_DEFAULT = 10;
    public static final String BKDL_READAHEAD_BATCHSIZE = "readAheadBatchSize";
    public static final String BKDL_READAHEAD_BATCHSIZE_OLD = "ReadAheadBatchSize";
    public static final int BKDL_READAHEAD_BATCHSIZE_DEFAULT = 2;
    public static final String BKDL_READAHEAD_WAITTIME = "readAheadWaitTime";
    public static final String BKDL_READAHEAD_WAITTIME_OLD = "ReadAheadWaitTime";
    public static final int BKDL_READAHEAD_WAITTIME_DEFAULT = 200;
    public static final String BKDL_READAHEAD_WAITTIME_ON_ENDOFSTREAM = "readAheadWaitTimeOnEndOfStream";
    public static final String BKDL_READAHEAD_WAITTIME_ON_ENDOFSTREAM_OLD = "ReadAheadWaitTimeOnEndOfStream";
    public static final int BKDL_READAHEAD_WAITTIME_ON_ENDOFSTREAM_DEFAULT = 10000;
    public static final String BKDL_READAHEAD_NOSUCHLEDGER_EXCEPTION_ON_READLAC_ERROR_THRESHOLD_MILLIS = "readAheadNoSuchLedgerExceptionOnReadLACErrorThresholdMillis";
    public static final int BKDL_READAHEAD_NOSUCHLEDGER_EXCEPTION_ON_READLAC_ERROR_THRESHOLD_MILLIS_DEFAULT = 10000;
    public static final String BKDL_READAHEAD_SKIP_BROKEN_ENTRIES = "readAheadSkipBrokenEntries";
    public static final boolean BKDL_READAHEAD_SKIP_BROKEN_ENTRIES_DEFAULT = false;
    public static final String BKDL_NUM_PREFETCH_ENTRIES_PER_LOGSEGMENT = "numPrefetchEntriesPerLogSegment";
    public static final int BKDL_NUM_PREFETCH_ENTRIES_PER_LOGSEGMENT_DEFAULT = 4;
    public static final String BKDL_MAX_PREFETCH_ENTRIES_PER_LOGSEGMENT = "maxPrefetchEntriesPerLogSegment";
    public static final int BKDL_MAX_PREFETCH_ENTRIES_PER_LOGSEGMENT_DEFAULT = 32;
    public static final String BKDL_FIRST_NUM_ENTRIES_PER_READ_LAST_RECORD_SCAN = "firstNumEntriesEachPerLastRecordScan";
    public static final int BKDL_FIRST_NUM_ENTRIES_PER_READ_LAST_RECORD_SCAN_DEFAULT = 2;
    public static final String BKDL_MAX_NUM_ENTRIES_PER_READ_LAST_RECORD_SCAN = "maxNumEntriesPerReadLastRecordScan";
    public static final int BKDL_MAX_NUM_ENTRIES_PER_READ_LAST_RECORD_SCAN_DEFAULT = 16;
    public static final String BKDL_CHECK_LOG_EXISTENCE_BACKOFF_START_MS = "checkLogExistenceBackoffStartMillis";
    public static final int BKDL_CHECK_LOG_EXISTENCE_BACKOFF_START_MS_DEFAULT = 200;
    public static final String BKDL_CHECK_LOG_EXISTENCE_BACKOFF_MAX_MS = "checkLogExistenceBackoffMaxMillis";
    public static final int BKDL_CHECK_LOG_EXISTENCE_BACKOFF_MAX_MS_DEFAULT = 1000;
    public static final String BKDL_TRACE_READAHEAD_DELIVERY_LATENCY = "traceReadAheadDeliveryLatency";
    public static final boolean BKDL_TRACE_READAHEAD_DELIVERY_LATENCY_DEFAULT = false;
    public static final String BKDL_METADATA_LATENCY_WARN_THRESHOLD_MS = "metadataLatencyWarnThresholdMs";
    public static final long BKDL_METADATA_LATENCY_WARN_THRESHOLD_MS_DEFAULT;
    public static final String BKDL_DATA_LATENCY_WARN_THRESHOLD_MS = "dataLatencyWarnThresholdMs";
    public static final long BKDL_DATA_LATENCY_WARN_THRESHOLD_MS_DEFAULT;
    public static final String BKDL_TRACE_READAHEAD_METADATA_CHANGES = "traceReadAheadMetadataChanges";
    public static final boolean BKDL_TRACE_READAHEAD_MEATDATA_CHANGES_DEFAULT = false;
    public static final String BKDL_ENABLE_TASK_EXECUTION_STATS = "enableTaskExecutionStats";
    public static final boolean BKDL_ENABLE_TASK_EXECUTION_STATS_DEFAULT = false;
    public static final String BKDL_TASK_EXECUTION_WARN_TIME_MICROS = "taskExecutionWarnTimeMicros";
    public static final long BKDL_TASK_EXECUTION_WARN_TIME_MICROS_DEFAULT = 100000L;
    public static final String BKDL_ENABLE_PERSTREAM_STAT = "enablePerStreamStat";
    public static final boolean BKDL_ENABLE_PERSTREAM_STAT_DEFAULT = false;
    public static final String BKDL_FEATURE_PROVIDER_CLASS = "featureProviderClass";
    public static final String BKDL_FILE_FEATURE_PROVIDER_BASE_CONFIG_PATH = "fileFeatureProviderBaseConfigPath";
    public static final String BKDL_FILE_FEATURE_PROVIDER_BASE_CONFIG_PATH_DEFAULT = "decider.conf";
    public static final String BKDL_FILE_FEATURE_PROVIDER_OVERLAY_CONFIG_PATH = "fileFeatureProviderOverlayConfigPath";
    public static final String BKDL_FILE_FEATURE_PROVIDER_OVERLAY_CONFIG_PATH_DEFAULT;
    public static final String BKDL_FEDERATED_NAMESPACE_ENABLED = "federatedNamespaceEnabled";
    public static final boolean BKDL_FEDERATED_NAMESPACE_ENABLED_DEFAULT = false;
    public static final String BKDL_FEDERATED_MAX_LOGS_PER_SUBNAMESPACE = "federatedMaxLogsPerSubnamespace";
    public static final int BKDL_FEDERATED_MAX_LOGS_PER_SUBNAMESPACE_DEFAULT = 15000;
    public static final String BKDL_FEDERATED_CHECK_EXISTENCE_WHEN_CACHE_MISS = "federatedCheckExistenceWhenCacheMiss";
    public static final boolean BKDL_FEDERATED_CHECK_EXISTENCE_WHEN_CACHE_MISS_DEFAULT = true;
    public static final String BKDL_DYNAMIC_CONFIG_RELOAD_INTERVAL_SEC = "dynamicConfigReloadIntervalSec";
    public static final int BKDL_DYNAMIC_CONFIG_RELOAD_INTERVAL_SEC_DEFAULT = 60;
    public static final String BKDL_STREAM_CONFIG_ROUTER_CLASS = "streamConfigRouterClass";
    public static final String BKDL_STREAM_CONFIG_ROUTER_CLASS_DEFAULT = "org.apache.distributedlog.service.config.IdentityConfigRouter";
    public static final String BKDL_BPS_SOFT_WRITE_LIMIT = "bpsSoftWriteLimit";
    public static final int BKDL_BPS_SOFT_WRITE_LIMIT_DEFAULT = -1;
    public static final String BKDL_BPS_HARD_WRITE_LIMIT = "bpsHardWriteLimit";
    public static final int BKDL_BPS_HARD_WRITE_LIMIT_DEFAULT = -1;
    public static final String BKDL_RPS_SOFT_WRITE_LIMIT = "rpsSoftWriteLimit";
    public static final int BKDL_RPS_SOFT_WRITE_LIMIT_DEFAULT = -1;
    public static final String BKDL_RPS_HARD_WRITE_LIMIT = "rpsHardWriteLimit";
    public static final int BKDL_RPS_HARD_WRITE_LIMIT_DEFAULT = -1;
    public static final String BKDL_RPS_SOFT_SERVICE_LIMIT = "rpsSoftServiceLimit";
    public static final int BKDL_RPS_SOFT_SERVICE_LIMIT_DEFAULT = -1;
    public static final String BKDL_RPS_HARD_SERVICE_LIMIT = "rpsHardServiceLimit";
    public static final int BKDL_RPS_HARD_SERVICE_LIMIT_DEFAULT = -1;
    public static final String BKDL_RPS_STREAM_ACQUIRE_SERVICE_LIMIT = "rpsStreamAcquireServiceLimit";
    public static final int BKDL_RPS_STREAM_ACQUIRE_SERVICE_LIMIT_DEFAULT = -1;
    public static final String BKDL_BPS_SOFT_SERVICE_LIMIT = "bpsSoftServiceLimit";
    public static final int BKDL_BPS_SOFT_SERVICE_LIMIT_DEFAULT = -1;
    public static final String BKDL_BPS_HARD_SERVICE_LIMIT = "bpsHardServiceLimit";
    public static final int BKDL_BPS_HARD_SERVICE_LIMIT_DEFAULT = -1;
    public static final String BKDL_BPS_STREAM_ACQUIRE_SERVICE_LIMIT = "bpsStreamAcquireServiceLimit";
    public static final int BKDL_BPS_STREAM_ACQUIRE_SERVICE_LIMIT_DEFAULT = -1;
    public static final String BKDL_MAX_ACQUIRED_PARTITIONS_PER_PROXY = "maxAcquiredPartitionsPerProxy";
    public static final int BKDL_MAX_ACQUIRED_PARTITIONS_PER_PROXY_DEFAULT = -1;
    public static final String BKDL_MAX_CACHED_PARTITIONS_PER_PROXY = "maxCachedPartitionsPerProxy";
    public static final int BKDL_MAX_CACHED_PARTITIONS_PER_PROXY_DEFAULT = -1;
    public static final String BKDL_EI_INJECT_WRITE_DELAY = "eiInjectWriteDelay";
    public static final boolean BKDL_EI_INJECT_WRITE_DELAY_DEFAULT = false;
    public static final String BKDL_EI_INJECTED_WRITE_DELAY_PERCENT = "eiInjectedWriteDelayPercent";
    public static final double BKDL_EI_INJECTED_WRITE_DELAY_PERCENT_DEFAULT = 0.0;
    public static final String BKDL_EI_INJECTED_WRITE_DELAY_MS = "eiInjectedWriteDelayMs";
    public static final int BKDL_EI_INJECTED_WRITE_DELAY_MS_DEFAULT = 0;
    public static final String BKDL_EI_INJECT_READAHEAD_STALL = "eiInjectReadAheadStall";
    public static final boolean BKDL_EI_INJECT_READAHEAD_STALL_DEFAULT = false;
    public static final String BKDL_EI_INJECT_READAHEAD_DELAY = "eiInjectReadAheadDelay";
    public static final boolean BKDL_EI_INJECT_READAHEAD_DELAY_DEFAULT = false;
    public static final String BKDL_EI_INJECT_MAX_READAHEAD_DELAY_MS = "eiInjectMaxReadAheadDelayMs";
    public static final int BKDL_EI_INJECT_MAX_READAHEAD_DELAY_MS_DEFAULT = 0;
    public static final String BKDL_EI_INJECT_READAHEAD_DELAY_PERCENT = "eiInjectReadAheadDelayPercent";
    public static final int BKDL_EI_INJECT_READAHEAD_DELAY_PERCENT_DEFAULT = 10;
    public static final String BKDL_EI_INJECT_READAHEAD_BROKEN_ENTRIES = "eiInjectReadAheadBrokenEntries";
    public static final boolean BKDL_EI_INJECT_READAHEAD_BROKEN_ENTRIES_DEFAULT = false;
    private static final Set<String> streamSettings;

    public DistributedLogConfiguration() {
        this.addConfiguration((Configuration)new SystemConfiguration());
    }

    public void loadConf(URL confURL) throws ConfigurationException {
        PropertiesConfiguration loadedConf = new PropertiesConfiguration(confURL);
        this.addConfiguration((Configuration)loadedConf);
    }

    public void loadConf(DistributedLogConfiguration baseConf) {
        Iterator iter = baseConf.getKeys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            this.setProperty(key, baseConf.getProperty(key));
        }
    }

    public void loadConf(Configuration baseConf) {
        Iterator iter = baseConf.getKeys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            this.setProperty(key, baseConf.getProperty(key));
        }
    }

    public void loadStreamConf(Optional<DistributedLogConfiguration> streamConfiguration) {
        if (!streamConfiguration.isPresent()) {
            return;
        }
        ArrayList ignoredSettings = new ArrayList();
        Iterator iterator = streamConfiguration.get().getKeys();
        while (iterator.hasNext()) {
            Object setting = iterator.next();
            if (setting instanceof String && streamSettings.contains(setting)) {
                String settingStr = (String)setting;
                this.setProperty(settingStr, streamConfiguration.get().getProperty(settingStr));
                continue;
            }
            ignoredSettings.add(setting);
        }
        if (LOG.isWarnEnabled() && !ignoredSettings.isEmpty()) {
            LOG.warn("invalid stream configuration override(s): {}", (Object)StringUtils.join(ignoredSettings, (String)";"));
        }
    }

    public String getPropsAsString() {
        Iterator iterator = this.getKeys();
        StringBuilder builder = new StringBuilder();
        boolean appendNewline = false;
        while (iterator.hasNext()) {
            Object key = iterator.next();
            if (!(key instanceof String)) continue;
            if (appendNewline) {
                builder.append("\n");
            }
            Object value = this.getProperty((String)key);
            builder.append(key).append("=").append(value);
            appendNewline = true;
        }
        return builder.toString();
    }

    public String getZkAclId() {
        return this.getString(BKDL_ZK_ACL_ID, BKDL_ZK_ACL_ID_DEFAULT);
    }

    public DistributedLogConfiguration setZkAclId(String zkAclId) {
        this.setProperty(BKDL_ZK_ACL_ID, zkAclId);
        return this;
    }

    public int getZKSessionTimeoutSeconds() {
        return this.getInt(BKDL_ZK_SESSION_TIMEOUT_SECONDS, 30);
    }

    public int getZKSessionTimeoutMilliseconds() {
        return this.getInt(BKDL_ZK_SESSION_TIMEOUT_SECONDS, 30) * 1000;
    }

    public DistributedLogConfiguration setZKSessionTimeoutSeconds(int zkSessionTimeoutSeconds) {
        this.setProperty(BKDL_ZK_SESSION_TIMEOUT_SECONDS, zkSessionTimeoutSeconds);
        return this;
    }

    public double getZKRequestRateLimit() {
        return this.getDouble(BKDL_ZK_REQUEST_RATE_LIMIT, 0.0);
    }

    public DistributedLogConfiguration setZKRequestRateLimit(double requestRateLimit) {
        this.setProperty(BKDL_ZK_REQUEST_RATE_LIMIT, requestRateLimit);
        return this;
    }

    public int getZKNumRetries() {
        return this.getInt(BKDL_ZK_NUM_RETRIES, 3);
    }

    public DistributedLogConfiguration setZKNumRetries(int zkNumRetries) {
        this.setProperty(BKDL_ZK_NUM_RETRIES, zkNumRetries);
        return this;
    }

    public int getZKRetryBackoffStartMillis() {
        return this.getInt(BKDL_ZK_RETRY_BACKOFF_START_MILLIS, 5000);
    }

    public DistributedLogConfiguration setZKRetryBackoffStartMillis(int zkRetryBackoffStartMillis) {
        this.setProperty(BKDL_ZK_RETRY_BACKOFF_START_MILLIS, zkRetryBackoffStartMillis);
        return this;
    }

    public int getZKRetryBackoffMaxMillis() {
        return this.getInt(BKDL_ZK_RETRY_BACKOFF_MAX_MILLIS, 30000);
    }

    public DistributedLogConfiguration setZKRetryBackoffMaxMillis(int zkRetryBackoffMaxMillis) {
        this.setProperty(BKDL_ZK_RETRY_BACKOFF_MAX_MILLIS, zkRetryBackoffMaxMillis);
        return this;
    }

    public int getZKClientNumberRetryThreads() {
        return this.getInt(BKDL_ZKCLIENT_NUM_RETRY_THREADS, 1);
    }

    public DistributedLogConfiguration setZKClientNumberRetryThreads(int numThreads) {
        this.setProperty(BKDL_ZKCLIENT_NUM_RETRY_THREADS, numThreads);
        return this;
    }

    public int getBKClientZKSessionTimeoutMilliSeconds() {
        return this.getInt(BKDL_BKCLIENT_ZK_SESSION_TIMEOUT, 30) * 1000;
    }

    public DistributedLogConfiguration setBKClientZKSessionTimeout(int sessionTimeout) {
        this.setProperty(BKDL_BKCLIENT_ZK_SESSION_TIMEOUT, sessionTimeout);
        return this;
    }

    public double getBKClientZKRequestRateLimit() {
        return this.getDouble(BKDL_BKCLIENT_ZK_REQUEST_RATE_LIMIT, 0.0);
    }

    public DistributedLogConfiguration setBKClientZKRequestRateLimit(double rateLimit) {
        this.setProperty(BKDL_BKCLIENT_ZK_REQUEST_RATE_LIMIT, rateLimit);
        return this;
    }

    public int getBKClientZKNumRetries() {
        int zkNumRetries = this.getInt(BKDL_BKCLIENT_ZK_NUM_RETRIES, 3);
        if (zkNumRetries <= 0) {
            return Integer.MAX_VALUE;
        }
        return zkNumRetries;
    }

    public int getBKClientZKRetryBackoffStartMillis() {
        return this.getInt(BKDL_BKCLIENT_ZK_RETRY_BACKOFF_START_MILLIS, 5000);
    }

    public int getBKClientZKRetryBackoffMaxMillis() {
        return this.getInt(BKDL_BKCLIENT_ZK_RETRY_BACKOFF_MAX_MILLIS, 30000);
    }

    public int getEnsembleSize() {
        return this.getInt(BKDL_BOOKKEEPER_ENSEMBLE_SIZE, this.getInt(BKDL_BOOKKEEPER_ENSEMBLE_SIZE_OLD, 3));
    }

    public DistributedLogConfiguration setEnsembleSize(int ensembleSize) {
        this.setProperty(BKDL_BOOKKEEPER_ENSEMBLE_SIZE, ensembleSize);
        return this;
    }

    public int getWriteQuorumSize() {
        return this.getInt(BKDL_BOOKKEEPER_WRITE_QUORUM_SIZE, this.getInt(BKDL_BOOKKEEPER_WRITE_QUORUM_SIZE_OLD, 3));
    }

    public DistributedLogConfiguration setWriteQuorumSize(int quorumSize) {
        this.setProperty(BKDL_BOOKKEEPER_WRITE_QUORUM_SIZE, quorumSize);
        return this;
    }

    public int getAckQuorumSize() {
        return this.getInt(BKDL_BOOKKEEPER_ACK_QUORUM_SIZE, this.getInt(BKDL_BOOKKEEPER_ACK_QUORUM_SIZE_OLD, 2));
    }

    public DistributedLogConfiguration setAckQuorumSize(int quorumSize) {
        this.setProperty(BKDL_BOOKKEEPER_ACK_QUORUM_SIZE, quorumSize);
        return this;
    }

    public QuorumConfig getQuorumConfig() {
        return new QuorumConfig(this.getEnsembleSize(), this.getWriteQuorumSize(), this.getAckQuorumSize());
    }

    public boolean getRowAwareEnsemblePlacementEnabled() {
        return this.getBoolean(BKDL_ROW_AWARE_ENSEMBLE_PLACEMENT, this.getBoolean(BKDL_ROW_AWARE_ENSEMBLE_PLACEMENT_OLD, false));
    }

    public DistributedLogConfiguration setRowAwareEnsemblePlacementEnabled(boolean enableRowAwareEnsemblePlacement) {
        this.setProperty(BKDL_ROW_AWARE_ENSEMBLE_PLACEMENT, enableRowAwareEnsemblePlacement);
        return this;
    }

    public Class<? extends DNSToSwitchMapping> getEnsemblePlacementDnsResolverClass() throws ConfigurationException {
        Class defaultResolverCls = this.getRowAwareEnsemblePlacementEnabled() ? DNSResolverForRows.class : DNSResolverForRacks.class;
        return ReflectionUtils.getClass((Configuration)this, (String)BKDL_ENSEMBLE_PLACEMENT_DNS_RESOLVER_CLASS, defaultResolverCls, DNSToSwitchMapping.class, (ClassLoader)defaultLoader);
    }

    public DistributedLogConfiguration setEnsemblePlacementDnsResolverClass(Class<? extends DNSToSwitchMapping> dnsResolverClass) {
        this.setProperty(BKDL_ENSEMBLE_PLACEMENT_DNS_RESOLVER_CLASS, dnsResolverClass.getName());
        return this;
    }

    public String getBkDNSResolverOverrides() {
        return this.getString(BKDL_BK_DNS_RESOLVER_OVERRIDES, "");
    }

    public DistributedLogConfiguration setBkDNSResolverOverrides(String overrides) {
        this.setProperty(BKDL_BK_DNS_RESOLVER_OVERRIDES, overrides);
        return this;
    }

    public DistributedLogConfiguration setBKDigestPW(String bkDigestPW) {
        this.setProperty(BKDL_BOOKKEEPER_DIGEST_PW, bkDigestPW);
        return this;
    }

    public String getBKDigestPW() {
        return this.getString(BKDL_BOOKKEEPER_DIGEST_PW, "");
    }

    public int getBKClientNumberIOThreads() {
        return this.getInt(BKDL_BKCLIENT_NUM_IO_THREADS, this.getNumWorkerThreads());
    }

    public DistributedLogConfiguration setBKClientNumberIOThreads(int numThreads) {
        this.setProperty(BKDL_BKCLIENT_NUM_IO_THREADS, numThreads);
        return this;
    }

    public long getTimeoutTimerTickDurationMs() {
        return this.getLong(BKDL_TIMEOUT_TIMER_TICK_DURATION_MS, 100L);
    }

    public DistributedLogConfiguration setTimeoutTimerTickDurationMs(long tickDuration) {
        this.setProperty(BKDL_TIMEOUT_TIMER_TICK_DURATION_MS, tickDuration);
        return this;
    }

    public int getTimeoutTimerNumTicks() {
        return this.getInt(BKDL_TIMEOUT_TIMER_NUM_TICKS, 1024);
    }

    public DistributedLogConfiguration setTimeoutTimerNumTicks(int numTicks) {
        this.setProperty(BKDL_TIMEOUT_TIMER_NUM_TICKS, numTicks);
        return this;
    }

    public int getBKClientReadTimeout() {
        return this.getInt(BKDL_BKCLIENT_READ_TIMEOUT, 10);
    }

    public DistributedLogConfiguration setBKClientReadTimeout(int readTimeout) {
        this.setProperty(BKDL_BKCLIENT_READ_TIMEOUT, readTimeout);
        return this;
    }

    public int getBKClientWriteTimeout() {
        return this.getInt(BKDL_BKCLIENT_WRITE_TIMEOUT, 10);
    }

    public DistributedLogConfiguration setBKClientWriteTimeout(int writeTimeout) {
        this.setProperty(BKDL_BKCLIENT_WRITE_TIMEOUT, writeTimeout);
        return this;
    }

    public int getBKClientNumberWorkerThreads() {
        return this.getInt(BKDL_BKCLIENT_NUM_WORKER_THREADS, 1);
    }

    public DistributedLogConfiguration setBKClientNumberWorkerThreads(int numThreads) {
        this.setProperty(BKDL_BKCLIENT_NUM_WORKER_THREADS, numThreads);
        return this;
    }

    public int getNumWorkerThreads() {
        return this.getInt(BKDL_NUM_WORKER_THREADS, Runtime.getRuntime().availableProcessors());
    }

    public DistributedLogConfiguration setNumWorkerThreads(int numWorkerThreads) {
        this.setProperty(BKDL_NUM_WORKER_THREADS, numWorkerThreads);
        return this;
    }

    @Deprecated
    public int getNumReadAheadWorkerThreads() {
        return this.getInt(BKDL_NUM_READAHEAD_WORKER_THREADS, 0);
    }

    @Deprecated
    public DistributedLogConfiguration setNumReadAheadWorkerThreads(int numWorkerThreads) {
        this.setProperty(BKDL_NUM_READAHEAD_WORKER_THREADS, numWorkerThreads);
        return this;
    }

    public int getNumLockStateThreads() {
        return this.getInt(BKDL_NUM_LOCKSTATE_THREADS, 1);
    }

    public DistributedLogConfiguration setNumLockStateThreads(int numLockStateThreads) {
        this.setProperty(BKDL_NUM_LOCKSTATE_THREADS, numLockStateThreads);
        return this;
    }

    public int getNumResourceReleaseThreads() {
        return this.getInt(BKDL_NUM_RESOURCE_RELEASE_THREADS, 0);
    }

    public DistributedLogConfiguration setNumResourceReleaseThreads(int numResourceReleaseThreads) {
        this.setProperty(BKDL_NUM_RESOURCE_RELEASE_THREADS, numResourceReleaseThreads);
        return this;
    }

    public int getSchedulerShutdownTimeoutMs() {
        return this.getInt(BKDL_SCHEDULER_SHUTDOWN_TIMEOUT_MS, 5000);
    }

    public DistributedLogConfiguration setSchedulerShutdownTimeoutMs(int timeoutMs) {
        this.setProperty(BKDL_SCHEDULER_SHUTDOWN_TIMEOUT_MS, timeoutMs);
        return this;
    }

    public boolean getUseDaemonThread() {
        return this.getBoolean(BKDL_USE_DAEMON_THREAD, false);
    }

    public DistributedLogConfiguration setUseDaemonThread(boolean daemon) {
        this.setProperty(BKDL_USE_DAEMON_THREAD, daemon);
        return this;
    }

    public int getDLLedgerMetadataLayoutVersion() {
        return this.getInt(BKDL_LEDGER_METADATA_LAYOUT_VERSION, this.getInt(BKDL_LEDGER_METADATA_LAYOUT_VERSION_OLD, BKDL_LEDGER_METADATA_LAYOUT_VERSION_DEFAULT));
    }

    public DistributedLogConfiguration setDLLedgerMetadataLayoutVersion(int layoutVersion) throws IllegalArgumentException {
        if (layoutVersion <= 0 || layoutVersion > LogSegmentMetadata.LEDGER_METADATA_CURRENT_LAYOUT_VERSION) {
            throw new IllegalArgumentException("Incorrect value for ledger metadata layout version");
        }
        this.setProperty(BKDL_LEDGER_METADATA_LAYOUT_VERSION, layoutVersion);
        return this;
    }

    public boolean getDLLedgerMetadataSkipMinVersionCheck() {
        return this.getBoolean(BKDL_LEDGER_METADATA_SKIP_MIN_VERSION_CHECK, false);
    }

    public DistributedLogConfiguration setDLLedgerMetadataSkipMinVersionCheck(boolean skipMinVersionCheck) throws IllegalArgumentException {
        this.setProperty(BKDL_LEDGER_METADATA_SKIP_MIN_VERSION_CHECK, skipMinVersionCheck);
        return this;
    }

    public long getFirstLogSegmentSequenceNumber() {
        return this.getLong(BKDL_FIRST_LOGSEGMENT_SEQUENCE_NUMBER, this.getLong(BKDL_FIRST_LOGSEGMENT_SEQUENCE_NUMBER_OLD, 1L));
    }

    public DistributedLogConfiguration setFirstLogSegmentSequenceNumber(long firstLogSegmentSequenceNumber) throws IllegalArgumentException {
        if (firstLogSegmentSequenceNumber <= 0L) {
            throw new IllegalArgumentException("Incorrect value for ledger sequence number");
        }
        this.setProperty(BKDL_FIRST_LOGSEGMENT_SEQUENCE_NUMBER, firstLogSegmentSequenceNumber);
        return this;
    }

    public boolean isLogSegmentSequenceNumberValidationEnabled() {
        return this.getBoolean(BKDL_LOGSEGMENT_SEQUENCE_NUMBER_VALIDATION_ENABLED, true);
    }

    public DistributedLogConfiguration setLogSegmentSequenceNumberValidationEnabled(boolean enabled) {
        this.setProperty(BKDL_LOGSEGMENT_SEQUENCE_NUMBER_VALIDATION_ENABLED, enabled);
        return this;
    }

    public boolean getEnableRecordCounts() {
        return this.getBoolean(BKDL_ENABLE_RECORD_COUNTS, true);
    }

    public DistributedLogConfiguration setEnableRecordCounts(boolean enableRecordCounts) {
        this.setProperty(BKDL_ENABLE_RECORD_COUNTS, enableRecordCounts);
        return this;
    }

    @Deprecated
    public boolean getSanityCheckTxnID() {
        return this.getBoolean(BKDL_MAXID_SANITYCHECK, true);
    }

    @Deprecated
    public DistributedLogConfiguration setSanityCheckTxnID(boolean enabled) {
        this.setProperty(BKDL_MAXID_SANITYCHECK, enabled);
        return this;
    }

    public boolean getEncodeRegionIDInLogSegmentMetadata() {
        return this.getBoolean(BKDL_ENCODE_REGION_ID_IN_VERSION, false);
    }

    public DistributedLogConfiguration setEncodeRegionIDInLogSegmentMetadata(boolean enabled) {
        this.setProperty(BKDL_ENCODE_REGION_ID_IN_VERSION, enabled);
        return this;
    }

    public int getLogSegmentNameVersion() {
        return this.getInt(BKDL_LOGSEGMENT_NAME_VERSION, 1);
    }

    public DistributedLogConfiguration setLogSegmentNameVersion(int version) {
        this.setProperty(BKDL_LOGSEGMENT_NAME_VERSION, version);
        return this;
    }

    public String getUnpartitionedStreamName() {
        return this.getString(BKDL_UNPARTITIONED_STREAM_NAME, BKDL_UNPARTITIONED_STREAM_NAME_DEFAULT);
    }

    public DistributedLogConfiguration setUnpartitionedStreamName(String streamName) {
        this.setProperty(BKDL_UNPARTITIONED_STREAM_NAME, streamName);
        return this;
    }

    public long getLogSegmentCacheTTLMs() {
        return this.getLong(BKDL_LOGSEGMENT_CACHE_TTL_MS, 10000L);
    }

    public DistributedLogConfiguration setLogSegmentCacheTTLMs(long ttlMs) {
        this.setProperty(BKDL_LOGSEGMENT_CACHE_TTL_MS, ttlMs);
        return this;
    }

    public long getLogSegmentCacheMaxSize() {
        return this.getLong(BKDL_LOGSEGMENT_CACHE_MAX_SIZE, 10000L);
    }

    public DistributedLogConfiguration setLogSegmentCacheMaxSize(long maxSize) {
        this.setProperty(BKDL_LOGSEGMENT_CACHE_MAX_SIZE, maxSize);
        return this;
    }

    public boolean isLogSegmentCacheEnabled() {
        return this.getBoolean(BKDL_LOGSEGMENT_CACHE_ENABLED, true);
    }

    public DistributedLogConfiguration setLogSegmentCacheEnabled(boolean enabled) {
        this.setProperty(BKDL_LOGSEGMENT_CACHE_ENABLED, enabled);
        return this;
    }

    public boolean getCreateStreamIfNotExists() {
        return this.getBoolean(BKDL_CREATE_STREAM_IF_NOT_EXISTS, true);
    }

    public DistributedLogConfiguration setCreateStreamIfNotExists(boolean enabled) {
        this.setProperty(BKDL_CREATE_STREAM_IF_NOT_EXISTS, enabled);
        return this;
    }

    public int getLogFlushTimeoutSeconds() {
        return this.getInt(BKDL_LOG_FLUSH_TIMEOUT, 30);
    }

    public DistributedLogConfiguration setLogFlushTimeoutSeconds(int logFlushTimeoutSeconds) {
        this.setProperty(BKDL_LOG_FLUSH_TIMEOUT, logFlushTimeoutSeconds);
        return this;
    }

    public String getCompressionType() {
        return this.getString(BKDL_COMPRESSION_TYPE, BKDL_COMPRESSION_TYPE_DEFAULT);
    }

    public DistributedLogConfiguration setCompressionType(String compressionType) {
        Preconditions.checkArgument((null != compressionType && !compressionType.isEmpty() ? 1 : 0) != 0);
        this.setProperty(BKDL_COMPRESSION_TYPE, compressionType);
        return this;
    }

    public boolean getFailFastOnStreamNotReady() {
        return this.getBoolean(BKDL_FAILFAST_ON_STREAM_NOT_READY, false);
    }

    public DistributedLogConfiguration setFailFastOnStreamNotReady(boolean failFastOnStreamNotReady) {
        this.setProperty(BKDL_FAILFAST_ON_STREAM_NOT_READY, failFastOnStreamNotReady);
        return this;
    }

    public boolean getDisableRollingOnLogSegmentError() {
        return this.getBoolean(BKDL_DISABLE_ROLLING_ON_LOG_SEGMENT_ERROR, false);
    }

    public DistributedLogConfiguration setDisableRollingOnLogSegmentError(boolean disableRollingOnLogSegmentError) {
        this.setProperty(BKDL_DISABLE_ROLLING_ON_LOG_SEGMENT_ERROR, disableRollingOnLogSegmentError);
        return this;
    }

    public boolean isDurableWriteEnabled() {
        return this.getBoolean(BKDL_IS_DURABLE_WRITE_ENABLED, true);
    }

    public DistributedLogConfiguration setDurableWriteEnabled(boolean enabled) {
        this.setProperty(BKDL_IS_DURABLE_WRITE_ENABLED, enabled);
        return this;
    }

    public int getOutputBufferSize() {
        return this.getInt(BKDL_OUTPUT_BUFFER_SIZE, this.getInt(BKDL_OUTPUT_BUFFER_SIZE_OLD, 1024));
    }

    public DistributedLogConfiguration setOutputBufferSize(int opBufferSize) {
        this.setProperty(BKDL_OUTPUT_BUFFER_SIZE, opBufferSize);
        return this;
    }

    public int getPeriodicFlushFrequencyMilliSeconds() {
        return this.getInt(BKDL_PERIODIC_FLUSH_FREQUENCY_MILLISECONDS, 0);
    }

    public DistributedLogConfiguration setPeriodicFlushFrequencyMilliSeconds(int flushFrequencyMs) {
        this.setProperty(BKDL_PERIODIC_FLUSH_FREQUENCY_MILLISECONDS, flushFrequencyMs);
        return this;
    }

    public boolean getImmediateFlushEnabled() {
        return this.getBoolean(BKDL_ENABLE_IMMEDIATE_FLUSH, false);
    }

    public DistributedLogConfiguration setImmediateFlushEnabled(boolean enabled) {
        this.setProperty(BKDL_ENABLE_IMMEDIATE_FLUSH, enabled);
        return this;
    }

    public int getMinDelayBetweenImmediateFlushMs() {
        return this.getInt(BKDL_MINIMUM_DELAY_BETWEEN_IMMEDIATE_FLUSH_MILLISECONDS, 0);
    }

    public DistributedLogConfiguration setMinDelayBetweenImmediateFlushMs(int minDelayMs) {
        this.setProperty(BKDL_MINIMUM_DELAY_BETWEEN_IMMEDIATE_FLUSH_MILLISECONDS, minDelayMs);
        return this;
    }

    public int getPeriodicKeepAliveMilliSeconds() {
        return this.getInt(BKDL_PERIODIC_KEEP_ALIVE_MILLISECONDS, 0);
    }

    public DistributedLogConfiguration setPeriodicKeepAliveMilliSeconds(int keepAliveMs) {
        this.setProperty(BKDL_PERIODIC_KEEP_ALIVE_MILLISECONDS, keepAliveMs);
        return this;
    }

    public int getRetentionPeriodHours() {
        return this.getInt(BKDL_RETENTION_PERIOD_IN_HOURS, this.getInt(BKDL_RETENTION_PERIOD_IN_HOURS_OLD, 72));
    }

    public DistributedLogConfiguration setRetentionPeriodHours(int retentionHours) {
        this.setProperty(BKDL_RETENTION_PERIOD_IN_HOURS, retentionHours);
        return this;
    }

    public boolean getExplicitTruncationByApplication() {
        return this.getBoolean(BKDL_EXPLICIT_TRUNCATION_BY_APPLICATION, false);
    }

    public DistributedLogConfiguration setExplicitTruncationByApplication(boolean enabled) {
        this.setProperty(BKDL_EXPLICIT_TRUNCATION_BY_APPLICATION, enabled);
        return this;
    }

    public int getLogSegmentRollingIntervalMinutes() {
        return this.getInt(BKDL_ROLLING_INTERVAL_IN_MINUTES, this.getInt(BKDL_ROLLING_INTERVAL_IN_MINUTES_OLD, 120));
    }

    public DistributedLogConfiguration setLogSegmentRollingIntervalMinutes(int rollingMinutes) {
        this.setProperty(BKDL_ROLLING_INTERVAL_IN_MINUTES, rollingMinutes);
        return this;
    }

    public long getMaxLogSegmentBytes() {
        long maxBytes = this.getLong(BKDL_MAX_LOGSEGMENT_BYTES, 0x10000000L);
        if (maxBytes <= 0L) {
            maxBytes = 0x10000000L;
        }
        return maxBytes;
    }

    public DistributedLogConfiguration setMaxLogSegmentBytes(long maxBytes) {
        this.setProperty(BKDL_MAX_LOGSEGMENT_BYTES, maxBytes);
        return this;
    }

    public int getLogSegmentRollingConcurrency() {
        return this.getInt(BKDL_LOGSEGMENT_ROLLING_CONCURRENCY, 1);
    }

    public DistributedLogConfiguration setLogSegmentRollingConcurrency(int concurrency) {
        this.setProperty(BKDL_LOGSEGMENT_ROLLING_CONCURRENCY, concurrency);
        return this;
    }

    public boolean isWriteLockEnabled() {
        return this.getBoolean(BKDL_WRITE_LOCK_ENABLED, true);
    }

    public DistributedLogConfiguration setWriteLockEnabled(boolean enabled) {
        this.setProperty(BKDL_WRITE_LOCK_ENABLED, enabled);
        return this;
    }

    public long getLockTimeoutMilliSeconds() {
        return this.getLong(BKDL_LOCK_TIMEOUT, 30L) * 1000L;
    }

    public DistributedLogConfiguration setLockTimeout(long lockTimeout) {
        this.setProperty(BKDL_LOCK_TIMEOUT, lockTimeout);
        return this;
    }

    public long getLockReacquireTimeoutMilliSeconds() {
        return this.getLong(BKDL_LOCK_REACQUIRE_TIMEOUT, 120L) * 1000L;
    }

    public DistributedLogConfiguration setLockReacquireTimeoutSeconds(long lockReacquireTimeout) {
        this.setProperty(BKDL_LOCK_REACQUIRE_TIMEOUT, lockReacquireTimeout);
        return this;
    }

    public long getLockOpTimeoutMilliSeconds() {
        return this.getLong(BKDL_LOCK_OP_TIMEOUT, 120L) * 1000L;
    }

    public DistributedLogConfiguration setLockOpTimeoutSeconds(long lockOpTimeout) {
        this.setProperty(BKDL_LOCK_OP_TIMEOUT, lockOpTimeout);
        return this;
    }

    public boolean getEnableLedgerAllocatorPool() {
        return this.getBoolean(BKDL_ENABLE_LEDGER_ALLOCATOR_POOL, false);
    }

    public DistributedLogConfiguration setEnableLedgerAllocatorPool(boolean enabled) {
        this.setProperty(BKDL_ENABLE_LEDGER_ALLOCATOR_POOL, enabled);
        return this;
    }

    public String getLedgerAllocatorPoolPath() {
        return this.getString(BKDL_LEDGER_ALLOCATOR_POOL_PATH, BKDL_LEDGER_ALLOCATOR_POOL_PATH_DEFAULT);
    }

    public DistributedLogConfiguration setLedgerAllocatorPoolPath(String path) {
        this.setProperty(BKDL_LEDGER_ALLOCATOR_POOL_PATH, path);
        return this;
    }

    public String getLedgerAllocatorPoolName() {
        return this.getString(BKDL_LEDGER_ALLOCATOR_POOL_NAME, BKDL_LEDGER_ALLOCATOR_POOL_NAME_DEFAULT);
    }

    public DistributedLogConfiguration setLedgerAllocatorPoolName(String name) {
        this.setProperty(BKDL_LEDGER_ALLOCATOR_POOL_NAME, name);
        return this;
    }

    public int getLedgerAllocatorPoolCoreSize() {
        return this.getInt(BKDL_LEDGER_ALLOCATOR_POOL_CORE_SIZE, 20);
    }

    public DistributedLogConfiguration setLedgerAllocatorPoolCoreSize(int poolSize) {
        this.setProperty(BKDL_LEDGER_ALLOCATOR_POOL_CORE_SIZE, poolSize);
        return this;
    }

    public int getPerWriterOutstandingWriteLimit() {
        return this.getInt(BKDL_PER_WRITER_OUTSTANDING_WRITE_LIMIT, -1);
    }

    public DistributedLogConfiguration setPerWriterOutstandingWriteLimit(int limit) {
        this.setProperty(BKDL_PER_WRITER_OUTSTANDING_WRITE_LIMIT, limit);
        return this;
    }

    public int getGlobalOutstandingWriteLimit() {
        return this.getInt(BKDL_GLOBAL_OUTSTANDING_WRITE_LIMIT, -1);
    }

    public DistributedLogConfiguration setGlobalOutstandingWriteLimit(int limit) {
        this.setProperty(BKDL_GLOBAL_OUTSTANDING_WRITE_LIMIT, limit);
        return this;
    }

    public boolean getOutstandingWriteLimitDarkmode() {
        return this.getBoolean(BKDL_OUTSTANDING_WRITE_LIMIT_DARKMODE, true);
    }

    public DistributedLogConfiguration setOutstandingWriteLimitDarkmode(boolean darkmoded) {
        this.setProperty(BKDL_OUTSTANDING_WRITE_LIMIT_DARKMODE, darkmoded);
        return this;
    }

    public int getReadLACLongPollTimeout() {
        return this.getInt(BKDL_READLACLONGPOLL_TIMEOUT, 1000);
    }

    public DistributedLogConfiguration setReadLACLongPollTimeout(int readAheadLongPollTimeout) {
        this.setProperty(BKDL_READLACLONGPOLL_TIMEOUT, readAheadLongPollTimeout);
        return this;
    }

    public boolean getDeserializeRecordSetOnReads() {
        return this.getBoolean(BKDL_DESERIALIZE_RECORDSET_ON_READS, true);
    }

    public DistributedLogConfiguration setDeserializeRecordSetOnReads(boolean enabled) {
        this.setProperty(BKDL_DESERIALIZE_RECORDSET_ON_READS, enabled);
        return this;
    }

    public int getReaderIdleWarnThresholdMillis() {
        return this.getInt(BKDL_READER_IDLE_WARN_THRESHOLD_MILLIS, 120000);
    }

    public DistributedLogConfiguration setReaderIdleWarnThresholdMillis(int warnThreshold) {
        this.setProperty(BKDL_READER_IDLE_WARN_THRESHOLD_MILLIS, warnThreshold);
        return this;
    }

    public int getReaderIdleErrorThresholdMillis() {
        return this.getInt(BKDL_READER_IDLE_ERROR_THRESHOLD_MILLIS, Integer.MAX_VALUE);
    }

    public DistributedLogConfiguration setReaderIdleErrorThresholdMillis(int warnThreshold) {
        this.setProperty(BKDL_READER_IDLE_ERROR_THRESHOLD_MILLIS, warnThreshold);
        return this;
    }

    public boolean getIgnoreTruncationStatus() {
        return this.getBoolean(BKDL_READER_IGNORE_TRUNCATION_STATUS, false);
    }

    public DistributedLogConfiguration setIgnoreTruncationStatus(boolean ignoreTruncationStatus) {
        this.setProperty(BKDL_READER_IGNORE_TRUNCATION_STATUS, ignoreTruncationStatus);
        return this;
    }

    public boolean getAlertWhenPositioningOnTruncated() {
        return this.getBoolean(BKDL_READER_ALERT_POSITION_ON_TRUNCATED, true);
    }

    public DistributedLogConfiguration setAlertWhenPositioningOnTruncated(boolean alertWhenPositioningOnTruncated) {
        this.setProperty(BKDL_READER_ALERT_POSITION_ON_TRUNCATED, alertWhenPositioningOnTruncated);
        return this;
    }

    public boolean getPositionGapDetectionEnabled() {
        return this.getBoolean(BKDL_READER_POSITION_GAP_DETECTION_ENABLED, false);
    }

    public DistributedLogConfiguration setPositionGapDetectionEnabled(boolean enabled) {
        this.setProperty(BKDL_READER_POSITION_GAP_DETECTION_ENABLED, enabled);
        return this;
    }

    public DistributedLogConfiguration setEnableReadAhead(boolean enableReadAhead) {
        this.setProperty(BKDL_ENABLE_READAHEAD, enableReadAhead);
        return this;
    }

    public boolean getEnableReadAhead() {
        return this.getBoolean(BKDL_ENABLE_READAHEAD, true);
    }

    public DistributedLogConfiguration setEnableForceRead(boolean enableForceRead) {
        this.setProperty(BKDL_ENABLE_FORCEREAD, enableForceRead);
        return this;
    }

    public boolean getEnableForceRead() {
        return this.getBoolean(BKDL_ENABLE_FORCEREAD, true);
    }

    public int getReadAheadMaxRecords() {
        return this.getInt(BKDL_READAHEAD_MAX_RECORDS, this.getInt(BKDL_READAHEAD_MAX_RECORDS_OLD, 10));
    }

    public DistributedLogConfiguration setReadAheadMaxRecords(int readAheadMaxEntries) {
        this.setProperty(BKDL_READAHEAD_MAX_RECORDS, readAheadMaxEntries);
        return this;
    }

    public int getReadAheadBatchSize() {
        return this.getInt(BKDL_READAHEAD_BATCHSIZE, this.getInt(BKDL_READAHEAD_BATCHSIZE_OLD, 2));
    }

    public DistributedLogConfiguration setReadAheadBatchSize(int readAheadBatchSize) {
        this.setProperty(BKDL_READAHEAD_BATCHSIZE, readAheadBatchSize);
        return this;
    }

    public int getReadAheadWaitTime() {
        return this.getInt(BKDL_READAHEAD_WAITTIME, this.getInt(BKDL_READAHEAD_WAITTIME_OLD, 200));
    }

    public DistributedLogConfiguration setReadAheadWaitTime(int readAheadWaitTime) {
        this.setProperty(BKDL_READAHEAD_WAITTIME, readAheadWaitTime);
        return this;
    }

    public int getReadAheadWaitTimeOnEndOfStream() {
        return this.getInt(BKDL_READAHEAD_WAITTIME_ON_ENDOFSTREAM, this.getInt(BKDL_READAHEAD_WAITTIME_ON_ENDOFSTREAM_OLD, 10000));
    }

    public DistributedLogConfiguration setReadAheadWaitTimeOnEndOfStream(int waitTime) {
        this.setProperty(BKDL_READAHEAD_WAITTIME_ON_ENDOFSTREAM, waitTime);
        return this;
    }

    public int getReadAheadNoSuchLedgerExceptionOnReadLACErrorThresholdMillis() {
        return this.getInt(BKDL_READAHEAD_NOSUCHLEDGER_EXCEPTION_ON_READLAC_ERROR_THRESHOLD_MILLIS, 10000);
    }

    public DistributedLogConfiguration setReadAheadNoSuchLedgerExceptionOnReadLACErrorThresholdMillis(long thresholdMillis) {
        this.setProperty(BKDL_READAHEAD_NOSUCHLEDGER_EXCEPTION_ON_READLAC_ERROR_THRESHOLD_MILLIS, thresholdMillis);
        return this;
    }

    public boolean getReadAheadSkipBrokenEntries() {
        return this.getBoolean(BKDL_READAHEAD_SKIP_BROKEN_ENTRIES, false);
    }

    public DistributedLogConfiguration setReadAheadSkipBrokenEntries(boolean enabled) {
        this.setProperty(BKDL_READAHEAD_SKIP_BROKEN_ENTRIES, enabled);
        return this;
    }

    public int getNumPrefetchEntriesPerLogSegment() {
        return this.getInt(BKDL_NUM_PREFETCH_ENTRIES_PER_LOGSEGMENT, 4);
    }

    public DistributedLogConfiguration setNumPrefetchEntriesPerLogSegment(int numEntries) {
        this.setProperty(BKDL_NUM_PREFETCH_ENTRIES_PER_LOGSEGMENT, numEntries);
        return this;
    }

    public int getMaxPrefetchEntriesPerLogSegment() {
        return this.getInt(BKDL_MAX_PREFETCH_ENTRIES_PER_LOGSEGMENT, 32);
    }

    public DistributedLogConfiguration setMaxPrefetchEntriesPerLogSegment(int numEntries) {
        this.setProperty(BKDL_MAX_PREFETCH_ENTRIES_PER_LOGSEGMENT, numEntries);
        return this;
    }

    public int getFirstNumEntriesPerReadLastRecordScan() {
        return this.getInt(BKDL_FIRST_NUM_ENTRIES_PER_READ_LAST_RECORD_SCAN, 2);
    }

    public DistributedLogConfiguration setFirstNumEntriesPerReadLastRecordScan(int numEntries) {
        this.setProperty(BKDL_FIRST_NUM_ENTRIES_PER_READ_LAST_RECORD_SCAN, numEntries);
        return this;
    }

    public int getMaxNumEntriesPerReadLastRecordScan() {
        return this.getInt(BKDL_MAX_NUM_ENTRIES_PER_READ_LAST_RECORD_SCAN, 16);
    }

    public DistributedLogConfiguration setMaxNumEntriesPerReadLastRecordScan(int numEntries) {
        this.setProperty(BKDL_MAX_NUM_ENTRIES_PER_READ_LAST_RECORD_SCAN, numEntries);
        return this;
    }

    public long getCheckLogExistenceBackoffStartMillis() {
        return this.getLong(BKDL_CHECK_LOG_EXISTENCE_BACKOFF_START_MS, 200L);
    }

    public DistributedLogConfiguration setCheckLogExistenceBackoffStartMillis(long backoffMillis) {
        this.setProperty(BKDL_CHECK_LOG_EXISTENCE_BACKOFF_START_MS, backoffMillis);
        return this;
    }

    public long getCheckLogExistenceBackoffMaxMillis() {
        return this.getLong(BKDL_CHECK_LOG_EXISTENCE_BACKOFF_MAX_MS, 1000L);
    }

    public DistributedLogConfiguration setCheckLogExistenceBackoffMaxMillis(long backoffMillis) {
        this.setProperty(BKDL_CHECK_LOG_EXISTENCE_BACKOFF_MAX_MS, backoffMillis);
        return this;
    }

    public boolean getTraceReadAheadDeliveryLatency() {
        return this.getBoolean(BKDL_TRACE_READAHEAD_DELIVERY_LATENCY, false);
    }

    public DistributedLogConfiguration setTraceReadAheadDeliveryLatency(boolean enabled) {
        this.setProperty(BKDL_TRACE_READAHEAD_DELIVERY_LATENCY, enabled);
        return this;
    }

    public long getMetadataLatencyWarnThresholdMillis() {
        return this.getLong(BKDL_METADATA_LATENCY_WARN_THRESHOLD_MS, BKDL_METADATA_LATENCY_WARN_THRESHOLD_MS_DEFAULT);
    }

    public DistributedLogConfiguration setMetadataLatencyWarnThresholdMillis(long warnThresholdMillis) {
        this.setProperty(BKDL_METADATA_LATENCY_WARN_THRESHOLD_MS, warnThresholdMillis);
        return this;
    }

    public long getDataLatencyWarnThresholdMillis() {
        return this.getLong(BKDL_DATA_LATENCY_WARN_THRESHOLD_MS, BKDL_DATA_LATENCY_WARN_THRESHOLD_MS_DEFAULT);
    }

    public DistributedLogConfiguration setDataLatencyWarnThresholdMillis(long warnThresholdMillis) {
        this.setProperty(BKDL_DATA_LATENCY_WARN_THRESHOLD_MS, warnThresholdMillis);
        return this;
    }

    public boolean getTraceReadAheadMetadataChanges() {
        return this.getBoolean(BKDL_TRACE_READAHEAD_METADATA_CHANGES, false);
    }

    public DistributedLogConfiguration setTraceReadAheadMetadataChanges(boolean enabled) {
        this.setProperty(BKDL_TRACE_READAHEAD_METADATA_CHANGES, enabled);
        return this;
    }

    public boolean getEnableTaskExecutionStats() {
        return this.getBoolean(BKDL_ENABLE_TASK_EXECUTION_STATS, false);
    }

    public DistributedLogConfiguration setEnableTaskExecutionStats(boolean enabled) {
        this.setProperty(BKDL_ENABLE_TASK_EXECUTION_STATS, enabled);
        return this;
    }

    public long getTaskExecutionWarnTimeMicros() {
        return this.getLong(BKDL_TASK_EXECUTION_WARN_TIME_MICROS, 100000L);
    }

    public DistributedLogConfiguration setTaskExecutionWarnTimeMicros(long warnTimeMicros) {
        this.setProperty(BKDL_TASK_EXECUTION_WARN_TIME_MICROS, warnTimeMicros);
        return this;
    }

    public boolean getEnablePerStreamStat() {
        return this.getBoolean(BKDL_ENABLE_PERSTREAM_STAT, false);
    }

    public DistributedLogConfiguration setEnablePerStreamStat(boolean enabled) {
        this.setProperty(BKDL_ENABLE_PERSTREAM_STAT, enabled);
        return this;
    }

    public Class<? extends FeatureProvider> getFeatureProviderClass() throws ConfigurationException {
        return ReflectionUtils.getClass((Configuration)this, (String)BKDL_FEATURE_PROVIDER_CLASS, DefaultFeatureProvider.class, FeatureProvider.class, (ClassLoader)FeatureProvider.class.getClassLoader());
    }

    public DistributedLogConfiguration setFeatureProviderClass(Class<? extends FeatureProvider> providerClass) {
        this.setProperty(BKDL_FEATURE_PROVIDER_CLASS, providerClass.getName());
        return this;
    }

    public String getFileFeatureProviderBaseConfigPath() {
        return this.getString(BKDL_FILE_FEATURE_PROVIDER_BASE_CONFIG_PATH, BKDL_FILE_FEATURE_PROVIDER_BASE_CONFIG_PATH_DEFAULT);
    }

    public DistributedLogConfiguration setFileFeatureProviderBaseConfigPath(String configPath) {
        this.setProperty(BKDL_FILE_FEATURE_PROVIDER_BASE_CONFIG_PATH, configPath);
        return this;
    }

    public String getFileFeatureProviderOverlayConfigPath() {
        return this.getString(BKDL_FILE_FEATURE_PROVIDER_OVERLAY_CONFIG_PATH, BKDL_FILE_FEATURE_PROVIDER_OVERLAY_CONFIG_PATH_DEFAULT);
    }

    public DistributedLogConfiguration setFileFeatureProviderOverlayConfigPath(String configPath) {
        this.setProperty(BKDL_FILE_FEATURE_PROVIDER_OVERLAY_CONFIG_PATH, configPath);
        return this;
    }

    public boolean isFederatedNamespaceEnabled() {
        return this.getBoolean(BKDL_FEDERATED_NAMESPACE_ENABLED, false);
    }

    public DistributedLogConfiguration setFederatedNamespaceEnabled(boolean enabled) {
        this.setProperty(BKDL_FEDERATED_NAMESPACE_ENABLED, enabled);
        return this;
    }

    public int getFederatedMaxLogsPerSubnamespace() {
        return this.getInt(BKDL_FEDERATED_MAX_LOGS_PER_SUBNAMESPACE, 15000);
    }

    public DistributedLogConfiguration setFederatedMaxLogsPerSubnamespace(int maxLogs) {
        this.setProperty(BKDL_FEDERATED_MAX_LOGS_PER_SUBNAMESPACE, maxLogs);
        return this;
    }

    public boolean getFederatedCheckExistenceWhenCacheMiss() {
        return this.getBoolean(BKDL_FEDERATED_CHECK_EXISTENCE_WHEN_CACHE_MISS, true);
    }

    public DistributedLogConfiguration setFederatedCheckExistenceWhenCacheMiss(boolean enabled) {
        this.setProperty(BKDL_FEDERATED_CHECK_EXISTENCE_WHEN_CACHE_MISS, enabled);
        return this;
    }

    public int getDynamicConfigReloadIntervalSec() {
        return this.getInt(BKDL_DYNAMIC_CONFIG_RELOAD_INTERVAL_SEC, 60);
    }

    public DistributedLogConfiguration setDynamicConfigReloadIntervalSec(int intervalSec) {
        this.setProperty(BKDL_DYNAMIC_CONFIG_RELOAD_INTERVAL_SEC, intervalSec);
        return this;
    }

    public String getStreamConfigRouterClass() {
        return this.getString(BKDL_STREAM_CONFIG_ROUTER_CLASS, BKDL_STREAM_CONFIG_ROUTER_CLASS_DEFAULT);
    }

    public DistributedLogConfiguration setStreamConfigRouterClass(String routerClass) {
        this.setProperty(BKDL_STREAM_CONFIG_ROUTER_CLASS, routerClass);
        return this;
    }

    public int getBpsSoftWriteLimit() {
        return this.getInt(BKDL_BPS_SOFT_WRITE_LIMIT, -1);
    }

    public int getBpsHardWriteLimit() {
        return this.getInt(BKDL_BPS_HARD_WRITE_LIMIT, -1);
    }

    public int getRpsSoftWriteLimit() {
        return this.getInt(BKDL_RPS_SOFT_WRITE_LIMIT, -1);
    }

    public int getRpsHardWriteLimit() {
        return this.getInt(BKDL_RPS_HARD_WRITE_LIMIT, -1);
    }

    public int getMaxAcquiredPartitionsPerProxy() {
        return this.getInt(BKDL_MAX_ACQUIRED_PARTITIONS_PER_PROXY, -1);
    }

    public DistributedLogConfiguration setMaxAcquiredPartitionsPerProxy(int numPartitions) {
        this.setProperty(BKDL_MAX_ACQUIRED_PARTITIONS_PER_PROXY, numPartitions);
        return this;
    }

    public int getMaxCachedPartitionsPerProxy() {
        return this.getInt(BKDL_MAX_CACHED_PARTITIONS_PER_PROXY, -1);
    }

    public DistributedLogConfiguration setMaxCachedPartitionsPerProxy(int numPartitions) {
        this.setProperty(BKDL_MAX_CACHED_PARTITIONS_PER_PROXY, numPartitions);
        return this;
    }

    public boolean getEIInjectWriteDelay() {
        return this.getBoolean(BKDL_EI_INJECT_WRITE_DELAY, false);
    }

    public double getEIInjectedWriteDelayPercent() {
        return this.getDouble(BKDL_EI_INJECTED_WRITE_DELAY_PERCENT, 0.0);
    }

    public DistributedLogConfiguration setEIInjectedWriteDelayPercent(double percent) {
        this.setProperty(BKDL_EI_INJECTED_WRITE_DELAY_PERCENT, percent);
        return this;
    }

    public int getEIInjectedWriteDelayMs() {
        return this.getInt(BKDL_EI_INJECTED_WRITE_DELAY_MS, 0);
    }

    public DistributedLogConfiguration setEIInjectedWriteDelayMs(int delayMs) {
        this.setProperty(BKDL_EI_INJECTED_WRITE_DELAY_MS, delayMs);
        return this;
    }

    public boolean getEIInjectReadAheadStall() {
        return this.getBoolean(BKDL_EI_INJECT_READAHEAD_STALL, false);
    }

    public DistributedLogConfiguration setEIInjectReadAheadStall(boolean enabled) {
        this.setProperty(BKDL_EI_INJECT_READAHEAD_STALL, enabled);
        return this;
    }

    public boolean getEIInjectReadAheadBrokenEntries() {
        return this.getBoolean(BKDL_EI_INJECT_READAHEAD_BROKEN_ENTRIES, false);
    }

    public DistributedLogConfiguration setEIInjectReadAheadBrokenEntries(boolean enabled) {
        this.setProperty(BKDL_EI_INJECT_READAHEAD_BROKEN_ENTRIES, enabled);
        return this;
    }

    public boolean getEIInjectReadAheadDelay() {
        return this.getBoolean(BKDL_EI_INJECT_READAHEAD_DELAY, false);
    }

    public DistributedLogConfiguration setEIInjectReadAheadDelay(boolean enabled) {
        this.setProperty(BKDL_EI_INJECT_READAHEAD_DELAY, enabled);
        return this;
    }

    public int getEIInjectMaxReadAheadDelayMs() {
        return this.getInt(BKDL_EI_INJECT_MAX_READAHEAD_DELAY_MS, 0);
    }

    public DistributedLogConfiguration setEIInjectMaxReadAheadDelayMs(int delayMs) {
        this.setProperty(BKDL_EI_INJECT_MAX_READAHEAD_DELAY_MS, delayMs);
        return this;
    }

    public int getEIInjectReadAheadDelayPercent() {
        return this.getInt(BKDL_EI_INJECT_READAHEAD_DELAY_PERCENT, 10);
    }

    public DistributedLogConfiguration setEIInjectReadAheadDelayPercent(int percent) {
        this.setProperty(BKDL_EI_INJECT_READAHEAD_DELAY_PERCENT, percent);
        return this;
    }

    public void validate() {
        Preconditions.checkArgument((this.getBKClientReadTimeout() * 1000 >= this.getReadLACLongPollTimeout() ? 1 : 0) != 0, (Object)("Invalid timeout configuration: bkcReadTimeoutSeconds (" + this.getBKClientReadTimeout() + ") should be longer than readLACLongPollTimeout (" + this.getReadLACLongPollTimeout() + ")"));
        long readerIdleWarnThresholdMs = this.getReaderIdleWarnThresholdMillis();
        if (readerIdleWarnThresholdMs > 0L) {
            Preconditions.checkArgument((readerIdleWarnThresholdMs > (long)(2 * this.getReadLACLongPollTimeout()) ? 1 : 0) != 0, (Object)"Invalid configuration: ReaderIdleWarnThreshold should be 2x larget than readLACLongPollTimeout");
        }
    }

    static {
        if (null == defaultLoader) {
            defaultLoader = DistributedLogConfiguration.class.getClassLoader();
        }
        BKDL_ZK_ACL_ID_DEFAULT = null;
        BKDL_ENSEMBLE_PLACEMENT_DNS_RESOLVER_CLASS_DEFAULT = DNSResolverForRacks.class.getName();
        BKDL_LEDGER_METADATA_LAYOUT_VERSION_DEFAULT = LogSegmentMetadata.LogSegmentMetadataVersion.VERSION_V5_SEQUENCE_ID.value;
        BKDL_LEDGER_ALLOCATOR_POOL_NAME_DEFAULT = null;
        BKDL_METADATA_LATENCY_WARN_THRESHOLD_MS_DEFAULT = DistributedLogConstants.LATENCY_WARN_THRESHOLD_IN_MILLIS;
        BKDL_DATA_LATENCY_WARN_THRESHOLD_MS_DEFAULT = 2L * DistributedLogConstants.LATENCY_WARN_THRESHOLD_IN_MILLIS;
        BKDL_FILE_FEATURE_PROVIDER_OVERLAY_CONFIG_PATH_DEFAULT = null;
        streamSettings = Sets.newHashSet((Object[])new String[]{BKDL_READER_POSITION_GAP_DETECTION_ENABLED, BKDL_READER_IDLE_ERROR_THRESHOLD_MILLIS, BKDL_READER_IDLE_WARN_THRESHOLD_MILLIS, BKDL_PERIODIC_FLUSH_FREQUENCY_MILLISECONDS, BKDL_ENABLE_IMMEDIATE_FLUSH});
    }
}

