/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.distributedlog.BKAsyncLogWriter;
import org.apache.distributedlog.BKDistributedLogManager;
import org.apache.distributedlog.BKLogWriteHandler;
import org.apache.distributedlog.BKSyncLogReader;
import org.apache.distributedlog.DLMTestUtil;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.LogRecord;
import org.apache.distributedlog.LogRecordWithDLSN;
import org.apache.distributedlog.api.DistributedLogManager;
import org.apache.distributedlog.exceptions.LogEmptyException;
import org.apache.distributedlog.exceptions.LogNotFoundException;
import org.apache.distributedlog.exceptions.LogReadException;
import org.apache.distributedlog.util.Utils;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NonBlockingReadsTestUtil {
    static final Logger LOG = LoggerFactory.getLogger(NonBlockingReadsTestUtil.class);
    static final long DEFAULT_SEGMENT_SIZE = 1000L;

    NonBlockingReadsTestUtil() {
    }

    static void readNonBlocking(DistributedLogManager dlm, boolean forceStall) throws Exception {
        NonBlockingReadsTestUtil.readNonBlocking(dlm, forceStall, 1000L, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void readNonBlocking(DistributedLogManager dlm, boolean forceStall, long segmentSize, boolean waitForIdle) throws Exception {
        BKSyncLogReader reader = null;
        try {
            reader = (BKSyncLogReader)dlm.getInputStream(1L);
        }
        catch (LogNotFoundException logNotFoundException) {
            // empty catch block
        }
        while (null == reader) {
            TimeUnit.MILLISECONDS.sleep(20L);
            try {
                reader = (BKSyncLogReader)dlm.getInputStream(1L);
            }
            catch (LogNotFoundException logNotFoundException) {
            }
            catch (LogEmptyException logEmptyException) {
            }
            catch (IOException ioe) {
                LOG.error("Failed to open reader reading from {}", (Object)dlm.getStreamName());
                throw ioe;
            }
        }
        try {
            LOG.info("Created reader reading from {}", (Object)dlm.getStreamName());
            if (forceStall) {
                reader.getReadHandler().disableReadAheadLogSegmentsNotification();
            }
            long numTrans = 0L;
            long lastTxId = -1L;
            boolean exceptionEncountered = false;
            try {
                while (true) {
                    LogRecordWithDLSN record;
                    if (null != (record = reader.readNext(true))) {
                        DLMTestUtil.verifyLogRecord((LogRecord)record);
                        Assert.assertTrue((lastTxId < record.getTransactionId() ? 1 : 0) != 0);
                        Assert.assertEquals((long)(record.getTransactionId() - 1L), (long)record.getSequenceId());
                        lastTxId = record.getTransactionId();
                        ++numTrans;
                        continue;
                    }
                    if (numTrans >= 3L * segmentSize) {
                        if (waitForIdle) {
                            while (true) {
                                reader.readNext(true);
                                TimeUnit.MILLISECONDS.sleep(10L);
                            }
                        }
                        break;
                    }
                    TimeUnit.MILLISECONDS.sleep(2L);
                }
            }
            catch (LogReadException readexc) {
                exceptionEncountered = true;
            }
            catch (LogNotFoundException exc) {
                exceptionEncountered = true;
            }
            Assert.assertFalse((boolean)exceptionEncountered);
        }
        finally {
            reader.close();
        }
    }

    static void writeRecordsForNonBlockingReads(DistributedLogConfiguration conf, DistributedLogManager dlm, boolean recover) throws Exception {
        NonBlockingReadsTestUtil.writeRecordsForNonBlockingReads(conf, dlm, recover, 1000L);
    }

    static void writeRecordsForNonBlockingReads(DistributedLogConfiguration conf, DistributedLogManager dlm, boolean recover, long segmentSize) throws Exception {
        long txId = 1L;
        for (long i = 0L; i < 3L; ++i) {
            BKAsyncLogWriter writer = (BKAsyncLogWriter)dlm.startAsyncLogSegmentNonPartitioned();
            for (long j = 1L; j < segmentSize; ++j) {
                Utils.ioResult((CompletableFuture)writer.write(DLMTestUtil.getLogRecordInstance(txId++)));
            }
            if (recover) {
                Utils.ioResult((CompletableFuture)writer.write(DLMTestUtil.getLogRecordInstance(txId++)));
                TimeUnit.MILLISECONDS.sleep(300L);
                writer.abort();
                LOG.debug("Recovering Segments");
                BKLogWriteHandler blplm = ((BKDistributedLogManager)dlm).createWriteHandler(true);
                Utils.ioResult((CompletableFuture)blplm.recoverIncompleteLogSegments());
                Utils.ioResult((CompletableFuture)blplm.asyncClose());
                LOG.debug("Recovered Segments");
            } else {
                Utils.ioResult((CompletableFuture)writer.write(DLMTestUtil.getLogRecordInstance(txId++)));
                writer.closeAndComplete();
            }
            TimeUnit.MILLISECONDS.sleep(300L);
        }
    }
}

