/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.cli.helpers;

import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import org.apache.bookkeeper.net.BookieSocketAddress;

public final class CommandHelpers {
    private static final String UNKNOWN = "UNKNOWN";

    public static String getBookieSocketAddrStringRepresentation(BookieSocketAddress bookieId) {
        String realHostname;
        String hostname = bookieId.getHostName();
        String bookieID = bookieId.toString();
        String ip = null;
        if (InetAddresses.isInetAddress((String)hostname)) {
            ip = hostname;
            realHostname = bookieId.getSocketAddress().getAddress().getCanonicalHostName();
        } else {
            InetAddress ia = bookieId.getSocketAddress().getAddress();
            ip = null != ia ? ia.getHostAddress() : UNKNOWN;
            realHostname = hostname;
        }
        return CommandHelpers.formatBookieSocketAddress(bookieID, ip, bookieId.getPort(), realHostname);
    }

    public static String formatBookieSocketAddress(String bookieId, String ip, int port, String hostName) {
        return String.format("BookieID:%s, IP:%s, Port:%d, Hostname:%s", bookieId, ip, port, hostName);
    }

    private CommandHelpers() {
    }
}

